/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.handler.admin;

import java.io.File;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URISyntaxException;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import org.apache.solr.cloud.ZkSolrResourceLoader;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.cloud.SolrZkClient;
import org.apache.solr.common.params.ModifiableSolrParams;
import org.apache.solr.common.params.SolrParams;
import org.apache.solr.common.util.ContentStreamBase;
import org.apache.solr.common.util.NamedList;
import org.apache.solr.common.util.SimpleOrderedMap;
import org.apache.solr.core.CoreContainer;
import org.apache.solr.core.SolrCore;
import org.apache.solr.core.SolrResourceLoader;
import org.apache.solr.handler.RequestHandlerBase;
import org.apache.solr.request.SolrQueryRequest;
import org.apache.solr.response.SolrQueryResponse;
import org.apache.solr.schema.IndexSchema;
import org.apache.solr.schema.ManagedIndexSchema;
import org.apache.zookeeper.KeeperException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ShowFileRequestHandler
extends RequestHandlerBase {
    public static final String HIDDEN = "hidden";
    public static final String USE_CONTENT_TYPE = "contentType";
    protected Set<String> hiddenFiles;
    protected static final Logger log = LoggerFactory.getLogger(ShowFileRequestHandler.class);

    @Override
    public void init(NamedList args) {
        super.init(args);
        this.hiddenFiles = ShowFileRequestHandler.initHidden(this.invariants);
    }

    public static Set<String> initHidden(SolrParams invariants) {
        String[] hidden;
        HashSet<String> hiddenRet = new HashSet<String>();
        if (invariants != null && (hidden = invariants.getParams(HIDDEN)) != null) {
            for (String s : hidden) {
                hiddenRet.add(s.toUpperCase(Locale.ROOT));
            }
        }
        return hiddenRet;
    }

    @Override
    public void handleRequestBody(SolrQueryRequest req, SolrQueryResponse rsp) throws InterruptedException, KeeperException, IOException {
        CoreContainer coreContainer = req.getCore().getCoreDescriptor().getCoreContainer();
        if (coreContainer.isZooKeeperAware()) {
            this.showFromZooKeeper(req, rsp, coreContainer);
        } else {
            this.showFromFileSystem(req, rsp);
        }
    }

    private void showFromZooKeeper(SolrQueryRequest req, SolrQueryResponse rsp, CoreContainer coreContainer) throws KeeperException, InterruptedException, UnsupportedEncodingException {
        SolrZkClient zkClient = coreContainer.getZkController().getZkClient();
        String adminFile = ShowFileRequestHandler.getAdminFileFromZooKeeper(req, rsp, zkClient, this.hiddenFiles);
        if (adminFile == null) {
            return;
        }
        List<String> children = zkClient.getChildren(adminFile, null, true);
        if (children.size() > 0) {
            SimpleOrderedMap files = new SimpleOrderedMap();
            for (String f : children) {
                if (ShowFileRequestHandler.isHiddenFile(req, rsp, f, false, this.hiddenFiles)) continue;
                SimpleOrderedMap<Comparable<Boolean>> fileInfo = new SimpleOrderedMap<Comparable<Boolean>>();
                files.add(f, fileInfo);
                List<String> fchildren = zkClient.getChildren(adminFile + "/" + f, null, true);
                if (fchildren.size() > 0) {
                    fileInfo.add("directory", Boolean.valueOf(true));
                    continue;
                }
                fileInfo.add("size", Integer.valueOf(f.length()));
            }
            rsp.add("files", files);
        } else {
            ModifiableSolrParams params = new ModifiableSolrParams(req.getParams());
            params.set("wt", "raw");
            req.setParams(params);
            ContentStreamBase.ByteArrayStream content = new ContentStreamBase.ByteArrayStream(zkClient.getData(adminFile, null, null, true), adminFile);
            content.setContentType(req.getParams().get(USE_CONTENT_TYPE));
            rsp.add("content", content);
        }
        rsp.setHttpCaching(false);
    }

    private void showFromFileSystem(SolrQueryRequest req, SolrQueryResponse rsp) {
        File adminFile = ShowFileRequestHandler.getAdminFileFromFileSystem(req, rsp, this.hiddenFiles);
        if (adminFile == null) {
            return;
        }
        if (!adminFile.exists()) {
            log.error("Can not find: " + adminFile.getName() + " [" + adminFile.getAbsolutePath() + "]");
            rsp.setException(new SolrException(SolrException.ErrorCode.NOT_FOUND, "Can not find: " + adminFile.getName() + " [" + adminFile.getAbsolutePath() + "]"));
            return;
        }
        if (!adminFile.canRead() || adminFile.isHidden()) {
            log.error("Can not show: " + adminFile.getName() + " [" + adminFile.getAbsolutePath() + "]");
            rsp.setException(new SolrException(SolrException.ErrorCode.NOT_FOUND, "Can not show: " + adminFile.getName() + " [" + adminFile.getAbsolutePath() + "]"));
            return;
        }
        if (adminFile.isDirectory()) {
            int basePath = adminFile.getAbsolutePath().length() + 1;
            SimpleOrderedMap files = new SimpleOrderedMap();
            for (File f : adminFile.listFiles()) {
                String path = f.getAbsolutePath().substring(basePath);
                path = path.replace('\\', '/');
                if (ShowFileRequestHandler.isHiddenFile(req, rsp, f.getName().replace('\\', '/'), false, this.hiddenFiles)) continue;
                SimpleOrderedMap<Comparable<Boolean>> fileInfo = new SimpleOrderedMap<Comparable<Boolean>>();
                files.add(path, fileInfo);
                if (f.isDirectory()) {
                    fileInfo.add("directory", Boolean.valueOf(true));
                } else {
                    fileInfo.add("size", Long.valueOf(f.length()));
                }
                fileInfo.add("modified", new Date(f.lastModified()));
            }
            rsp.add("files", files);
        } else {
            ModifiableSolrParams params = new ModifiableSolrParams(req.getParams());
            params.set("wt", "raw");
            req.setParams(params);
            ContentStreamBase.FileStream content = new ContentStreamBase.FileStream(adminFile);
            content.setContentType(req.getParams().get(USE_CONTENT_TYPE));
            rsp.add("content", content);
        }
        rsp.setHttpCaching(false);
    }

    public static boolean isHiddenFile(SolrQueryRequest req, SolrQueryResponse rsp, String fnameIn, boolean reportError, Set<String> hiddenFiles) {
        String managed;
        String fname = fnameIn.toUpperCase(Locale.ROOT);
        if (hiddenFiles.contains(fname) || hiddenFiles.contains("*")) {
            if (reportError) {
                log.error("Cannot access " + fname);
                rsp.setException(new SolrException(SolrException.ErrorCode.FORBIDDEN, "Can not access: " + fnameIn));
            }
            return true;
        }
        if (fname.indexOf("..") >= 0 || fname.startsWith(".")) {
            if (reportError) {
                log.error("Invalid path: " + fname);
                rsp.setException(new SolrException(SolrException.ErrorCode.FORBIDDEN, "Invalid path: " + fnameIn));
            }
            return true;
        }
        SolrCore core = req.getCore();
        IndexSchema schema = core.getLatestSchema();
        return schema instanceof ManagedIndexSchema && fname.equalsIgnoreCase(managed = schema.getResourceName());
    }

    public static String getAdminFileFromZooKeeper(SolrQueryRequest req, SolrQueryResponse rsp, SolrZkClient zkClient, Set<String> hiddenFiles) throws KeeperException, InterruptedException {
        String adminFile = null;
        SolrCore core = req.getCore();
        ZkSolrResourceLoader loader = (ZkSolrResourceLoader)core.getResourceLoader();
        String confPath = loader.getCollectionZkPath();
        String fname = req.getParams().get("file", null);
        if (fname == null) {
            adminFile = confPath;
        } else {
            if (ShowFileRequestHandler.isHiddenFile(req, rsp, fname = fname.replace('\\', '/'), true, hiddenFiles)) {
                return null;
            }
            if (fname.startsWith("/")) {
                fname = fname.substring(1);
            }
            adminFile = confPath + "/" + fname;
        }
        if (!zkClient.exists(adminFile, true).booleanValue()) {
            log.error("Can not find: " + adminFile);
            rsp.setException(new SolrException(SolrException.ErrorCode.NOT_FOUND, "Can not find: " + adminFile));
            return null;
        }
        return adminFile;
    }

    public static File getAdminFileFromFileSystem(SolrQueryRequest req, SolrQueryResponse rsp, Set<String> hiddenFiles) {
        String fname;
        File adminFile = null;
        SolrResourceLoader loader = req.getCore().getResourceLoader();
        File configdir = new File(loader.getConfigDir());
        if (!configdir.exists()) {
            try {
                configdir = new File(loader.getClassLoader().getResource(loader.getConfigDir()).toURI());
            }
            catch (URISyntaxException e) {
                log.error("Can not access configuration directory!");
                rsp.setException(new SolrException(SolrException.ErrorCode.FORBIDDEN, "Can not access configuration directory!", (Throwable)e));
                return null;
            }
        }
        if ((fname = req.getParams().get("file", null)) == null) {
            adminFile = configdir;
        } else {
            if (hiddenFiles.contains((fname = fname.replace('\\', '/')).toUpperCase(Locale.ROOT))) {
                log.error("Can not access: " + fname);
                rsp.setException(new SolrException(SolrException.ErrorCode.FORBIDDEN, "Can not access: " + fname));
                return null;
            }
            if (fname.indexOf("..") >= 0) {
                log.error("Invalid path: " + fname);
                rsp.setException(new SolrException(SolrException.ErrorCode.FORBIDDEN, "Invalid path: " + fname));
                return null;
            }
            adminFile = new File(configdir, fname);
        }
        return adminFile;
    }

    public final Set<String> getHiddenFiles() {
        return this.hiddenFiles;
    }

    @Override
    public String getDescription() {
        return "Admin Config File -- view or update config files directly";
    }

    @Override
    public String getSource() {
        return "$URL: https://svn.apache.org/repos/asf/lucene/dev/branches/lucene_solr_4_7/solr/core/src/java/org/apache/solr/handler/admin/ShowFileRequestHandler.java $";
    }
}

