/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.spatial.prefix;

import com.spatial4j.core.shape.Point;
import org.apache.lucene.spatial.prefix.tree.Cell;
import org.apache.lucene.spatial.prefix.tree.SpatialPrefixTree;
import org.apache.lucene.spatial.util.ShapeFieldCacheProvider;
import org.apache.lucene.util.BytesRef;

public class PointPrefixTreeFieldCacheProvider
extends ShapeFieldCacheProvider<Point> {
    final SpatialPrefixTree grid;
    private Cell scanCell = null;

    public PointPrefixTreeFieldCacheProvider(SpatialPrefixTree grid, String shapeField, int defaultSize) {
        super(shapeField, defaultSize);
        this.grid = grid;
    }

    @Override
    protected Point readShape(BytesRef term) {
        this.scanCell = this.grid.getCell(term.bytes, term.offset, term.length, this.scanCell);
        if (this.scanCell.getLevel() == this.grid.getMaxLevels() && !this.scanCell.isLeaf()) {
            return this.scanCell.getCenter();
        }
        return null;
    }
}

