/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.index.solr.osgi;

import java.util.Arrays;
import java.util.Collection;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Property;
import org.apache.felix.scr.annotations.PropertyOption;
import org.apache.felix.scr.annotations.Service;
import org.apache.jackrabbit.oak.plugins.index.solr.configuration.CommitPolicy;
import org.apache.jackrabbit.oak.plugins.index.solr.configuration.DefaultSolrConfiguration;
import org.apache.jackrabbit.oak.plugins.index.solr.configuration.OakSolrConfiguration;
import org.apache.jackrabbit.oak.plugins.index.solr.configuration.OakSolrConfigurationProvider;
import org.apache.jackrabbit.oak.spi.query.Filter;
import org.osgi.service.component.ComponentContext;

@Component(label="Oak Solr indexing / search configuration", metatype=true, immediate=true)
@Service(value={OakSolrConfigurationProvider.class})
public class OakSolrConfigurationProviderService
implements OakSolrConfigurationProvider {
    @Property(value={"path_des"}, label="field for descendants search")
    private static final String PATH_DESCENDANTS_FIELD = "path.desc.field";
    @Property(value={"path_child"}, label="field for children search")
    private static final String PATH_CHILDREN_FIELD = "path.child.field";
    @Property(value={"path_anc"}, label="field for parent search")
    private static final String PATH_PARENT_FIELD = "path.parent.field";
    @Property(value={"path_exact"}, label="field for path search")
    private static final String PATH_EXACT_FIELD = "path.exact.field";
    @Property(value={"catch_all"}, label="catch all field")
    private static final String CATCH_ALL_FIELD = "catch.all.field";
    @Property(options={@PropertyOption(name="HARD", value="Hard commit"), @PropertyOption(name="SOFT", value="Soft commit"), @PropertyOption(name="AUTO", value="Auto commit")}, value={"SOFT"})
    private static final String COMMIT_POLICY = "commit.policy";
    @Property(intValue={100000}, label="rows")
    private static final String ROWS = "rows";
    @Property(boolValue={false}, label="path restrictions")
    private static final String PATH_RESTRICTIONS = "path.restrictions";
    @Property(boolValue={false}, label="property restrictions")
    private static final String PROPERTY_RESTRICTIONS = "property.restrictions";
    @Property(boolValue={false}, label="primary types restrictions")
    private static final String PRIMARY_TYPES_RESTRICTIONS = "primarytypes.restrictions";
    @Property(value={""}, label="ignored properties")
    private static final String IGNORED_PROPERTIES = "ignored.properties";
    private String pathChildrenFieldName;
    private String pathParentFieldName;
    private String pathDescendantsFieldName;
    private String pathExactFieldName;
    private String catchAllField;
    private CommitPolicy commitPolicy;
    private int rows;
    private boolean useForPathRestrictions;
    private boolean useForPropertyRestrictions;
    private boolean useForPrimaryTypes;
    private Collection<String> ignoredProperties;
    private OakSolrConfiguration oakSolrConfiguration;

    @Activate
    protected void activate(ComponentContext componentContext) throws Exception {
        this.pathChildrenFieldName = String.valueOf(componentContext.getProperties().get(PATH_CHILDREN_FIELD));
        this.pathParentFieldName = String.valueOf(componentContext.getProperties().get(PATH_PARENT_FIELD));
        this.pathExactFieldName = String.valueOf(componentContext.getProperties().get(PATH_EXACT_FIELD));
        this.pathDescendantsFieldName = String.valueOf(componentContext.getProperties().get(PATH_DESCENDANTS_FIELD));
        this.catchAllField = String.valueOf(componentContext.getProperties().get(CATCH_ALL_FIELD));
        this.rows = Integer.parseInt(String.valueOf(componentContext.getProperties().get(ROWS)));
        this.commitPolicy = CommitPolicy.valueOf(String.valueOf(componentContext.getProperties().get(COMMIT_POLICY)));
        this.useForPathRestrictions = Boolean.valueOf(String.valueOf(componentContext.getProperties().get(PATH_RESTRICTIONS)));
        this.useForPropertyRestrictions = Boolean.valueOf(String.valueOf(componentContext.getProperties().get(PROPERTY_RESTRICTIONS)));
        this.useForPrimaryTypes = Boolean.valueOf(String.valueOf(componentContext.getProperties().get(PRIMARY_TYPES_RESTRICTIONS)));
        this.ignoredProperties = Arrays.asList(String.valueOf(componentContext.getProperties().get(IGNORED_PROPERTIES)).split(","));
    }

    @Override
    public OakSolrConfiguration getConfiguration() {
        if (this.oakSolrConfiguration == null) {
            this.oakSolrConfiguration = new DefaultSolrConfiguration(){

                @Override
                public String getPathField() {
                    return OakSolrConfigurationProviderService.this.pathExactFieldName;
                }

                @Override
                public String getFieldForPathRestriction(Filter.PathRestriction pathRestriction) {
                    String fieldName = null;
                    switch (pathRestriction) {
                        case ALL_CHILDREN: {
                            fieldName = OakSolrConfigurationProviderService.this.pathDescendantsFieldName;
                            break;
                        }
                        case DIRECT_CHILDREN: {
                            fieldName = OakSolrConfigurationProviderService.this.pathChildrenFieldName;
                            break;
                        }
                        case EXACT: {
                            fieldName = OakSolrConfigurationProviderService.this.pathExactFieldName;
                            break;
                        }
                        case PARENT: {
                            fieldName = OakSolrConfigurationProviderService.this.pathParentFieldName;
                            break;
                        }
                        case NO_RESTRICTION: {
                            break;
                        }
                    }
                    return fieldName;
                }

                @Override
                public CommitPolicy getCommitPolicy() {
                    return OakSolrConfigurationProviderService.this.commitPolicy;
                }

                @Override
                public String getCatchAllField() {
                    return OakSolrConfigurationProviderService.this.catchAllField;
                }

                @Override
                public int getRows() {
                    return OakSolrConfigurationProviderService.this.rows;
                }

                @Override
                public boolean useForPropertyRestrictions() {
                    return OakSolrConfigurationProviderService.this.useForPropertyRestrictions;
                }

                @Override
                public boolean useForPrimaryTypes() {
                    return OakSolrConfigurationProviderService.this.useForPrimaryTypes;
                }

                @Override
                public boolean useForPathRestrictions() {
                    return OakSolrConfigurationProviderService.this.useForPathRestrictions;
                }

                @Override
                public Collection<String> getIgnoredProperties() {
                    return OakSolrConfigurationProviderService.this.ignoredProperties;
                }
            };
        }
        return this.oakSolrConfiguration;
    }
}

