/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.index.solr.osgi;

import java.io.File;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Deactivate;
import org.apache.felix.scr.annotations.Property;
import org.apache.felix.scr.annotations.Service;
import org.apache.jackrabbit.oak.plugins.index.solr.configuration.EmbeddedSolrServerConfiguration;
import org.apache.jackrabbit.oak.plugins.index.solr.configuration.SolrServerConfiguration;
import org.apache.jackrabbit.oak.plugins.index.solr.configuration.SolrServerConfigurationProvider;
import org.apache.jackrabbit.oak.plugins.index.solr.server.EmbeddedSolrServerProvider;
import org.osgi.service.component.ComponentContext;

@Component(metatype=true, immediate=true, label="Oak Solr embedded server configuration")
@Service(value={SolrServerConfigurationProvider.class})
@Property(name="name", value={"embedded"}, propertyPrivate=true)
public class EmbeddedSolrServerConfigurationProvider
implements SolrServerConfigurationProvider<EmbeddedSolrServerProvider> {
    @Property(value={"solr"}, label="Solr home directory")
    private static final String SOLR_HOME_PATH = "solr.home.path";
    @Property(value={"oak"}, label="Solr Core name")
    private static final String SOLR_CORE_NAME = "solr.core.name";
    @Property(value={"solr.xml"}, label="Path to specific Solr Core configuration")
    private static final String SOLR_CONFIG_FILE = "solr.config.path";
    private String solrHome;
    private String solrConfigFile;
    private String solrCoreName;
    private SolrServerConfiguration<EmbeddedSolrServerProvider> solrServerConfiguration;

    @Activate
    protected void activate(ComponentContext componentContext) throws Exception {
        this.solrHome = String.valueOf(componentContext.getProperties().get(SOLR_HOME_PATH));
        File file = new File(this.solrHome);
        if (!file.exists()) assert (file.createNewFile());
        this.solrConfigFile = String.valueOf(componentContext.getProperties().get(SOLR_CONFIG_FILE));
        this.solrCoreName = String.valueOf(componentContext.getProperties().get(SOLR_CORE_NAME));
        this.solrServerConfiguration = new EmbeddedSolrServerConfiguration(this.solrHome, this.solrConfigFile, this.solrCoreName);
    }

    @Deactivate
    protected void deactivate() throws Exception {
        this.solrHome = null;
        this.solrConfigFile = null;
        this.solrCoreName = null;
    }

    @Override
    public SolrServerConfiguration<EmbeddedSolrServerProvider> getSolrServerConfiguration() {
        return this.solrServerConfiguration;
    }
}

