/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.spatial.util;

import com.spatial4j.core.context.SpatialContext;
import com.spatial4j.core.distance.DistanceCalculator;
import com.spatial4j.core.shape.Point;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.apache.lucene.index.AtomicReaderContext;
import org.apache.lucene.queries.function.FunctionValues;
import org.apache.lucene.queries.function.ValueSource;
import org.apache.lucene.spatial.util.ShapeFieldCache;
import org.apache.lucene.spatial.util.ShapeFieldCacheProvider;

public class ShapeFieldCacheDistanceValueSource
extends ValueSource {
    private final SpatialContext ctx;
    private final Point from;
    private final ShapeFieldCacheProvider<Point> provider;
    private final double multiplier;

    public ShapeFieldCacheDistanceValueSource(SpatialContext ctx, ShapeFieldCacheProvider<Point> provider, Point from, double multiplier) {
        this.ctx = ctx;
        this.from = from;
        this.provider = provider;
        this.multiplier = multiplier;
    }

    @Override
    public String description() {
        return this.getClass().getSimpleName() + "(" + this.provider + ", " + this.from + ")";
    }

    @Override
    public FunctionValues getValues(Map context, final AtomicReaderContext readerContext) throws IOException {
        return new FunctionValues(){
            private final ShapeFieldCache<Point> cache;
            private final Point from;
            private final DistanceCalculator calculator;
            private final double nullValue;
            {
                this.cache = ShapeFieldCacheDistanceValueSource.this.provider.getCache(readerContext.reader());
                this.from = ShapeFieldCacheDistanceValueSource.this.from;
                this.calculator = ShapeFieldCacheDistanceValueSource.this.ctx.getDistCalc();
                this.nullValue = ShapeFieldCacheDistanceValueSource.this.ctx.isGeo() ? 180.0 * ShapeFieldCacheDistanceValueSource.this.multiplier : Double.MAX_VALUE;
            }

            @Override
            public float floatVal(int doc) {
                return (float)this.doubleVal(doc);
            }

            @Override
            public double doubleVal(int doc) {
                List<Point> vals = this.cache.getShapes(doc);
                if (vals != null) {
                    double v = this.calculator.distance(this.from, vals.get(0));
                    for (int i = 1; i < vals.size(); ++i) {
                        v = Math.min(v, this.calculator.distance(this.from, vals.get(i)));
                    }
                    return v * ShapeFieldCacheDistanceValueSource.this.multiplier;
                }
                return this.nullValue;
            }

            @Override
            public String toString(int doc) {
                return ShapeFieldCacheDistanceValueSource.this.description() + "=" + this.floatVal(doc);
            }
        };
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ShapeFieldCacheDistanceValueSource that = (ShapeFieldCacheDistanceValueSource)o;
        if (!this.ctx.equals(that.ctx)) {
            return false;
        }
        if (!this.from.equals(that.from)) {
            return false;
        }
        if (!this.provider.equals(that.provider)) {
            return false;
        }
        return this.multiplier == that.multiplier;
    }

    @Override
    public int hashCode() {
        return this.from.hashCode();
    }
}

