/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.analysis;

import java.io.IOException;
import org.apache.lucene.analysis.TokenFilter;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.tokenattributes.CharTermAttribute;
import org.apache.lucene.analysis.tokenattributes.PositionIncrementAttribute;
import org.apache.lucene.util.AttributeSource;

public final class ReversedWildcardFilter
extends TokenFilter {
    private boolean withOriginal;
    private char markerChar;
    private AttributeSource.State save;
    private CharTermAttribute termAtt = this.addAttribute(CharTermAttribute.class);
    private PositionIncrementAttribute posAtt = this.addAttribute(PositionIncrementAttribute.class);

    protected ReversedWildcardFilter(TokenStream input, boolean withOriginal, char markerChar) {
        super(input);
        this.withOriginal = withOriginal;
        this.markerChar = markerChar;
    }

    @Override
    public boolean incrementToken() throws IOException {
        if (this.save != null) {
            this.restoreState(this.save);
            this.save = null;
            return true;
        }
        if (!this.input.incrementToken()) {
            return false;
        }
        int oldLen = this.termAtt.length();
        if (oldLen == 0) {
            return true;
        }
        int origOffset = this.posAtt.getPositionIncrement();
        if (this.withOriginal) {
            this.posAtt.setPositionIncrement(0);
            this.save = this.captureState();
        }
        char[] buffer = this.termAtt.resizeBuffer(oldLen + 1);
        buffer[oldLen] = this.markerChar;
        ReversedWildcardFilter.reverse(buffer, 0, oldLen + 1);
        this.posAtt.setPositionIncrement(origOffset);
        this.termAtt.copyBuffer(buffer, 0, oldLen + 1);
        return true;
    }

    public static void reverse(char[] buffer, int start, int len) {
        if (len < 2) {
            return;
        }
        int end = start + len - 1;
        char frontHigh = buffer[start];
        char endLow = buffer[end];
        boolean allowFrontSur = true;
        boolean allowEndSur = true;
        int mid = start + (len >> 1);
        int i = start;
        while (i < mid) {
            boolean surAtFront;
            char frontLow = buffer[i + 1];
            char endHigh = buffer[end - 1];
            boolean bl = surAtFront = allowFrontSur && Character.isSurrogatePair(frontHigh, frontLow);
            if (surAtFront && len < 3) {
                return;
            }
            boolean surAtEnd = allowEndSur && Character.isSurrogatePair(endHigh, endLow);
            allowEndSur = true;
            allowFrontSur = true;
            if (surAtFront == surAtEnd) {
                if (surAtFront) {
                    buffer[end] = frontLow;
                    buffer[--end] = frontHigh;
                    buffer[i] = endHigh;
                    buffer[++i] = endLow;
                    frontHigh = buffer[i + 1];
                    endLow = buffer[end - 1];
                } else {
                    buffer[end] = frontHigh;
                    buffer[i] = endLow;
                    frontHigh = frontLow;
                    endLow = endHigh;
                }
            } else if (surAtFront) {
                buffer[end] = frontLow;
                buffer[i] = endLow;
                endLow = endHigh;
                allowFrontSur = false;
            } else {
                buffer[end] = frontHigh;
                buffer[i] = endHigh;
                frontHigh = frontLow;
                allowEndSur = false;
            }
            ++i;
            --end;
        }
        if (!((len & 1) != 1 || allowFrontSur && allowEndSur)) {
            buffer[end] = allowFrontSur ? endLow : frontHigh;
        }
    }
}

