/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.cloud;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.cloud.ClusterState;
import org.apache.solr.common.cloud.DocCollection;
import org.apache.solr.common.cloud.Replica;
import org.apache.solr.common.cloud.Slice;
import org.apache.solr.common.util.StrUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Assign {
    private static Pattern COUNT = Pattern.compile("core_node(\\d+)");
    private static Logger log = LoggerFactory.getLogger(Assign.class);

    public static String assignNode(String collection, ClusterState state) {
        Map<String, Slice> sliceMap = state.getSlicesMap(collection);
        if (sliceMap == null) {
            return "core_node1";
        }
        int max = 0;
        for (Slice slice : sliceMap.values()) {
            for (Replica replica : slice.getReplicas()) {
                Matcher m = COUNT.matcher(replica.getName());
                if (!m.matches()) continue;
                max = Math.max(max, Integer.parseInt(m.group(1)));
            }
        }
        return "core_node" + (max + 1);
    }

    public static String assignShard(String collection, ClusterState state, Integer numShards) {
        if (numShards == null) {
            numShards = 1;
        }
        String returnShardId = null;
        Map<String, Slice> sliceMap = state.getActiveSlicesMap(collection);
        if (sliceMap == null) {
            return "shard1";
        }
        ArrayList<String> shardIdNames = new ArrayList<String>(sliceMap.keySet());
        if (shardIdNames.size() < numShards) {
            return "shard" + (shardIdNames.size() + 1);
        }
        final HashMap<String, Integer> map = new HashMap<String, Integer>();
        for (String shardId : shardIdNames) {
            int cnt = sliceMap.get(shardId).getReplicasMap().size();
            map.put(shardId, cnt);
        }
        Collections.sort(shardIdNames, new Comparator<String>(){

            @Override
            public int compare(String o1, String o2) {
                Integer one = (Integer)map.get(o1);
                Integer two = (Integer)map.get(o2);
                return one.compareTo(two);
            }
        });
        returnShardId = (String)shardIdNames.get(0);
        return returnShardId;
    }

    public static ArrayList<Node> getNodesForNewShard(ClusterState clusterState, String collectionName, int numSlices, int maxShardsPerNode, int repFactor, String createNodeSetStr) {
        int requestedCoresToCreate;
        int minCoresToCreate;
        int maxCoresAllowedToCreate;
        List<String> createNodeList = createNodeSetStr == null ? null : StrUtils.splitSmart(createNodeSetStr, ",", true);
        Set<String> nodes = clusterState.getLiveNodes();
        ArrayList<String> nodeList = new ArrayList<String>(nodes.size());
        nodeList.addAll(nodes);
        if (createNodeList != null) {
            nodeList.retainAll(createNodeList);
        }
        HashMap<String, Node> nodeNameVsShardCount = new HashMap<String, Node>();
        for (String s : nodeList) {
            nodeNameVsShardCount.put(s, new Node(s));
        }
        for (String s : clusterState.getCollections()) {
            DocCollection c = clusterState.getCollection(s);
            for (Slice slice : c.getSlices()) {
                Collection<Replica> replicas = slice.getReplicas();
                for (Replica replica : replicas) {
                    Node count = (Node)nodeNameVsShardCount.get(replica.getNodeName());
                    if (count == null) continue;
                    ++count.totalNodes;
                    if (!s.equals(collectionName)) continue;
                    ++count.thisCollectionNodes;
                    if (count.thisCollectionNodes < maxShardsPerNode) continue;
                    nodeNameVsShardCount.remove(replica.getNodeName());
                }
            }
        }
        if (nodeNameVsShardCount.size() <= 0) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Cannot create collection " + collectionName + ". No live Solr-instances" + (createNodeList != null ? " among Solr-instances specified in createNodeSet:" + createNodeSetStr : ""));
        }
        if (repFactor > nodeNameVsShardCount.size()) {
            log.warn("Specified replicationFactor of " + repFactor + " on collection " + collectionName + " is higher than or equal to the number of Solr instances currently live or part of your " + "createNodeSet" + "(" + nodeList.size() + "). Its unusual to run two replica of the same slice on the same Solr-instance.");
        }
        if ((maxCoresAllowedToCreate = maxShardsPerNode * nodeList.size()) < (minCoresToCreate = (requestedCoresToCreate = numSlices * repFactor))) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Cannot create shards " + collectionName + ". Value of " + "maxShardsPerNode" + " is " + maxShardsPerNode + ", and the number of live nodes is " + nodeList.size() + ". This allows a maximum of " + maxCoresAllowedToCreate + " to be created. Value of " + "numShards" + " is " + numSlices + " and value of " + "replicationFactor" + " is " + repFactor + ". This requires " + requestedCoresToCreate + " shards to be created (higher than the allowed number)");
        }
        ArrayList<Node> sortedNodeList = new ArrayList<Node>(nodeNameVsShardCount.values());
        Collections.sort(sortedNodeList, new Comparator<Node>(){

            @Override
            public int compare(Node x, Node y) {
                return x.weight() < y.weight() ? -1 : (x.weight() == y.weight() ? 0 : 1);
            }
        });
        return sortedNodeList;
    }

    static class Node {
        public final String nodeName;
        public int thisCollectionNodes = 0;
        public int totalNodes = 0;

        Node(String nodeName) {
            this.nodeName = nodeName;
        }

        public int weight() {
            return this.thisCollectionNodes * 100 + this.totalNodes;
        }
    }
}

