/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.core;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.apache.lucene.store.AlreadyClosedException;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.IOContext;
import org.apache.lucene.store.NRTCachingDirectory;
import org.apache.lucene.store.NativeFSLockFactory;
import org.apache.lucene.store.NoLockFactory;
import org.apache.lucene.store.RateLimitedDirectoryWrapper;
import org.apache.lucene.store.SimpleFSLockFactory;
import org.apache.lucene.store.SingleInstanceLockFactory;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.util.NamedList;
import org.apache.solr.core.DirectoryFactory;
import org.apache.solr.store.blockcache.BlockDirectory;
import org.apache.solr.store.hdfs.HdfsDirectory;
import org.apache.solr.store.hdfs.HdfsLockFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class CachingDirectoryFactory
extends DirectoryFactory {
    private static Logger log = LoggerFactory.getLogger(CachingDirectoryFactory.class);
    protected Map<String, CacheValue> byPathCache = new HashMap<String, CacheValue>();
    protected Map<Directory, CacheValue> byDirectoryCache = new IdentityHashMap<Directory, CacheValue>();
    protected Map<Directory, List<CloseListener>> closeListeners = new HashMap<Directory, List<CloseListener>>();
    protected Set<CacheValue> removeEntries = new HashSet<CacheValue>();
    private Double maxWriteMBPerSecFlush;
    private Double maxWriteMBPerSecMerge;
    private Double maxWriteMBPerSecRead;
    private Double maxWriteMBPerSecDefault;
    private boolean closed;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addCloseListener(Directory dir, CloseListener closeListener) {
        CachingDirectoryFactory cachingDirectoryFactory = this;
        synchronized (cachingDirectoryFactory) {
            if (!this.byDirectoryCache.containsKey(dir)) {
                throw new IllegalArgumentException("Unknown directory: " + dir + " " + this.byDirectoryCache);
            }
            List<CloseListener> listeners = this.closeListeners.get(dir);
            if (listeners == null) {
                listeners = new ArrayList<CloseListener>();
                this.closeListeners.put(dir, listeners);
            }
            listeners.add(closeListener);
            this.closeListeners.put(dir, listeners);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void doneWithDirectory(Directory directory) throws IOException {
        CachingDirectoryFactory cachingDirectoryFactory = this;
        synchronized (cachingDirectoryFactory) {
            boolean cl;
            CacheValue cacheValue = this.byDirectoryCache.get(directory);
            if (cacheValue == null) {
                throw new IllegalArgumentException("Unknown directory: " + directory + " " + this.byDirectoryCache);
            }
            cacheValue.doneWithDir = true;
            log.debug("Done with dir: {}", (Object)cacheValue);
            if (cacheValue.refCnt == 0 && !this.closed && (cl = this.closeCacheValue(cacheValue))) {
                this.removeFromCache(cacheValue);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws IOException {
        CachingDirectoryFactory cachingDirectoryFactory = this;
        synchronized (cachingDirectoryFactory) {
            log.info("Closing " + this.getClass().getSimpleName() + " - " + this.byDirectoryCache.size() + " directories currently being tracked");
            this.closed = true;
            Collection<CacheValue> values = this.byDirectoryCache.values();
            for (CacheValue val : values) {
                log.debug("Closing {} - currently tracking: {}", (Object)this.getClass().getSimpleName(), (Object)val);
                try {
                    int cnt = 0;
                    while (val.refCnt != 0) {
                        this.wait(100L);
                        if (cnt++ < 120) continue;
                        String msg = "Timeout waiting for all directory ref counts to be released - gave up waiting on " + val;
                        log.error(msg);
                        throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, msg);
                    }
                    assert (val.refCnt == 0) : val.refCnt;
                }
                catch (Exception e) {
                    SolrException.log(log, "Error closing directory", e);
                }
            }
            values = this.byDirectoryCache.values();
            HashSet<CacheValue> closedDirs = new HashSet<CacheValue>();
            for (CacheValue val : values) {
                try {
                    for (CacheValue v : val.closeEntries) {
                        assert (v.refCnt == 0) : val.refCnt;
                        log.debug("Closing directory when closing factory: " + v.path);
                        boolean cl = this.closeCacheValue(v);
                        if (!cl) continue;
                        closedDirs.add(v);
                    }
                }
                catch (Exception e) {
                    SolrException.log(log, "Error closing directory", e);
                }
            }
            for (CacheValue val : this.removeEntries) {
                log.info("Removing directory after core close: " + val.path);
                try {
                    this.removeDirectory(val);
                }
                catch (Exception e) {
                    SolrException.log(log, "Error removing directory", e);
                }
            }
            for (CacheValue v : closedDirs) {
                this.removeFromCache(v);
            }
        }
    }

    private void removeFromCache(CacheValue v) {
        log.debug("Removing from cache: {}", (Object)v);
        this.byDirectoryCache.remove(v.directory);
        this.byPathCache.remove(v.path);
    }

    private boolean closeCacheValue(CacheValue cacheValue) {
        log.info("looking to close " + cacheValue.path + " " + cacheValue.closeEntries.toString());
        List<CloseListener> listeners = this.closeListeners.remove(cacheValue.directory);
        if (listeners != null) {
            for (CloseListener listener : listeners) {
                try {
                    listener.preClose();
                }
                catch (Exception e) {
                    SolrException.log(log, "Error executing preClose for directory", e);
                }
            }
        }
        cacheValue.closeCacheValueCalled = true;
        if (cacheValue.deleteOnClose) {
            Collection<CacheValue> values = this.byPathCache.values();
            ArrayList<CacheValue> cacheValues = new ArrayList<CacheValue>(values);
            cacheValues.remove(cacheValue);
            for (CacheValue otherCacheValue : cacheValues) {
                if (!this.isSubPath(cacheValue, otherCacheValue) || otherCacheValue.closeCacheValueCalled) continue;
                if (!otherCacheValue.deleteAfterCoreClose && cacheValue.deleteAfterCoreClose) {
                    otherCacheValue.deleteAfterCoreClose = true;
                }
                otherCacheValue.removeEntries.addAll(cacheValue.removeEntries);
                otherCacheValue.closeEntries.addAll(cacheValue.closeEntries);
                cacheValue.closeEntries.clear();
                cacheValue.removeEntries.clear();
                return false;
            }
        }
        boolean cl = false;
        for (CacheValue val : cacheValue.closeEntries) {
            this.close(val);
            if (val != cacheValue) continue;
            cl = true;
        }
        for (CacheValue val : cacheValue.removeEntries) {
            if (!val.deleteAfterCoreClose) {
                log.info("Removing directory before core close: " + val.path);
                try {
                    this.removeDirectory(val);
                }
                catch (Exception e) {
                    SolrException.log(log, "Error removing directory", e);
                }
                continue;
            }
            this.removeEntries.add(val);
        }
        if (listeners != null) {
            for (CloseListener listener : listeners) {
                try {
                    listener.postClose();
                }
                catch (Exception e) {
                    SolrException.log(log, "Error executing postClose for directory", e);
                }
            }
        }
        return cl;
    }

    private void close(CacheValue val) {
        try {
            log.info("Closing directory: " + val.path);
            val.directory.close();
        }
        catch (Exception e) {
            SolrException.log(log, "Error closing directory", e);
        }
    }

    private boolean isSubPath(CacheValue cacheValue, CacheValue otherCacheValue) {
        int one = cacheValue.path.lastIndexOf(47);
        int two = otherCacheValue.path.lastIndexOf(47);
        return otherCacheValue.path.startsWith(cacheValue.path + "/") && two > one;
    }

    @Override
    protected abstract Directory create(String var1, DirectoryFactory.DirContext var2) throws IOException;

    @Override
    public boolean exists(String path) throws IOException {
        File dirFile = new File(path);
        return dirFile.canRead() && dirFile.list().length > 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final Directory get(String path, DirectoryFactory.DirContext dirContext, String rawLockType) throws IOException {
        String fullPath = this.normalize(path);
        CachingDirectoryFactory cachingDirectoryFactory = this;
        synchronized (cachingDirectoryFactory) {
            if (this.closed) {
                throw new AlreadyClosedException("Already closed");
            }
            CacheValue cacheValue = this.byPathCache.get(fullPath);
            Directory directory = null;
            if (cacheValue != null) {
                directory = cacheValue.directory;
            }
            if (directory == null) {
                directory = this.create(fullPath, dirContext);
                directory = this.rateLimit(directory);
                CacheValue newCacheValue = new CacheValue(fullPath, directory);
                CachingDirectoryFactory.injectLockFactory(directory, fullPath, rawLockType);
                this.byDirectoryCache.put(directory, newCacheValue);
                this.byPathCache.put(fullPath, newCacheValue);
                log.info("return new directory for " + fullPath);
            } else {
                ++cacheValue.refCnt;
                log.debug("Reusing cached directory: {}", (Object)cacheValue);
            }
            return directory;
        }
    }

    private Directory rateLimit(Directory directory) {
        if (this.maxWriteMBPerSecDefault != null || this.maxWriteMBPerSecFlush != null || this.maxWriteMBPerSecMerge != null || this.maxWriteMBPerSecRead != null) {
            directory = new RateLimitedDirectoryWrapper(directory);
            if (this.maxWriteMBPerSecDefault != null) {
                ((RateLimitedDirectoryWrapper)directory).setMaxWriteMBPerSec(this.maxWriteMBPerSecDefault, IOContext.Context.DEFAULT);
            }
            if (this.maxWriteMBPerSecFlush != null) {
                ((RateLimitedDirectoryWrapper)directory).setMaxWriteMBPerSec(this.maxWriteMBPerSecFlush, IOContext.Context.FLUSH);
            }
            if (this.maxWriteMBPerSecMerge != null) {
                ((RateLimitedDirectoryWrapper)directory).setMaxWriteMBPerSec(this.maxWriteMBPerSecMerge, IOContext.Context.MERGE);
            }
            if (this.maxWriteMBPerSecRead != null) {
                ((RateLimitedDirectoryWrapper)directory).setMaxWriteMBPerSec(this.maxWriteMBPerSecRead, IOContext.Context.READ);
            }
        }
        return directory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void incRef(Directory directory) {
        CachingDirectoryFactory cachingDirectoryFactory = this;
        synchronized (cachingDirectoryFactory) {
            if (this.closed) {
                throw new SolrException(SolrException.ErrorCode.SERVICE_UNAVAILABLE, "Already closed");
            }
            CacheValue cacheValue = this.byDirectoryCache.get(directory);
            if (cacheValue == null) {
                throw new IllegalArgumentException("Unknown directory: " + directory);
            }
            ++cacheValue.refCnt;
            log.debug("incRef'ed: {}", (Object)cacheValue);
        }
    }

    @Override
    public void init(NamedList args) {
        this.maxWriteMBPerSecFlush = (Double)args.get("maxWriteMBPerSecFlush");
        this.maxWriteMBPerSecMerge = (Double)args.get("maxWriteMBPerSecMerge");
        this.maxWriteMBPerSecRead = (Double)args.get("maxWriteMBPerSecRead");
        this.maxWriteMBPerSecDefault = (Double)args.get("maxWriteMBPerSecDefault");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void release(Directory directory) throws IOException {
        if (directory == null) {
            throw new NullPointerException();
        }
        CachingDirectoryFactory cachingDirectoryFactory = this;
        synchronized (cachingDirectoryFactory) {
            boolean cl;
            CacheValue cacheValue = this.byDirectoryCache.get(directory);
            if (cacheValue == null) {
                throw new IllegalArgumentException("Unknown directory: " + directory + " " + this.byDirectoryCache);
            }
            log.debug("Releasing directory: " + cacheValue.path + " " + (cacheValue.refCnt - 1) + " " + cacheValue.doneWithDir);
            --cacheValue.refCnt;
            assert (cacheValue.refCnt >= 0) : cacheValue.refCnt;
            if (cacheValue.refCnt == 0 && cacheValue.doneWithDir && !this.closed && (cl = this.closeCacheValue(cacheValue))) {
                this.removeFromCache(cacheValue);
            }
        }
    }

    @Override
    public void remove(String path) throws IOException {
        this.remove(path, false);
    }

    @Override
    public void remove(Directory dir) throws IOException {
        this.remove(dir, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void remove(String path, boolean deleteAfterCoreClose) throws IOException {
        CachingDirectoryFactory cachingDirectoryFactory = this;
        synchronized (cachingDirectoryFactory) {
            CacheValue val = this.byPathCache.get(this.normalize(path));
            if (val == null) {
                throw new IllegalArgumentException("Unknown directory " + path);
            }
            val.setDeleteOnClose(true, deleteAfterCoreClose);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void remove(Directory dir, boolean deleteAfterCoreClose) throws IOException {
        CachingDirectoryFactory cachingDirectoryFactory = this;
        synchronized (cachingDirectoryFactory) {
            CacheValue val = this.byDirectoryCache.get(dir);
            if (val == null) {
                throw new IllegalArgumentException("Unknown directory " + dir);
            }
            val.setDeleteOnClose(true, deleteAfterCoreClose);
        }
    }

    private static Directory injectLockFactory(Directory dir, String lockPath, String rawLockType) throws IOException {
        String lockType;
        if (null == rawLockType) {
            log.warn("No lockType configured for " + dir + " assuming 'simple'");
            rawLockType = "simple";
        }
        if ("simple".equals(lockType = rawLockType.toLowerCase(Locale.ROOT).trim())) {
            dir.setLockFactory(new SimpleFSLockFactory(lockPath));
        } else if ("native".equals(lockType)) {
            dir.setLockFactory(new NativeFSLockFactory(lockPath));
        } else if ("single".equals(lockType)) {
            if (!(dir.getLockFactory() instanceof SingleInstanceLockFactory)) {
                dir.setLockFactory(new SingleInstanceLockFactory());
            }
        } else if ("hdfs".equals(lockType)) {
            Directory del = dir;
            if (dir instanceof NRTCachingDirectory) {
                del = ((NRTCachingDirectory)del).getDelegate();
            }
            if (del instanceof BlockDirectory) {
                del = ((BlockDirectory)del).getDirectory();
            }
            if (!(del instanceof HdfsDirectory)) {
                throw new SolrException(SolrException.ErrorCode.FORBIDDEN, "Directory: " + del.getClass().getName() + ", but hdfs lock factory can only be used with HdfsDirectory");
            }
            dir.setLockFactory(new HdfsLockFactory(((HdfsDirectory)del).getHdfsDirPath(), ((HdfsDirectory)del).getConfiguration()));
        } else if ("none".equals(lockType)) {
            log.error("CONFIGURATION WARNING: locks are disabled on " + dir);
            dir.setLockFactory(NoLockFactory.getNoLockFactory());
        } else {
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Unrecognized lockType: " + rawLockType);
        }
        return dir;
    }

    protected synchronized void removeDirectory(CacheValue cacheValue) throws IOException {
    }

    @Override
    public String normalize(String path) throws IOException {
        path = this.stripTrailingSlash(path);
        return path;
    }

    protected String stripTrailingSlash(String path) {
        if (path.endsWith("/")) {
            path = path.substring(0, path.length() - 1);
        }
        return path;
    }

    public synchronized Set<String> getLivePaths() {
        HashSet<String> livePaths = new HashSet<String>();
        for (CacheValue val : this.byPathCache.values()) {
            if (val.doneWithDir) continue;
            livePaths.add(val.path);
        }
        return livePaths;
    }

    public static interface CloseListener {
        public void postClose();

        public void preClose();
    }

    protected class CacheValue {
        public final String path;
        public final Directory directory;
        private boolean deleteOnClose = false;
        public int refCnt = 1;
        public boolean closeCacheValueCalled = false;
        public boolean doneWithDir = false;
        private boolean deleteAfterCoreClose = false;
        public Set<CacheValue> removeEntries = new HashSet<CacheValue>();
        public Set<CacheValue> closeEntries = new HashSet<CacheValue>();

        public CacheValue(String path, Directory directory) {
            this.path = path;
            this.directory = directory;
            this.closeEntries.add(this);
        }

        public void setDeleteOnClose(boolean deleteOnClose, boolean deleteAfterCoreClose) {
            if (deleteOnClose) {
                this.removeEntries.add(this);
            }
            this.deleteOnClose = deleteOnClose;
            this.deleteAfterCoreClose = deleteAfterCoreClose;
        }

        public String toString() {
            return "CachedDir<<refCount=" + this.refCnt + ";path=" + this.path + ";done=" + this.doneWithDir + ">>";
        }
    }
}

