/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.handler;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.params.MapSolrParams;
import org.apache.solr.common.params.ModifiableSolrParams;
import org.apache.solr.common.params.SolrParams;
import org.apache.solr.common.util.ContentStream;
import org.apache.solr.common.util.NamedList;
import org.apache.solr.handler.ContentStreamHandlerBase;
import org.apache.solr.handler.loader.CSVLoader;
import org.apache.solr.handler.loader.ContentStreamLoader;
import org.apache.solr.handler.loader.JavabinLoader;
import org.apache.solr.handler.loader.JsonLoader;
import org.apache.solr.handler.loader.XMLLoader;
import org.apache.solr.request.SolrQueryRequest;
import org.apache.solr.response.SolrQueryResponse;
import org.apache.solr.update.processor.UpdateRequestProcessor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UpdateRequestHandler
extends ContentStreamHandlerBase {
    public static Logger log = LoggerFactory.getLogger(UpdateRequestHandler.class);
    public static final String ADD = "add";
    public static final String DELETE = "delete";
    public static final String OPTIMIZE = "optimize";
    public static final String COMMIT = "commit";
    public static final String ROLLBACK = "rollback";
    public static final String WAIT_SEARCHER = "waitSearcher";
    public static final String SOFT_COMMIT = "softCommit";
    public static final String OVERWRITE = "overwrite";
    public static final String VERSION = "version";
    public static final String COMMIT_WITHIN = "commitWithin";
    Map<String, ContentStreamLoader> loaders = null;
    ContentStreamLoader instance = new ContentStreamLoader(){

        @Override
        public void load(SolrQueryRequest req, SolrQueryResponse rsp, ContentStream stream, UpdateRequestProcessor processor) throws Exception {
            ContentStreamLoader loader;
            String type = req.getParams().get("update.contentType");
            if (type == null) {
                type = stream.getContentType();
            }
            if (type == null) {
                throw new SolrException(SolrException.ErrorCode.UNSUPPORTED_MEDIA_TYPE, "Missing ContentType");
            }
            int idx = type.indexOf(59);
            if (idx > 0) {
                type = type.substring(0, idx);
            }
            if ((loader = UpdateRequestHandler.this.loaders.get(type)) == null) {
                throw new SolrException(SolrException.ErrorCode.UNSUPPORTED_MEDIA_TYPE, "Unsupported ContentType: " + type + "  Not in: " + UpdateRequestHandler.this.loaders.keySet());
            }
            if (loader.getDefaultWT() != null) {
                this.setDefaultWT(req, loader);
            }
            loader.load(req, rsp, stream, processor);
        }

        private void setDefaultWT(SolrQueryRequest req, ContentStreamLoader loader) {
            SolrParams params = req.getParams();
            if (params.get("wt") == null) {
                String wt = loader.getDefaultWT();
                if (req.getCore().getQueryResponseWriter(wt) != null) {
                    HashMap<String, String> map = new HashMap<String, String>(1);
                    map.put("wt", wt);
                    req.setParams(SolrParams.wrapDefaults(params, new MapSolrParams(map)));
                }
            }
        }
    };

    @Override
    public void init(NamedList args) {
        super.init(args);
        this.loaders = Collections.unmodifiableMap(this.createDefaultLoaders(args));
    }

    protected void setAssumeContentType(String ct) {
        if (this.invariants == null) {
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("update.contentType", ct);
            this.invariants = new MapSolrParams(map);
        } else {
            ModifiableSolrParams params = new ModifiableSolrParams(this.invariants);
            params.set("update.contentType", ct);
            this.invariants = params;
        }
    }

    protected Map<String, ContentStreamLoader> createDefaultLoaders(NamedList args) {
        SolrParams p = null;
        if (args != null) {
            p = SolrParams.toSolrParams(args);
        }
        HashMap<String, ContentStreamLoader> registry = new HashMap<String, ContentStreamLoader>();
        registry.put("application/xml", new XMLLoader().init(p));
        registry.put("application/json", new JsonLoader().init(p));
        registry.put("application/csv", new CSVLoader().init(p));
        registry.put("application/javabin", new JavabinLoader().init(p));
        registry.put("text/csv", (ContentStreamLoader)registry.get("application/csv"));
        registry.put("text/xml", (ContentStreamLoader)registry.get("application/xml"));
        registry.put("text/json", (ContentStreamLoader)registry.get("application/json"));
        return registry;
    }

    @Override
    protected ContentStreamLoader newLoader(SolrQueryRequest req, UpdateRequestProcessor processor) {
        return this.instance;
    }

    @Override
    public String getDescription() {
        return "Add documents using XML (with XSLT), CSV, JSON, or javabin";
    }

    @Override
    public String getSource() {
        return "$URL: https://svn.apache.org/repos/asf/lucene/dev/branches/lucene_solr_4_7/solr/core/src/java/org/apache/solr/handler/UpdateRequestHandler.java $";
    }
}

