/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.highlight;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.tokenattributes.OffsetAttribute;
import org.apache.lucene.analysis.tokenattributes.PositionIncrementAttribute;
import org.apache.lucene.search.highlight.Fragmenter;

class LuceneRegexFragmenter
implements Fragmenter {
    public static final int DEFAULT_FRAGMENT_SIZE = 70;
    public static final int DEFAULT_INCREMENT_GAP = 50;
    public static final float DEFAULT_SLOP = 0.6f;
    public static final int DEFAULT_MAX_ANALYZED_CHARS = 10000;
    protected int targetFragChars;
    protected int incrementGapThreshold;
    protected float slop;
    protected int maxAnalyzedChars;
    protected Pattern textRE;
    protected int currentNumFrags;
    protected int currentOffset;
    protected int targetOffset;
    protected int[] hotspots;
    private PositionIncrementAttribute posIncAtt;
    private OffsetAttribute offsetAtt;
    public static final String DEFAULT_PATTERN_RAW = "[-\\w ,\\n\"']{20,200}";
    public static final Pattern DEFAULT_PATTERN = Pattern.compile("[-\\w ,\\n\"']{20,200}");

    public LuceneRegexFragmenter() {
        this(70, 50, 0.6f, 10000);
    }

    public LuceneRegexFragmenter(int targetFragChars) {
        this(targetFragChars, 50, 0.6f, 10000);
    }

    public LuceneRegexFragmenter(int targetFragChars, int incrementGapThreshold, float slop, int maxAnalyzedChars) {
        this(targetFragChars, incrementGapThreshold, slop, maxAnalyzedChars, DEFAULT_PATTERN);
    }

    public LuceneRegexFragmenter(int targetFragChars, int incrementGapThreshold, float slop, int maxAnalyzedChars, Pattern targetPattern) {
        this.targetFragChars = targetFragChars;
        this.incrementGapThreshold = incrementGapThreshold;
        this.slop = slop;
        this.maxAnalyzedChars = maxAnalyzedChars;
        this.textRE = targetPattern;
    }

    @Override
    public void start(String originalText, TokenStream tokenStream) {
        this.currentNumFrags = 1;
        this.currentOffset = 0;
        this.addHotSpots(originalText);
        this.posIncAtt = tokenStream.getAttribute(PositionIncrementAttribute.class);
        this.offsetAtt = tokenStream.getAttribute(OffsetAttribute.class);
    }

    protected void addHotSpots(String text) {
        ArrayList<Integer> temphs = new ArrayList<Integer>(text.length() / this.targetFragChars);
        Matcher match = this.textRE.matcher(text);
        int cur = 0;
        while (match.find() && cur < this.maxAnalyzedChars) {
            int start = match.start();
            int end = match.end();
            temphs.add(start);
            temphs.add(end);
            cur = end;
        }
        this.hotspots = new int[temphs.size()];
        for (int i = 0; i < temphs.size(); ++i) {
            this.hotspots[i] = (Integer)temphs.get(i);
        }
        Arrays.sort(this.hotspots);
    }

    @Override
    public boolean isNewFragment() {
        boolean isNewFrag = false;
        int minFragLen = (int)((1.0f - this.slop) * (float)this.targetFragChars);
        int endOffset = this.offsetAtt.endOffset();
        if (this.posIncAtt.getPositionIncrement() > this.incrementGapThreshold) {
            isNewFrag = true;
        } else if (endOffset - this.currentOffset < minFragLen) {
            isNewFrag = false;
        } else if (this.targetOffset > 0) {
            isNewFrag = endOffset > this.targetOffset;
        } else {
            int minOffset = this.currentOffset + minFragLen;
            int maxOffset = (int)((float)this.currentOffset + (1.0f + this.slop) * (float)this.targetFragChars);
            int hotIndex = Arrays.binarySearch(this.hotspots, endOffset);
            if (hotIndex < 0) {
                hotIndex = -hotIndex;
            }
            if (hotIndex >= this.hotspots.length) {
                this.targetOffset = this.currentOffset + this.targetFragChars;
            } else if (this.hotspots[hotIndex] > maxOffset) {
                this.targetOffset = this.currentOffset + this.targetFragChars;
            } else {
                int goal = this.hotspots[hotIndex];
                while (goal < minOffset && hotIndex < this.hotspots.length) {
                    goal = this.hotspots[++hotIndex];
                }
                this.targetOffset = goal <= maxOffset ? goal : this.currentOffset + this.targetFragChars;
            }
            boolean bl = isNewFrag = endOffset > this.targetOffset;
        }
        if (isNewFrag) {
            ++this.currentNumFrags;
            this.currentOffset = endOffset;
            this.targetOffset = -1;
        }
        return isNewFrag;
    }
}

