/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.search;

import java.io.IOException;
import java.util.Map;
import org.apache.lucene.index.AtomicReaderContext;
import org.apache.lucene.queries.function.FunctionValues;
import org.apache.lucene.queries.function.docvalues.BoolDocValues;
import org.apache.lucene.queries.function.valuesource.ConstNumberSource;

class BoolConstValueSource
extends ConstNumberSource {
    final boolean constant;

    public BoolConstValueSource(boolean constant) {
        this.constant = constant;
    }

    @Override
    public String description() {
        return "const(" + this.constant + ")";
    }

    @Override
    public FunctionValues getValues(Map context, AtomicReaderContext readerContext) throws IOException {
        return new BoolDocValues(this){

            @Override
            public boolean boolVal(int doc) {
                return BoolConstValueSource.this.constant;
            }
        };
    }

    @Override
    public int hashCode() {
        return this.constant ? 305419896 : -2023406815;
    }

    @Override
    public boolean equals(Object o) {
        if (BoolConstValueSource.class != o.getClass()) {
            return false;
        }
        BoolConstValueSource other = (BoolConstValueSource)o;
        return this.constant == other.constant;
    }

    @Override
    public int getInt() {
        return this.constant ? 1 : 0;
    }

    @Override
    public long getLong() {
        return this.constant ? 1L : 0L;
    }

    @Override
    public float getFloat() {
        return this.constant ? 1.0f : 0.0f;
    }

    @Override
    public double getDouble() {
        return this.constant ? 1.0 : 0.0;
    }

    @Override
    public Number getNumber() {
        return this.constant ? 1 : 0;
    }

    @Override
    public boolean getBool() {
        return this.constant;
    }
}

