/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.search.similarities;

import org.apache.lucene.misc.SweetSpotSimilarity;
import org.apache.lucene.search.similarities.Similarity;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.params.SolrParams;
import org.apache.solr.search.similarities.DefaultSimilarityFactory;

public class SweetSpotSimilarityFactory
extends DefaultSimilarityFactory {
    private SweetSpotSimilarity sim = null;

    @Override
    public void init(SolrParams params) {
        Float hyper_offset;
        Double hyper_base;
        Float hyper_max;
        super.init(params);
        Integer ln_min = params.getInt("lengthNormMin");
        Integer ln_max = params.getInt("lengthNormMax");
        Float ln_steep = params.getFloat("lengthNormSteepness");
        if (!SweetSpotSimilarityFactory.allOrNoneNull(ln_min, ln_max, ln_steep)) {
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Overriding default lengthNorm settings requires all to be specified: lengthNormMin, lengthNormMax, lengthNormSteepness");
        }
        Float hyper_min = params.getFloat("hyperbolicTfMin");
        if (!SweetSpotSimilarityFactory.allOrNoneNull(hyper_min, hyper_max = params.getFloat("hyperbolicTfMax"), hyper_base = params.getDouble("hyperbolicTfBase"), hyper_offset = params.getFloat("hyperbolicTfOffset"))) {
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Overriding default hyperbolicTf settings requires all to be specified: hyperbolicTfMin, hyperbolicTfMax, hyperbolicTfBase, hyperbolicTfOffset");
        }
        Float baseline_base = params.getFloat("baselineTfBase");
        Float baseline_min = params.getFloat("baselineTfMin");
        if (!SweetSpotSimilarityFactory.allOrNoneNull(baseline_min, baseline_base)) {
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Overriding default baselineTf settings requires all to be specified: baselineTfBase, baselineTfMin");
        }
        if (null != hyper_min && null != baseline_min) {
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Can not mix hyperbolicTf settings with baselineTf settings");
        }
        SweetSpotSimilarity sweetSpotSimilarity = this.sim = null != hyper_min ? new HyperbolicSweetSpotSimilarity() : new SweetSpotSimilarity();
        if (null != ln_min) {
            this.sim.setLengthNormFactors(ln_min, ln_max, ln_steep.floatValue(), this.discountOverlaps);
        }
        if (null != hyper_min) {
            this.sim.setHyperbolicTfFactors(hyper_min.floatValue(), hyper_max.floatValue(), hyper_base, hyper_offset.floatValue());
        }
        if (null != baseline_min) {
            this.sim.setBaselineTfFactors(baseline_base.floatValue(), baseline_min.floatValue());
        }
    }

    @Override
    public Similarity getSimilarity() {
        assert (this.sim != null) : "SweetSpotSimilarityFactory was not initalized";
        return this.sim;
    }

    private static boolean allOrNoneNull(Object ... args) {
        int nulls = 0;
        int objs = 0;
        for (Object o : args) {
            ++objs;
            if (null != o) continue;
            ++nulls;
        }
        return 0 == nulls || nulls == objs;
    }

    private static final class HyperbolicSweetSpotSimilarity
    extends SweetSpotSimilarity {
        private HyperbolicSweetSpotSimilarity() {
        }

        @Override
        public float tf(float freq) {
            return this.hyperbolicTf(freq);
        }
    }
}

