/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.update.processor;

import org.apache.lucene.document.Field;
import org.apache.lucene.document.FieldType;
import org.apache.solr.common.SolrInputField;
import org.apache.solr.schema.IndexSchema;
import org.apache.solr.schema.PreAnalyzedField;
import org.apache.solr.schema.SchemaField;
import org.apache.solr.update.processor.FieldMutatingUpdateProcessor;
import org.apache.solr.update.processor.UpdateRequestProcessor;

class PreAnalyzedUpdateProcessor
extends FieldMutatingUpdateProcessor {
    private PreAnalyzedField parser;
    private IndexSchema schema;

    public PreAnalyzedUpdateProcessor(FieldMutatingUpdateProcessor.FieldNameSelector sel, UpdateRequestProcessor next, IndexSchema schema, PreAnalyzedField parser) {
        super(sel, next);
        this.schema = schema;
        this.parser = parser;
    }

    @Override
    protected SolrInputField mutate(SolrInputField src) {
        SchemaField sf = this.schema.getFieldOrNull(src.getName());
        if (sf == null) {
            return null;
        }
        FieldType type = PreAnalyzedField.createFieldType(sf);
        if (type == null) {
            return null;
        }
        SolrInputField res = new SolrInputField(src.getName());
        res.setBoost(src.getBoost());
        for (Object o : src) {
            if (o == null) continue;
            Field pre = (Field)this.parser.createField(sf, o, 1.0f);
            if (pre != null) {
                res.addValue(pre, 1.0f);
                continue;
            }
            log.warn("Could not parse field {} - using original value as is: {}", (Object)src.getName(), o);
            res.addValue(o, 1.0f);
        }
        return res;
    }
}

