/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.update.processor;

import java.util.ArrayList;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.util.NamedList;
import org.apache.solr.core.PluginInfo;
import org.apache.solr.core.SolrCore;
import org.apache.solr.request.SolrQueryRequest;
import org.apache.solr.response.SolrQueryResponse;
import org.apache.solr.update.processor.DistributedUpdateProcessorFactory;
import org.apache.solr.update.processor.DistributingUpdateProcessorFactory;
import org.apache.solr.update.processor.RunUpdateProcessorFactory;
import org.apache.solr.update.processor.UpdateRequestProcessor;
import org.apache.solr.update.processor.UpdateRequestProcessorFactory;
import org.apache.solr.util.plugin.PluginInfoInitialized;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class UpdateRequestProcessorChain
implements PluginInfoInitialized {
    public static final Logger log = LoggerFactory.getLogger(UpdateRequestProcessorChain.class);
    private UpdateRequestProcessorFactory[] chain;
    private final SolrCore solrCore;

    public UpdateRequestProcessorChain(SolrCore solrCore) {
        this.solrCore = solrCore;
    }

    @Override
    public void init(PluginInfo info) {
        String infomsg = "updateRequestProcessorChain \"" + (null != info.name ? info.name : "") + "\"" + (info.isDefault() ? " (default)" : "");
        log.info("creating " + infomsg);
        ArrayList<UpdateRequestProcessorFactory> list = new ArrayList<UpdateRequestProcessorFactory>(this.solrCore.initPlugins(info.getChildren("processor"), UpdateRequestProcessorFactory.class, null));
        if (list.isEmpty()) {
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, infomsg + " require at least one processor");
        }
        int numDistrib = 0;
        int runIndex = -1;
        for (int i = list.size() - 1; 0 <= i; --i) {
            UpdateRequestProcessorFactory factory = (UpdateRequestProcessorFactory)list.get(i);
            if (factory instanceof DistributingUpdateProcessorFactory) {
                ++numDistrib;
            }
            if (!(factory instanceof RunUpdateProcessorFactory)) continue;
            runIndex = i;
        }
        if (1 < numDistrib) {
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, infomsg + " may not contain more then one " + "instance of DistributingUpdateProcessorFactory");
        }
        if (0 <= runIndex && 0 == numDistrib) {
            DistributedUpdateProcessorFactory distrib = new DistributedUpdateProcessorFactory();
            distrib.init(new NamedList());
            list.add(runIndex, distrib);
            log.info("inserting DistributedUpdateProcessorFactory into " + infomsg);
        }
        this.chain = list.toArray(new UpdateRequestProcessorFactory[list.size()]);
    }

    public UpdateRequestProcessorChain(UpdateRequestProcessorFactory[] chain, SolrCore solrCore) {
        this.chain = chain;
        this.solrCore = solrCore;
    }

    public UpdateRequestProcessor createProcessor(SolrQueryRequest req, SolrQueryResponse rsp) {
        UpdateRequestProcessor processor = null;
        UpdateRequestProcessor last = null;
        String distribPhase = req.getParams().get("update.distrib");
        boolean skipToDistrib = distribPhase != null;
        boolean afterDistrib = true;
        for (int i = this.chain.length - 1; i >= 0; --i) {
            UpdateRequestProcessorFactory factory = this.chain[i];
            if (skipToDistrib) {
                if (afterDistrib) {
                    if (factory instanceof DistributingUpdateProcessorFactory) {
                        afterDistrib = false;
                    }
                } else if (!(factory instanceof UpdateRequestProcessorFactory.RunAlways)) continue;
            }
            last = (processor = factory.getInstance(req, rsp, last)) == null ? last : processor;
        }
        return last;
    }

    public UpdateRequestProcessorFactory[] getFactories() {
        return this.chain;
    }
}

