/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.index.solr.configuration;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.apache.jackrabbit.oak.api.PropertyState;
import org.apache.jackrabbit.oak.api.Type;
import org.apache.jackrabbit.oak.plugins.index.solr.configuration.CommitPolicy;
import org.apache.jackrabbit.oak.plugins.index.solr.configuration.EmbeddedSolrServerConfiguration;
import org.apache.jackrabbit.oak.plugins.index.solr.configuration.OakSolrConfiguration;
import org.apache.jackrabbit.oak.plugins.index.solr.configuration.SolrServerConfiguration;
import org.apache.jackrabbit.oak.plugins.index.solr.configuration.SolrServerConfigurationProvider;
import org.apache.jackrabbit.oak.plugins.index.solr.server.EmbeddedSolrServerProvider;
import org.apache.jackrabbit.oak.spi.query.Filter;
import org.apache.jackrabbit.oak.spi.state.NodeState;

public abstract class OakSolrNodeStateConfiguration
implements OakSolrConfiguration,
SolrServerConfigurationProvider<EmbeddedSolrServerProvider> {
    protected abstract NodeState getConfigurationNodeState();

    @Override
    public String getFieldNameFor(Type<?> propertyType) {
        if (Type.BINARIES.equals(propertyType) || Type.BINARY.equals(propertyType)) {
            return propertyType.toString() + "_bin";
        }
        return null;
    }

    @Override
    public String getPathField() {
        return this.getStringValueFor("pathField", "path_exact");
    }

    @Override
    public String getFieldForPathRestriction(Filter.PathRestriction pathRestriction) {
        String fieldName = null;
        switch (pathRestriction) {
            case ALL_CHILDREN: {
                fieldName = this.getStringValueFor("descendantsField", "path_des");
                break;
            }
            case DIRECT_CHILDREN: {
                fieldName = this.getStringValueFor("childrenField", "path_child");
                break;
            }
            case EXACT: {
                fieldName = this.getStringValueFor("pathField", "path_exact");
                break;
            }
            case PARENT: {
                fieldName = this.getStringValueFor("parentField", "path_anc");
                break;
            }
            case NO_RESTRICTION: {
                break;
            }
        }
        return fieldName;
    }

    @Override
    public String getCatchAllField() {
        return this.getStringValueFor("catchAllField", "catch_all");
    }

    @Override
    public String getFieldForPropertyRestriction(Filter.PropertyRestriction propertyRestriction) {
        return null;
    }

    @Override
    public CommitPolicy getCommitPolicy() {
        return CommitPolicy.valueOf(this.getStringValueFor("commitPolicy", CommitPolicy.SOFT.toString()));
    }

    @Override
    public int getRows() {
        return this.getIntValueFor("rows", 50);
    }

    @Override
    public boolean useForPropertyRestrictions() {
        return this.getBooleanValueFor("propertyRestrictions", false);
    }

    @Override
    public boolean useForPrimaryTypes() {
        return this.getBooleanValueFor("primaryTypes", false);
    }

    @Override
    public boolean useForPathRestrictions() {
        return this.getBooleanValueFor("pathRestrictions", false);
    }

    @Override
    public Collection<String> getIgnoredProperties() {
        String ignoredPropertiesString = this.getStringValueFor("ignoredProperties", "");
        List<String> ignoredProperties = ignoredPropertiesString != null ? Arrays.asList(ignoredPropertiesString.split(",")) : Collections.emptyList();
        return ignoredProperties;
    }

    private boolean getBooleanValueFor(String propertyName, boolean defaultValue) {
        PropertyState property;
        boolean value = defaultValue;
        NodeState configurationNodeState = this.getConfigurationNodeState();
        if (configurationNodeState.exists() && (property = configurationNodeState.getProperty(propertyName)) != null) {
            value = (Boolean)property.getValue(Type.BOOLEAN);
        }
        return value;
    }

    private int getIntValueFor(String propertyName, int defaultValue) {
        PropertyState property;
        long value = defaultValue;
        NodeState configurationNodeState = this.getConfigurationNodeState();
        if (configurationNodeState.exists() && (property = configurationNodeState.getProperty(propertyName)) != null) {
            value = (Long)property.getValue(Type.LONG);
        }
        return (int)value;
    }

    private String getStringValueFor(String propertyName, String defaultValue) {
        PropertyState property;
        String value = defaultValue;
        NodeState configurationNodeState = this.getConfigurationNodeState();
        if (configurationNodeState.exists() && (property = configurationNodeState.getProperty(propertyName)) != null) {
            value = (String)property.getValue(Type.STRING);
        }
        return value;
    }

    @Override
    public SolrServerConfiguration<EmbeddedSolrServerProvider> getSolrServerConfiguration() {
        String solrHomePath = this.getStringValueFor("solrHomePath", "solr");
        String solrConfigPath = this.getStringValueFor("solrConfigPath", "solr.xml");
        String coreName = this.getStringValueFor("coreName", "oak");
        String context = this.getStringValueFor("solrContext", "/solr");
        Integer httpPort = Integer.valueOf(this.getStringValueFor("httpPort", "8983"));
        return new EmbeddedSolrServerConfiguration(solrHomePath, solrConfigPath, coreName).withHttpConfiguration(context, httpPort);
    }

    public final class Properties {
        public static final String SOLRHOME_PATH = "solrHomePath";
        public static final String SOLRCONFIG_PATH = "solrConfigPath";
        public static final String CONTEXT = "solrContext";
        public static final String HTTP_PORT = "httpPort";
        public static final String CORE_NAME = "coreName";
        public static final String PATH_FIELD = "pathField";
        public static final String PARENT_FIELD = "parentField";
        public static final String CHILDREN_FIELD = "childrenField";
        public static final String DESCENDANTS_FIELD = "descendantsField";
        public static final String CATCHALL_FIELD = "catchAllField";
        public static final String COMMIT_POLICY = "commitPolicy";
        public static final String ROWS = "rows";
        public static final String PROPERTY_RESTRICIONS = "propertyRestrictions";
        public static final String PRIMARY_TYPES = "primaryTypes";
        public static final String PATH_RESTRICTIONS = "pathRestrictions";
        public static final String IGNORED_PROPERTIES = "ignoredProperties";
    }
}

