/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.store.blockcache;

import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.solr.store.blockcache.Store;

public class BufferStore
implements Store {
    private static final Store EMPTY = new Store(){

        @Override
        public byte[] takeBuffer(int bufferSize) {
            return new byte[bufferSize];
        }

        @Override
        public void putBuffer(byte[] buffer) {
        }
    };
    private static final ConcurrentMap<Integer, BufferStore> bufferStores = new ConcurrentHashMap<Integer, BufferStore>();
    private final BlockingQueue<byte[]> buffers;
    private final int bufferSize;

    public static synchronized void initNewBuffer(int bufferSize, long totalAmount) {
        if (totalAmount == 0L) {
            return;
        }
        BufferStore bufferStore = (BufferStore)bufferStores.get(bufferSize);
        if (bufferStore == null) {
            long count = totalAmount / (long)bufferSize;
            if (count > Integer.MAX_VALUE) {
                count = Integer.MAX_VALUE;
            }
            BufferStore store = new BufferStore(bufferSize, (int)count);
            bufferStores.put(bufferSize, store);
        }
    }

    private BufferStore(int bufferSize, int count) {
        this.bufferSize = bufferSize;
        this.buffers = BufferStore.setupBuffers(bufferSize, count);
    }

    private static BlockingQueue<byte[]> setupBuffers(int bufferSize, int count) {
        ArrayBlockingQueue<byte[]> queue = new ArrayBlockingQueue<byte[]>(count);
        for (int i = 0; i < count; ++i) {
            queue.add(new byte[bufferSize]);
        }
        return queue;
    }

    public static Store instance(int bufferSize) {
        BufferStore bufferStore = (BufferStore)bufferStores.get(bufferSize);
        if (bufferStore == null) {
            return EMPTY;
        }
        return bufferStore;
    }

    @Override
    public byte[] takeBuffer(int bufferSize) {
        if (this.bufferSize != bufferSize) {
            throw new RuntimeException("Buffer with length [" + bufferSize + "] does not match buffer size of [" + bufferSize + "]");
        }
        return this.newBuffer((byte[])this.buffers.poll());
    }

    @Override
    public void putBuffer(byte[] buffer) {
        if (buffer == null) {
            return;
        }
        if (buffer.length != this.bufferSize) {
            throw new RuntimeException("Buffer with length [" + buffer.length + "] does not match buffer size of [" + this.bufferSize + "]");
        }
        this.checkReturn(this.buffers.offer(buffer));
    }

    private void checkReturn(boolean offer) {
    }

    private byte[] newBuffer(byte[] buf) {
        if (buf != null) {
            return buf;
        }
        return new byte[this.bufferSize];
    }
}

