/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.rest.schema;

import java.util.List;
import org.apache.solr.common.util.SimpleOrderedMap;
import org.apache.solr.rest.schema.BaseSchemaResource;
import org.apache.solr.schema.FieldType;
import org.restlet.resource.ResourceException;

abstract class BaseFieldTypeResource
extends BaseSchemaResource {
    private boolean showDefaults;

    protected BaseFieldTypeResource() {
    }

    @Override
    public void doInit() throws ResourceException {
        super.doInit();
        if (this.isExisting()) {
            this.showDefaults = this.getSolrRequest().getParams().getBool("showDefaults", false);
        }
    }

    protected SimpleOrderedMap<Object> getFieldTypeProperties(FieldType fieldType) {
        SimpleOrderedMap<Object> properties = fieldType.getNamedPropertyValues(this.showDefaults);
        properties.add("fields", this.getFieldsWithFieldType(fieldType));
        properties.add("dynamicFields", this.getDynamicFieldsWithFieldType(fieldType));
        return properties;
    }

    protected abstract List<String> getFieldsWithFieldType(FieldType var1);

    protected abstract List<String> getDynamicFieldsWithFieldType(FieldType var1);
}

