/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.index.solr.query;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import org.apache.jackrabbit.oak.plugins.index.aggregate.NodeAggregator;
import org.apache.jackrabbit.oak.plugins.index.solr.configuration.OakSolrConfiguration;
import org.apache.jackrabbit.oak.plugins.index.solr.query.SolrQueryIndex;
import org.apache.jackrabbit.oak.spi.query.Cursor;
import org.apache.jackrabbit.oak.spi.query.Filter;
import org.apache.jackrabbit.oak.spi.query.QueryIndex;
import org.apache.jackrabbit.oak.spi.state.NodeState;
import org.apache.solr.client.solrj.SolrQuery;
import org.apache.solr.client.solrj.SolrServer;
import org.apache.solr.client.solrj.embedded.EmbeddedSolrServer;
import org.apache.solr.common.SolrDocumentList;

public class AdvancedSolrQueryIndex
extends SolrQueryIndex
implements QueryIndex.AdvanceFulltextQueryIndex {
    private static final Map<String, Long> cache = new WeakHashMap<String, Long>();
    private final OakSolrConfiguration configuration;
    private final SolrServer solrServer;
    private final NodeAggregator aggregator;
    private final String name;

    public AdvancedSolrQueryIndex(String name, SolrServer solrServer, OakSolrConfiguration configuration, NodeAggregator aggregator) {
        super(name, solrServer, configuration, aggregator);
        this.name = name;
        this.configuration = configuration;
        this.solrServer = solrServer;
        this.aggregator = aggregator;
    }

    public List<QueryIndex.IndexPlan> getPlans(Filter filter, List<QueryIndex.OrderEntry> sortOrder, NodeState rootState) {
        if (this.getMatchingFilterRestrictions(filter) > 0) {
            return Collections.singletonList(this.planBuilder(filter).setEstimatedEntryCount(this.estimateEntryCount(filter)).build());
        }
        return Collections.emptyList();
    }

    private long estimateEntryCount(Filter filter) {
        long estimatedEntryCount;
        long cachedEstimate;
        String key = filter.toString();
        long l = cachedEstimate = cache.get(key) != null ? cache.get(key) : -1L;
        if (cachedEstimate >= 0L) {
            estimatedEntryCount = cachedEstimate;
        } else {
            Long updatedEstimation = this.initializeEstimation(filter);
            cache.put(key, updatedEstimation);
            estimatedEntryCount = updatedEstimation;
        }
        return estimatedEntryCount;
    }

    private Long initializeEstimation(Filter filter) {
        SolrQuery solrQuery = new SolrQuery("*:*");
        try {
            return this.solrServer.query(solrQuery).getResults().getNumFound() / 3L;
        }
        catch (Exception e) {
            return Long.MAX_VALUE;
        }
    }

    private QueryIndex.IndexPlan.Builder planBuilder(Filter filter) {
        return new QueryIndex.IndexPlan.Builder().setCostPerExecution(this.solrServer instanceof EmbeddedSolrServer ? 1.0 : 2.0).setCostPerEntry(0.3).setFilter(filter).setFulltextIndex(true).setIncludesNodeData(true).setDelayed(true);
    }

    @Override
    void onRetrievedDocs(Filter filter, SolrDocumentList docs) {
        cache.put(filter.toString(), docs.getNumFound());
    }

    public String getPlanDescription(QueryIndex.IndexPlan plan, NodeState root) {
        return plan.toString();
    }

    public Cursor query(QueryIndex.IndexPlan plan, NodeState rootState) {
        return super.query(plan.getFilter(), rootState);
    }

    @Override
    public NodeAggregator getNodeAggregator() {
        return this.aggregator;
    }

    @Override
    public double getCost(Filter filter, NodeState rootState) {
        return super.getCost(filter, rootState);
    }

    @Override
    public Cursor query(Filter filter, NodeState rootState) {
        return super.query(filter, rootState);
    }

    @Override
    public String getPlan(Filter filter, NodeState rootState) {
        return super.getPlan(filter, rootState);
    }

    @Override
    public String getIndexName() {
        return this.name;
    }
}

