/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.index.solr.query;

import com.google.common.collect.AbstractIterator;
import com.google.common.collect.Queues;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Deque;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.annotation.CheckForNull;
import org.apache.jackrabbit.oak.api.PropertyValue;
import org.apache.jackrabbit.oak.commons.PathUtils;
import org.apache.jackrabbit.oak.plugins.index.aggregate.NodeAggregator;
import org.apache.jackrabbit.oak.plugins.index.solr.configuration.OakSolrConfiguration;
import org.apache.jackrabbit.oak.plugins.index.solr.query.FilterQueryParser;
import org.apache.jackrabbit.oak.query.QueryEngineSettings;
import org.apache.jackrabbit.oak.query.fulltext.FullTextExpression;
import org.apache.jackrabbit.oak.query.fulltext.FullTextTerm;
import org.apache.jackrabbit.oak.query.fulltext.FullTextVisitor;
import org.apache.jackrabbit.oak.spi.query.Cursor;
import org.apache.jackrabbit.oak.spi.query.Cursors;
import org.apache.jackrabbit.oak.spi.query.Filter;
import org.apache.jackrabbit.oak.spi.query.IndexRow;
import org.apache.jackrabbit.oak.spi.query.PropertyValues;
import org.apache.jackrabbit.oak.spi.query.QueryIndex;
import org.apache.jackrabbit.oak.spi.state.NodeState;
import org.apache.solr.client.solrj.SolrQuery;
import org.apache.solr.client.solrj.SolrServer;
import org.apache.solr.client.solrj.response.QueryResponse;
import org.apache.solr.client.solrj.response.SpellCheckResponse;
import org.apache.solr.common.SolrDocument;
import org.apache.solr.common.SolrDocumentList;
import org.apache.solr.common.util.NamedList;
import org.apache.solr.common.util.SimpleOrderedMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SolrQueryIndex
implements QueryIndex.FulltextQueryIndex {
    public static final String TYPE = "solr";
    static final String NATIVE_SOLR_QUERY = "native*solr";
    static final String NATIVE_LUCENE_QUERY = "native*lucene";
    private final Logger log = LoggerFactory.getLogger(SolrQueryIndex.class);
    private final String name;
    private final SolrServer solrServer;
    private final OakSolrConfiguration configuration;
    private final NodeAggregator aggregator;

    public SolrQueryIndex(String name, SolrServer solrServer, OakSolrConfiguration configuration, NodeAggregator aggregator) {
        this.name = name;
        this.solrServer = solrServer;
        this.configuration = configuration;
        this.aggregator = aggregator;
    }

    public SolrQueryIndex(String name, SolrServer solrServer, OakSolrConfiguration configuration) {
        this(name, solrServer, configuration, null);
    }

    public String getIndexName() {
        return this.name;
    }

    public double getCost(Filter filter, NodeState root) {
        double cost = 10.0 / (double)this.getMatchingFilterRestrictions(filter);
        if (this.log.isDebugEnabled()) {
            this.log.debug("Solr: cost for {}\u00a0is {}", (Object)this.name, (Object)cost);
        }
        return cost;
    }

    int getMatchingFilterRestrictions(Filter filter) {
        int match = 0;
        if (filter.getFullTextConstraint() != null || filter.getFulltextConditions() != null && filter.getFulltextConditions().size() > 0) {
            ++match;
        }
        if (filter.getPathRestriction() != null && !Filter.PathRestriction.NO_RESTRICTION.equals((Object)filter.getPathRestriction()) && this.configuration.useForPathRestrictions()) {
            ++match;
        }
        if (filter.getPrimaryTypes().size() > 0 && this.configuration.useForPrimaryTypes()) {
            ++match;
        }
        if (filter.getPropertyRestrictions() != null && filter.getPropertyRestrictions().size() > 0 && (filter.getPropertyRestriction(NATIVE_SOLR_QUERY) != null || filter.getPropertyRestriction(NATIVE_LUCENE_QUERY) != null || this.configuration.useForPropertyRestrictions()) && !SolrQueryIndex.hasIgnoredProperties(filter.getPropertyRestrictions(), this.configuration)) {
            ++match;
        }
        return match;
    }

    private static boolean hasIgnoredProperties(Collection<Filter.PropertyRestriction> propertyRestrictions, OakSolrConfiguration configuration) {
        for (Filter.PropertyRestriction pr : propertyRestrictions) {
            if (!SolrQueryIndex.isIgnoredProperty(pr.propertyName, configuration)) continue;
            return true;
        }
        return false;
    }

    public String getPlan(Filter filter, NodeState nodeState) {
        return FilterQueryParser.getQuery(filter, this.configuration).toString();
    }

    private static Set<String> getRelativePaths(FullTextExpression ft) {
        final HashSet<String> relPaths = new HashSet<String>();
        ft.accept((FullTextVisitor)new FullTextVisitor.FullTextVisitorBase(){

            public boolean visit(FullTextTerm term) {
                String p = term.getPropertyName();
                if (p == null) {
                    relPaths.add("");
                } else {
                    if (p.startsWith("../") || p.startsWith("./")) {
                        throw new IllegalArgumentException("Relative parent is not supported:" + p);
                    }
                    if (PathUtils.getDepth((String)p) > 1) {
                        String parent = PathUtils.getParentPath((String)p);
                        relPaths.add(parent);
                    } else {
                        relPaths.add("");
                    }
                }
                return true;
            }
        });
        return relPaths;
    }

    public Cursor query(final Filter filter, NodeState root) {
        SolrRowCursor cursor;
        try {
            Set relPaths = filter.getFullTextConstraint() != null ? SolrQueryIndex.getRelativePaths(filter.getFullTextConstraint()) : Collections.emptySet();
            final String parent = relPaths.size() == 0 ? "" : (String)relPaths.iterator().next();
            final int parentDepth = PathUtils.getDepth((String)parent);
            cursor = new SolrRowCursor((Iterator<SolrResultRow>)new AbstractIterator<SolrResultRow>(){
                private final Set<String> seenPaths = Sets.newHashSet();
                private final Deque<SolrResultRow> queue = Queues.newArrayDeque();
                private SolrDocument lastDoc;
                private int offset = 0;
                private boolean noDocs = false;

                protected SolrResultRow computeNext() {
                    if (!this.queue.isEmpty() || this.loadDocs()) {
                        return this.queue.remove();
                    }
                    return (SolrResultRow)this.endOfData();
                }

                private SolrResultRow convertToRow(SolrDocument doc) {
                    String path = String.valueOf(doc.getFieldValue(SolrQueryIndex.this.configuration.getPathField()));
                    if (path != null) {
                        if ("".equals(path)) {
                            path = "/";
                        }
                        if (!parent.isEmpty()) {
                            if (this.seenPaths.contains(path = PathUtils.getAncestorPath((String)path, (int)parentDepth))) {
                                return null;
                            }
                            this.seenPaths.add(path);
                        }
                        float score = 0.0f;
                        Object scoreObj = doc.get("score");
                        if (scoreObj != null) {
                            score = ((Float)scoreObj).floatValue();
                        }
                        return new SolrResultRow(path, score, doc);
                    }
                    return null;
                }

                private boolean loadDocs() {
                    SolrDocument lastDocToRecord;
                    block19: {
                        if (this.noDocs) {
                            return false;
                        }
                        lastDocToRecord = null;
                        try {
                            Set suggestEntries;
                            NamedList<Object> response;
                            Map suggest;
                            SpellCheckResponse spellCheckResponse;
                            QueryResponse queryResponse;
                            SolrDocumentList docs;
                            if (SolrQueryIndex.this.log.isDebugEnabled()) {
                                SolrQueryIndex.this.log.debug("converting filter {}", (Object)filter);
                            }
                            SolrQuery query = FilterQueryParser.getQuery(filter, SolrQueryIndex.this.configuration);
                            if (this.lastDoc != null) {
                                ++this.offset;
                                int newOffset = this.offset * SolrQueryIndex.this.configuration.getRows();
                                query.setParam("start", String.valueOf(newOffset));
                            }
                            if (SolrQueryIndex.this.log.isDebugEnabled()) {
                                SolrQueryIndex.this.log.debug("sending query {}", (Object)query);
                            }
                            if ((docs = (queryResponse = SolrQueryIndex.this.solrServer.query(query)).getResults()) != null) {
                                SolrQueryIndex.this.onRetrievedDocs(filter, docs);
                                if (SolrQueryIndex.this.log.isDebugEnabled()) {
                                    SolrQueryIndex.this.log.debug("getting docs {}", (Object)docs);
                                }
                                for (SolrDocument doc : docs) {
                                    SolrResultRow row = this.convertToRow(doc);
                                    if (row != null) {
                                        this.queue.add(row);
                                    }
                                    lastDocToRecord = doc;
                                }
                            }
                            if ((spellCheckResponse = queryResponse.getSpellCheckResponse()) != null && spellCheckResponse.getSuggestions() != null && spellCheckResponse.getSuggestions().size() > 0) {
                                SolrDocument fakeDoc = new SolrDocument();
                                for (SpellCheckResponse.Suggestion suggestion : spellCheckResponse.getSuggestions()) {
                                    fakeDoc.addField("rep:spellcheck()", suggestion.getAlternatives());
                                }
                                this.queue.add(new SolrResultRow("/", 1.0, fakeDoc));
                                this.noDocs = true;
                            }
                            if ((suggest = (Map)(response = queryResponse.getResponse()).get("suggest")) != null && !(suggestEntries = suggest.entrySet()).isEmpty()) {
                                SolrDocument fakeDoc = new SolrDocument();
                                for (Map.Entry suggestor : suggestEntries) {
                                    SimpleOrderedMap suggestionResponses = (SimpleOrderedMap)suggestor.getValue();
                                    for (Map.Entry suggestionResponse : suggestionResponses) {
                                        SimpleOrderedMap suggestionResults = (SimpleOrderedMap)suggestionResponse.getValue();
                                        for (Map.Entry suggestionResult : suggestionResults) {
                                            if (!"suggestions".equals(suggestionResult.getKey())) continue;
                                            ArrayList suggestions = (ArrayList)suggestionResult.getValue();
                                            if (suggestions.isEmpty()) {
                                                fakeDoc.addField("rep:suggest()", "[]");
                                                continue;
                                            }
                                            for (SimpleOrderedMap suggestion : suggestions) {
                                                fakeDoc.addField("rep:suggest()", "{term=" + suggestion.get("term") + ",weight=" + suggestion.get("weight") + "}");
                                            }
                                        }
                                    }
                                }
                                this.queue.add(new SolrResultRow("/", 1.0, fakeDoc));
                                this.noDocs = true;
                            }
                        }
                        catch (Exception e) {
                            if (!SolrQueryIndex.this.log.isWarnEnabled()) break block19;
                            SolrQueryIndex.this.log.warn("query via {} failed.", (Object)SolrQueryIndex.this.solrServer, (Object)e);
                        }
                    }
                    if (lastDocToRecord != null) {
                        this.lastDoc = lastDocToRecord;
                    }
                    return !this.queue.isEmpty();
                }
            }, filter.getQueryEngineSettings());
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return cursor;
    }

    void onRetrievedDocs(Filter filter, SolrDocumentList docs) {
    }

    private boolean exists(SolrResultRow row, NodeState root) {
        boolean result = true;
        NodeState nodeState = root;
        for (String n : PathUtils.elements((String)row.path)) {
            if (nodeState.hasChildNode(n)) {
                nodeState = nodeState.getChildNode(n);
                continue;
            }
            result = false;
            break;
        }
        return result;
    }

    static boolean isIgnoredProperty(String propertyName, OakSolrConfiguration configuration) {
        return !NATIVE_LUCENE_QUERY.equals(propertyName) && !NATIVE_SOLR_QUERY.equals(propertyName) && (!configuration.useForPropertyRestrictions() || configuration.getUsedProperties().size() > 0 && !configuration.getUsedProperties().contains(propertyName) || propertyName.contains("/") || "rep:excerpt".equals(propertyName) || configuration.getIgnoredProperties().contains(propertyName));
    }

    @CheckForNull
    public NodeAggregator getNodeAggregator() {
        return this.aggregator;
    }

    static class SolrRowCursor
    implements Cursor {
        private final Cursor pathCursor;
        SolrResultRow currentRow;

        SolrRowCursor(final Iterator<SolrResultRow> it, QueryEngineSettings settings) {
            Iterator<String> pathIterator = new Iterator<String>(){

                @Override
                public boolean hasNext() {
                    return it.hasNext();
                }

                @Override
                public String next() {
                    SolrRowCursor.this.currentRow = (SolrResultRow)it.next();
                    return SolrRowCursor.this.currentRow.path;
                }

                @Override
                public void remove() {
                    it.remove();
                }
            };
            this.pathCursor = new Cursors.PathCursor((Iterator)pathIterator, true, settings);
        }

        public boolean hasNext() {
            return this.pathCursor.hasNext();
        }

        public void remove() {
            this.pathCursor.remove();
        }

        public IndexRow next() {
            final IndexRow pathRow = this.pathCursor.next();
            return new IndexRow(){

                public String getPath() {
                    return pathRow.getPath();
                }

                public PropertyValue getValue(String columnName) {
                    if ("jcr:score".equals(columnName)) {
                        return PropertyValues.newDouble((Double)SolrRowCursor.this.currentRow.score);
                    }
                    return SolrRowCursor.this.currentRow.doc != null ? PropertyValues.newString((String)String.valueOf(SolrRowCursor.this.currentRow.doc.getFieldValue(columnName))) : null;
                }
            };
        }
    }

    static class SolrResultRow {
        final String path;
        final double score;
        final SolrDocument doc;

        SolrResultRow(String path, double score) {
            this(path, score, null);
        }

        SolrResultRow(String path, double score, SolrDocument doc) {
            this.path = path;
            this.score = score;
            this.doc = doc;
        }

        public String toString() {
            return String.format("%s (%1.2f)", this.path, this.score);
        }
    }
}

