/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search.join;

import java.io.IOException;
import java.util.Locale;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.join.ScoreMode;
import org.apache.lucene.search.join.TermsCollector;
import org.apache.lucene.search.join.TermsIncludingScoreQuery;
import org.apache.lucene.search.join.TermsQuery;
import org.apache.lucene.search.join.TermsWithScoreCollector;

public final class JoinUtil {
    private JoinUtil() {
    }

    public static Query createJoinQuery(String fromField, boolean multipleValuesPerDocument, String toField, Query fromQuery, IndexSearcher fromSearcher, ScoreMode scoreMode) throws IOException {
        switch (scoreMode) {
            case None: {
                TermsCollector termsCollector = TermsCollector.create(fromField, multipleValuesPerDocument);
                fromSearcher.search(fromQuery, termsCollector);
                return new TermsQuery(toField, fromQuery, termsCollector.getCollectorTerms());
            }
            case Total: 
            case Max: 
            case Avg: {
                TermsWithScoreCollector termsWithScoreCollector = TermsWithScoreCollector.create(fromField, multipleValuesPerDocument, scoreMode);
                fromSearcher.search(fromQuery, termsWithScoreCollector);
                return new TermsIncludingScoreQuery(toField, multipleValuesPerDocument, termsWithScoreCollector.getCollectedTerms(), termsWithScoreCollector.getScoresPerTerm(), fromQuery);
            }
        }
        throw new IllegalArgumentException(String.format(Locale.ROOT, "Score mode %s isn't supported.", new Object[]{scoreMode}));
    }
}

