/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.index.solr.osgi;

import javax.annotation.Nonnull;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Deactivate;
import org.apache.felix.scr.annotations.Property;
import org.apache.felix.scr.annotations.Service;
import org.apache.jackrabbit.oak.plugins.index.solr.configuration.RemoteSolrServerConfiguration;
import org.apache.jackrabbit.oak.plugins.index.solr.configuration.SolrServerConfiguration;
import org.apache.jackrabbit.oak.plugins.index.solr.configuration.SolrServerConfigurationProvider;
import org.apache.jackrabbit.oak.plugins.index.solr.server.RemoteSolrServerProvider;
import org.osgi.service.component.ComponentContext;

@Component(metatype=true, immediate=true, label="Apache Jackrabbit Oak Solr remote server configuration")
@Service(value={SolrServerConfigurationProvider.class})
@Property(name="name", value={"remote"}, propertyPrivate=true)
public class RemoteSolrServerConfigurationProvider
implements SolrServerConfigurationProvider<RemoteSolrServerProvider> {
    @Property(value={"http://127.0.0.1:8983/solr/oak"}, label="Solr HTTP URL")
    private static final String SOLR_HTTP_URL = "solr.http.url";
    @Property(value={"127.0.0.1:9983"}, label="ZooKeeper host")
    private static final String SOLR_ZK_HOST = "solr.zk.host";
    @Property(value={"oak"}, label="Solr collection")
    private static final String SOLR_COLLECTION = "solr.collection";
    @Property(intValue={2}, label="No. of collection shards")
    private static final String SOLR_SHARDS_NO = "solr.shards.no";
    @Property(intValue={2}, label="Replication factor")
    private static final String SOLR_REPLICATION_FACTOR = "solr.replication.factor";
    @Property(value={""}, label="Solr configuration directory")
    private static final String SOLR_CONF_DIR = "solr.conf.dir";
    private String solrHttpUrl;
    private String solrZkHost;
    private String solrCollection;
    private int solrShardsNo;
    private int solrReplicationFactor;
    private String solrConfDir;
    private RemoteSolrServerConfiguration remoteSolrServerConfiguration;

    @Activate
    protected void activate(ComponentContext componentContext) throws Exception {
        this.solrHttpUrl = String.valueOf(componentContext.getProperties().get(SOLR_HTTP_URL));
        this.solrZkHost = String.valueOf(componentContext.getProperties().get(SOLR_ZK_HOST));
        this.solrCollection = String.valueOf(componentContext.getProperties().get(SOLR_COLLECTION));
        this.solrShardsNo = Integer.valueOf(componentContext.getProperties().get(SOLR_SHARDS_NO).toString());
        this.solrReplicationFactor = Integer.valueOf(componentContext.getProperties().get(SOLR_REPLICATION_FACTOR).toString());
        this.solrConfDir = String.valueOf(componentContext.getProperties().get(SOLR_CONF_DIR));
        this.remoteSolrServerConfiguration = new RemoteSolrServerConfiguration(this.solrZkHost, this.solrCollection, this.solrShardsNo, this.solrReplicationFactor, this.solrConfDir, this.solrHttpUrl);
    }

    @Deactivate
    protected void deactivate() throws Exception {
        this.solrHttpUrl = null;
        this.solrZkHost = null;
        this.solrCollection = null;
        this.solrShardsNo = 0;
        this.solrReplicationFactor = 0;
        this.solrConfDir = null;
    }

    @Override
    @Nonnull
    public SolrServerConfiguration<RemoteSolrServerProvider> getSolrServerConfiguration() {
        return this.remoteSolrServerConfiguration;
    }
}

