/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.search;

import com.carrotsearch.hppc.FloatArrayList;
import com.carrotsearch.hppc.IntOpenHashSet;
import com.carrotsearch.hppc.cursors.IntCursor;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.lucene.index.AtomicReader;
import org.apache.lucene.index.AtomicReaderContext;
import org.apache.lucene.index.DocsEnum;
import org.apache.lucene.index.SortedDocValues;
import org.apache.lucene.index.Terms;
import org.apache.lucene.index.TermsEnum;
import org.apache.lucene.queries.function.FunctionQuery;
import org.apache.lucene.queries.function.FunctionValues;
import org.apache.lucene.queries.function.ValueSource;
import org.apache.lucene.search.DocIdSetIterator;
import org.apache.lucene.search.FieldCache;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.util.Bits;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.FixedBitSet;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.params.ModifiableSolrParams;
import org.apache.solr.common.params.SolrParams;
import org.apache.solr.common.util.NamedList;
import org.apache.solr.request.LocalSolrQueryRequest;
import org.apache.solr.request.SolrQueryRequest;
import org.apache.solr.request.SolrQueryRequestBase;
import org.apache.solr.request.SolrRequestInfo;
import org.apache.solr.schema.FieldType;
import org.apache.solr.schema.IndexSchema;
import org.apache.solr.schema.SchemaField;
import org.apache.solr.schema.TrieFloatField;
import org.apache.solr.schema.TrieIntField;
import org.apache.solr.schema.TrieLongField;
import org.apache.solr.search.DelegatingCollector;
import org.apache.solr.search.ExtendedQueryBase;
import org.apache.solr.search.FunctionQParser;
import org.apache.solr.search.PostFilter;
import org.apache.solr.search.QParser;
import org.apache.solr.search.QParserPlugin;
import org.apache.solr.search.ScoreFilter;
import org.apache.solr.search.SolrIndexSearcher;
import org.apache.solr.search.SyntaxError;

public class CollapsingQParserPlugin
extends QParserPlugin {
    public static final String NAME = "collapse";
    public static final String NULL_COLLAPSE = "collapse";
    public static final String NULL_IGNORE = "ignore";
    public static final String NULL_EXPAND = "expand";

    @Override
    public void init(NamedList namedList) {
    }

    @Override
    public QParser createParser(String qstr, SolrParams localParams, SolrParams params, SolrQueryRequest request) {
        return new CollapsingQParser(qstr, localParams, params, request);
    }

    private class MinLongComp
    implements LongCompare {
        private MinLongComp() {
        }

        @Override
        public boolean test(long i1, long i2) {
            return i1 < i2;
        }
    }

    private class MaxLongComp
    implements LongCompare {
        private MaxLongComp() {
        }

        @Override
        public boolean test(long i1, long i2) {
            return i1 > i2;
        }
    }

    private class MinFloatComp
    implements FloatCompare {
        private MinFloatComp() {
        }

        @Override
        public boolean test(float i1, float i2) {
            return i1 < i2;
        }
    }

    private class MaxFloatComp
    implements FloatCompare {
        private MaxFloatComp() {
        }

        @Override
        public boolean test(float i1, float i2) {
            return i1 > i2;
        }
    }

    private class MinIntComp
    implements IntCompare {
        private MinIntComp() {
        }

        @Override
        public boolean test(int i1, int i2) {
            return i1 < i2;
        }
    }

    private class MaxIntComp
    implements IntCompare {
        private MaxIntComp() {
        }

        @Override
        public boolean test(int i1, int i2) {
            return i1 > i2;
        }
    }

    private static interface LongCompare {
        public boolean test(long var1, long var3);
    }

    private static interface FloatCompare {
        public boolean test(float var1, float var2);
    }

    private static interface IntCompare {
        public boolean test(int var1, int var2);
    }

    public static final class CollapseScore {
        public float score;
    }

    private class ValueSourceCollapse
    extends FieldValueCollapse {
        private FloatCompare comp;
        private float nullVal;
        private ValueSource valueSource;
        private FunctionValues functionValues;
        private float[] ordVals;
        private Map rcontext;
        private CollapseScore collapseScore;
        private float score;
        private boolean cscore;

        public ValueSourceCollapse(int maxDoc, String funcStr, int nullPolicy, int[] ords, boolean max, boolean needsScores, IntOpenHashSet boostDocs, FunctionQuery funcQuery, IndexSearcher searcher) throws IOException {
            super(maxDoc, null, nullPolicy, max, needsScores, boostDocs);
            this.collapseScore = new CollapseScore();
            this.valueSource = funcQuery.getValueSource();
            this.rcontext = ValueSource.newContext(searcher);
            this.ords = ords;
            this.ordVals = new float[ords.length];
            Arrays.fill(ords, -1);
            if (max) {
                this.comp = new MaxFloatComp();
                Arrays.fill(this.ordVals, -3.4028235E38f);
            } else {
                this.nullVal = Float.MAX_VALUE;
                this.comp = new MinFloatComp();
                Arrays.fill(this.ordVals, Float.MAX_VALUE);
            }
            if (funcStr.indexOf("cscore()") != -1) {
                this.cscore = true;
                this.rcontext.put("CSCORE", this.collapseScore);
            }
            if (this.needsScores) {
                this.scores = new float[ords.length];
                if (nullPolicy == 2) {
                    this.nullScores = new FloatArrayList();
                }
            }
        }

        @Override
        public void setNextReader(AtomicReaderContext context) throws IOException {
            this.functionValues = this.valueSource.getValues(this.rcontext, context);
        }

        @Override
        public void collapse(int ord, int contextDoc, int globalDoc) throws IOException {
            if (this.needsScores || this.cscore) {
                this.collapseScore.score = this.score = this.scorer.score();
            }
            float val = this.functionValues.floatVal(contextDoc);
            if (ord > -1) {
                if (this.comp.test(val, this.ordVals[ord])) {
                    this.ords[ord] = globalDoc;
                    this.ordVals[ord] = val;
                    if (this.needsScores) {
                        this.scores[ord] = this.score;
                    }
                }
            } else if (!this.collapsedSet.get(globalDoc)) {
                if (this.nullPolicy == 1) {
                    if (this.comp.test(val, this.nullVal)) {
                        this.nullVal = val;
                        this.nullDoc = globalDoc;
                        if (this.needsScores) {
                            this.nullScore = this.score;
                        }
                    }
                } else if (this.nullPolicy == 2) {
                    this.collapsedSet.set(globalDoc);
                    if (this.needsScores) {
                        this.nullScores.add(this.score);
                    }
                }
            }
        }
    }

    private class FloatValueCollapse
    extends FieldValueCollapse {
        private FieldCache.Floats vals;
        private FloatCompare comp;
        private float nullVal;
        private float[] ordVals;

        public FloatValueCollapse(int maxDoc, String field, int nullPolicy, int[] ords, boolean max, boolean needsScores, IntOpenHashSet boostDocs) throws IOException {
            super(maxDoc, field, nullPolicy, max, needsScores, boostDocs);
            this.ords = ords;
            this.ordVals = new float[ords.length];
            Arrays.fill(ords, -1);
            if (max) {
                this.comp = new MaxFloatComp();
                Arrays.fill(this.ordVals, -3.4028235E38f);
            } else {
                this.nullVal = Float.MAX_VALUE;
                this.comp = new MinFloatComp();
                Arrays.fill(this.ordVals, Float.MAX_VALUE);
            }
            if (needsScores) {
                this.scores = new float[ords.length];
                if (nullPolicy == 2) {
                    this.nullScores = new FloatArrayList();
                }
            }
        }

        @Override
        public void setNextReader(AtomicReaderContext context) throws IOException {
            this.vals = FieldCache.DEFAULT.getFloats(context.reader(), this.field, false);
        }

        @Override
        public void collapse(int ord, int contextDoc, int globalDoc) throws IOException {
            float val = this.vals.get(contextDoc);
            if (ord > -1) {
                if (this.comp.test(val, this.ordVals[ord])) {
                    this.ords[ord] = globalDoc;
                    this.ordVals[ord] = val;
                    if (this.needsScores) {
                        this.scores[ord] = this.scorer.score();
                    }
                }
            } else if (!this.collapsedSet.get(globalDoc)) {
                if (this.nullPolicy == 1) {
                    if (this.comp.test(val, this.nullVal)) {
                        this.nullVal = val;
                        this.nullDoc = globalDoc;
                        if (this.needsScores) {
                            this.nullScore = this.scorer.score();
                        }
                    }
                } else if (this.nullPolicy == 2) {
                    this.collapsedSet.set(globalDoc);
                    if (this.needsScores) {
                        this.nullScores.add(this.scorer.score());
                    }
                }
            }
        }
    }

    private class LongValueCollapse
    extends FieldValueCollapse {
        private FieldCache.Longs vals;
        private LongCompare comp;
        private long nullVal;
        private long[] ordVals;

        public LongValueCollapse(int maxDoc, String field, int nullPolicy, int[] ords, boolean max, boolean needsScores, IntOpenHashSet boostDocs) throws IOException {
            super(maxDoc, field, nullPolicy, max, needsScores, boostDocs);
            this.ords = ords;
            this.ordVals = new long[ords.length];
            Arrays.fill(ords, -1);
            if (max) {
                this.comp = new MaxLongComp();
                Arrays.fill(this.ordVals, Long.MIN_VALUE);
            } else {
                this.nullVal = Long.MAX_VALUE;
                this.comp = new MinLongComp();
                Arrays.fill(this.ordVals, Long.MAX_VALUE);
            }
            if (needsScores) {
                this.scores = new float[ords.length];
                if (nullPolicy == 2) {
                    this.nullScores = new FloatArrayList();
                }
            }
        }

        @Override
        public void setNextReader(AtomicReaderContext context) throws IOException {
            this.vals = FieldCache.DEFAULT.getLongs(context.reader(), this.field, false);
        }

        @Override
        public void collapse(int ord, int contextDoc, int globalDoc) throws IOException {
            long val = this.vals.get(contextDoc);
            if (ord > -1) {
                if (this.comp.test(val, this.ordVals[ord])) {
                    this.ords[ord] = globalDoc;
                    this.ordVals[ord] = val;
                    if (this.needsScores) {
                        this.scores[ord] = this.scorer.score();
                    }
                }
            } else if (!this.collapsedSet.get(globalDoc)) {
                if (this.nullPolicy == 1) {
                    if (this.comp.test(val, this.nullVal)) {
                        this.nullVal = val;
                        this.nullDoc = globalDoc;
                        if (this.needsScores) {
                            this.nullScore = this.scorer.score();
                        }
                    }
                } else if (this.nullPolicy == 2) {
                    this.collapsedSet.set(globalDoc);
                    if (this.needsScores) {
                        this.nullScores.add(this.scorer.score());
                    }
                }
            }
        }
    }

    private class IntValueCollapse
    extends FieldValueCollapse {
        private FieldCache.Ints vals;
        private IntCompare comp;
        private int nullVal;
        private int[] ordVals;

        public IntValueCollapse(int maxDoc, String field, int nullPolicy, int[] ords, boolean max, boolean needsScores, IntOpenHashSet boostDocs) throws IOException {
            super(maxDoc, field, nullPolicy, max, needsScores, boostDocs);
            this.ords = ords;
            this.ordVals = new int[ords.length];
            Arrays.fill(ords, -1);
            if (max) {
                this.comp = new MaxIntComp();
                Arrays.fill(this.ordVals, Integer.MIN_VALUE);
            } else {
                this.comp = new MinIntComp();
                Arrays.fill(this.ordVals, Integer.MAX_VALUE);
                this.nullVal = Integer.MAX_VALUE;
            }
            if (needsScores) {
                this.scores = new float[ords.length];
                if (nullPolicy == 2) {
                    this.nullScores = new FloatArrayList();
                }
            }
        }

        @Override
        public void setNextReader(AtomicReaderContext context) throws IOException {
            this.vals = FieldCache.DEFAULT.getInts(context.reader(), this.field, false);
        }

        @Override
        public void collapse(int ord, int contextDoc, int globalDoc) throws IOException {
            int val = this.vals.get(contextDoc);
            if (ord > -1) {
                if (this.comp.test(val, this.ordVals[ord])) {
                    this.ords[ord] = globalDoc;
                    this.ordVals[ord] = val;
                    if (this.needsScores) {
                        this.scores[ord] = this.scorer.score();
                    }
                }
            } else if (!this.collapsedSet.get(globalDoc)) {
                if (this.nullPolicy == 1) {
                    if (this.comp.test(val, this.nullVal)) {
                        this.nullVal = val;
                        this.nullDoc = globalDoc;
                        if (this.needsScores) {
                            this.nullScore = this.scorer.score();
                        }
                    }
                } else if (this.nullPolicy == 2) {
                    this.collapsedSet.set(globalDoc);
                    if (this.needsScores) {
                        this.nullScores.add(this.scorer.score());
                    }
                }
            }
        }
    }

    private abstract class FieldValueCollapse {
        protected int nullPolicy;
        protected int[] ords;
        protected Scorer scorer;
        protected FloatArrayList nullScores;
        protected float nullScore;
        protected float[] scores;
        protected FixedBitSet collapsedSet;
        protected IntOpenHashSet boostDocs;
        protected int nullDoc = -1;
        protected boolean needsScores;
        protected boolean max;
        protected String field;

        public abstract void collapse(int var1, int var2, int var3) throws IOException;

        public abstract void setNextReader(AtomicReaderContext var1) throws IOException;

        public FieldValueCollapse(int maxDoc, String field, int nullPolicy, boolean max, boolean needsScores, IntOpenHashSet boostDocs) {
            this.field = field;
            this.nullPolicy = nullPolicy;
            this.max = max;
            this.needsScores = needsScores;
            this.collapsedSet = new FixedBitSet(maxDoc);
            this.boostDocs = boostDocs;
            if (this.boostDocs != null) {
                for (IntCursor cursor : boostDocs) {
                    this.collapsedSet.set(cursor.value);
                }
            }
        }

        public FixedBitSet getCollapsedSet() {
            if (this.nullDoc > -1) {
                this.collapsedSet.set(this.nullDoc);
            }
            for (int i = 0; i < this.ords.length; ++i) {
                int doc = this.ords[i];
                if (doc <= -1) continue;
                this.collapsedSet.set(doc);
            }
            return this.collapsedSet;
        }

        public void setScorer(Scorer scorer) {
            this.scorer = scorer;
        }

        public FloatArrayList getNullScores() {
            return this.nullScores;
        }

        public float getNullScore() {
            return this.nullScore;
        }

        public float[] getScores() {
            return this.scores;
        }
    }

    private class CollapsingFieldValueCollector
    extends DelegatingCollector {
        private AtomicReaderContext[] contexts;
        private SortedDocValues values;
        private int docBase;
        private int maxDoc;
        private int nullPolicy;
        private FieldValueCollapse fieldValueCollapse;
        private boolean needsScores;
        private IntOpenHashSet boostDocs;

        public CollapsingFieldValueCollector(int maxDoc, int segments, SortedDocValues values, int nullPolicy, String field, boolean max, boolean needsScores, FieldType fieldType, IntOpenHashSet boostDocs, FunctionQuery funcQuery, IndexSearcher searcher) throws IOException {
            this.maxDoc = maxDoc;
            this.contexts = new AtomicReaderContext[segments];
            this.values = values;
            int valueCount = values.getValueCount();
            this.nullPolicy = nullPolicy;
            this.needsScores = needsScores;
            this.boostDocs = boostDocs;
            if (funcQuery != null) {
                this.fieldValueCollapse = new ValueSourceCollapse(maxDoc, field, nullPolicy, new int[valueCount], max, this.needsScores, boostDocs, funcQuery, searcher);
            } else if (fieldType instanceof TrieIntField) {
                this.fieldValueCollapse = new IntValueCollapse(maxDoc, field, nullPolicy, new int[valueCount], max, this.needsScores, boostDocs);
            } else if (fieldType instanceof TrieLongField) {
                this.fieldValueCollapse = new LongValueCollapse(maxDoc, field, nullPolicy, new int[valueCount], max, this.needsScores, boostDocs);
            } else if (fieldType instanceof TrieFloatField) {
                this.fieldValueCollapse = new FloatValueCollapse(maxDoc, field, nullPolicy, new int[valueCount], max, this.needsScores, boostDocs);
            } else {
                throw new IOException("min/max must be either TrieInt, TrieLong or TrieFloat.");
            }
        }

        @Override
        public boolean acceptsDocsOutOfOrder() {
            return false;
        }

        @Override
        public void setScorer(Scorer scorer) {
            this.fieldValueCollapse.setScorer(scorer);
        }

        @Override
        public void setNextReader(AtomicReaderContext context) throws IOException {
            this.contexts[context.ord] = context;
            this.docBase = context.docBase;
            this.fieldValueCollapse.setNextReader(context);
        }

        @Override
        public void collect(int docId) throws IOException {
            int globalDoc = docId + this.docBase;
            int ord = this.values.getOrd(globalDoc);
            this.fieldValueCollapse.collapse(ord, docId, globalDoc);
        }

        @Override
        public void finish() throws IOException {
            if (this.contexts.length == 0) {
                return;
            }
            int currentContext = 0;
            int currentDocBase = 0;
            int nextDocBase = currentContext + 1 < this.contexts.length ? this.contexts[currentContext + 1].docBase : this.maxDoc;
            this.delegate.setNextReader(this.contexts[currentContext]);
            DummyScorer dummy = new DummyScorer();
            this.delegate.setScorer(dummy);
            DocIdSetIterator it = this.fieldValueCollapse.getCollapsedSet().iterator();
            int docId = -1;
            int nullScoreIndex = 0;
            float[] scores = this.fieldValueCollapse.getScores();
            FloatArrayList nullScores = this.fieldValueCollapse.getNullScores();
            float nullScore = this.fieldValueCollapse.getNullScore();
            while ((docId = it.nextDoc()) != Integer.MAX_VALUE) {
                int contextDoc;
                if (this.needsScores) {
                    int ord = this.values.getOrd(docId);
                    if (ord > -1) {
                        dummy.score = scores[ord];
                    } else if (this.boostDocs != null && this.boostDocs.contains(docId)) {
                        dummy.score = 0.0f;
                    } else if (this.nullPolicy == 1) {
                        dummy.score = nullScore;
                    } else if (this.nullPolicy == 2) {
                        dummy.score = nullScores.get(nullScoreIndex++);
                    }
                }
                while (docId >= nextDocBase) {
                    currentDocBase = this.contexts[++currentContext].docBase;
                    nextDocBase = currentContext + 1 < this.contexts.length ? this.contexts[currentContext + 1].docBase : this.maxDoc;
                    this.delegate.setNextReader(this.contexts[currentContext]);
                    this.delegate.setScorer(dummy);
                }
                dummy.docId = contextDoc = docId - currentDocBase;
                this.delegate.collect(contextDoc);
            }
            if (this.delegate instanceof DelegatingCollector) {
                ((DelegatingCollector)this.delegate).finish();
            }
        }
    }

    private class CollapsingScoreCollector
    extends DelegatingCollector {
        private AtomicReaderContext[] contexts;
        private FixedBitSet collapsedSet;
        private SortedDocValues values;
        private int[] ords;
        private float[] scores;
        private int docBase;
        private int maxDoc;
        private int nullPolicy;
        private float nullScore = -3.4028235E38f;
        private int nullDoc;
        private FloatArrayList nullScores;
        private IntOpenHashSet boostDocs;

        public CollapsingScoreCollector(int maxDoc, int segments, SortedDocValues values, int nullPolicy, IntOpenHashSet boostDocs) {
            this.maxDoc = maxDoc;
            this.contexts = new AtomicReaderContext[segments];
            this.collapsedSet = new FixedBitSet(maxDoc);
            this.boostDocs = boostDocs;
            if (this.boostDocs != null) {
                for (IntCursor cursor : this.boostDocs) {
                    this.collapsedSet.set(cursor.value);
                }
            }
            this.values = values;
            int valueCount = values.getValueCount();
            this.ords = new int[valueCount];
            Arrays.fill(this.ords, -1);
            this.scores = new float[valueCount];
            Arrays.fill(this.scores, -3.4028235E38f);
            this.nullPolicy = nullPolicy;
            if (nullPolicy == 2) {
                this.nullScores = new FloatArrayList();
            }
        }

        @Override
        public boolean acceptsDocsOutOfOrder() {
            return false;
        }

        @Override
        public void setNextReader(AtomicReaderContext context) throws IOException {
            this.contexts[context.ord] = context;
            this.docBase = context.docBase;
        }

        @Override
        public void collect(int docId) throws IOException {
            int globalDoc = docId + this.docBase;
            int ord = this.values.getOrd(globalDoc);
            if (ord > -1) {
                float score = this.scorer.score();
                if (score > this.scores[ord]) {
                    this.ords[ord] = globalDoc;
                    this.scores[ord] = score;
                }
            } else if (!this.collapsedSet.get(globalDoc)) {
                if (this.nullPolicy == 1) {
                    float score = this.scorer.score();
                    if (score > this.nullScore) {
                        this.nullScore = score;
                        this.nullDoc = globalDoc;
                    }
                } else if (this.nullPolicy == 2) {
                    this.collapsedSet.set(globalDoc);
                    this.nullScores.add(this.scorer.score());
                }
            }
        }

        @Override
        public void finish() throws IOException {
            if (this.contexts.length == 0) {
                return;
            }
            if (this.nullScore > 0.0f) {
                this.collapsedSet.set(this.nullDoc);
            }
            for (int i = 0; i < this.ords.length; ++i) {
                int doc = this.ords[i];
                if (doc <= -1) continue;
                this.collapsedSet.set(doc);
            }
            int currentContext = 0;
            int currentDocBase = 0;
            int nextDocBase = currentContext + 1 < this.contexts.length ? this.contexts[currentContext + 1].docBase : this.maxDoc;
            this.delegate.setNextReader(this.contexts[currentContext]);
            DummyScorer dummy = new DummyScorer();
            this.delegate.setScorer(dummy);
            DocIdSetIterator it = this.collapsedSet.iterator();
            int docId = -1;
            int nullScoreIndex = 0;
            while ((docId = it.nextDoc()) != Integer.MAX_VALUE) {
                int contextDoc;
                int ord = this.values.getOrd(docId);
                if (ord > -1) {
                    dummy.score = this.scores[ord];
                } else if (this.boostDocs != null && this.boostDocs.contains(docId)) {
                    dummy.score = 0.0f;
                } else if (this.nullPolicy == 1) {
                    dummy.score = this.nullScore;
                } else if (this.nullPolicy == 2) {
                    dummy.score = this.nullScores.get(nullScoreIndex++);
                }
                while (docId >= nextDocBase) {
                    currentDocBase = this.contexts[++currentContext].docBase;
                    nextDocBase = currentContext + 1 < this.contexts.length ? this.contexts[currentContext + 1].docBase : this.maxDoc;
                    this.delegate.setNextReader(this.contexts[currentContext]);
                    this.delegate.setScorer(dummy);
                }
                dummy.docId = contextDoc = docId - currentDocBase;
                this.delegate.collect(contextDoc);
            }
            if (this.delegate instanceof DelegatingCollector) {
                ((DelegatingCollector)this.delegate).finish();
            }
        }
    }

    private class DummyScorer
    extends Scorer {
        public float score;
        public int docId;

        public DummyScorer() {
            super(null);
        }

        @Override
        public float score() {
            return this.score;
        }

        @Override
        public int freq() {
            return 0;
        }

        @Override
        public int advance(int i) {
            return -1;
        }

        @Override
        public int nextDoc() {
            return 0;
        }

        @Override
        public int docID() {
            return this.docId;
        }

        @Override
        public long cost() {
            return 0L;
        }
    }

    public class CollapsingPostFilter
    extends ExtendedQueryBase
    implements PostFilter,
    ScoreFilter {
        private String field;
        private String max;
        private String min;
        private boolean needsScores = true;
        private int nullPolicy;
        private Set<String> boosted;
        public static final int NULL_POLICY_IGNORE = 0;
        public static final int NULL_POLICY_COLLAPSE = 1;
        public static final int NULL_POLICY_EXPAND = 2;

        @Override
        public void setCache(boolean cache) {
        }

        @Override
        public void setCacheSep(boolean cacheSep) {
        }

        @Override
        public boolean getCacheSep() {
            return false;
        }

        @Override
        public boolean getCache() {
            return false;
        }

        @Override
        public int hashCode() {
            SolrRequestInfo info;
            if (this.boosted == null && (info = SolrRequestInfo.getRequestInfo()) != null) {
                this.boosted = (Set)info.getReq().getContext().get("BOOSTED");
            }
            int hashCode = this.field.hashCode();
            hashCode = this.max != null ? hashCode + this.max.hashCode() : hashCode;
            hashCode = this.min != null ? hashCode + this.min.hashCode() : hashCode;
            hashCode = this.boosted != null ? hashCode + ((Object)this.boosted).hashCode() : hashCode;
            hashCode += this.nullPolicy;
            return hashCode *= (1 + Float.floatToIntBits(this.getBoost())) * 31;
        }

        @Override
        public boolean equals(Object o) {
            if (o instanceof CollapsingPostFilter) {
                CollapsingPostFilter c = (CollapsingPostFilter)o;
                if (this.field.equals(c.field) && (this.max == null && c.max == null || this.max != null && c.max != null && this.max.equals(c.max)) && (this.min == null && c.min == null || this.min != null && c.min != null && this.min.equals(c.min)) && this.nullPolicy == c.nullPolicy && (this.boosted == null && c.boosted == null || this.boosted == c.boosted) && this.getBoost() == c.getBoost()) {
                    return true;
                }
            }
            return false;
        }

        @Override
        public int getCost() {
            return Math.max(super.getCost(), 100);
        }

        @Override
        public String toString(String s) {
            return s;
        }

        public CollapsingPostFilter(SolrParams localParams, SolrParams params, SolrQueryRequest request) throws IOException {
            String nPolicy;
            this.field = localParams.get("field");
            if (this.field == null) {
                throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Required 'field' param is missing.");
            }
            this.max = localParams.get("max");
            this.min = localParams.get("min");
            if (this.min != null || this.max != null) {
                this.needsScores = this.needsScores(params);
            }
            if ((nPolicy = localParams.get("nullPolicy", CollapsingQParserPlugin.NULL_IGNORE)).equals(CollapsingQParserPlugin.NULL_IGNORE)) {
                this.nullPolicy = 0;
            } else if (nPolicy.equals("collapse")) {
                this.nullPolicy = 1;
            } else if (nPolicy.equals(CollapsingQParserPlugin.NULL_EXPAND)) {
                this.nullPolicy = 2;
            } else {
                throw new IOException("Invalid nullPolicy:" + nPolicy);
            }
        }

        private IntOpenHashSet getBoostDocs(SolrIndexSearcher indexSearcher, Set<String> boosted) throws IOException {
            IntOpenHashSet boostDocs = null;
            if (boosted != null) {
                SchemaField idField = indexSearcher.getSchema().getUniqueKeyField();
                String fieldName = idField.getName();
                HashSet<BytesRef> localBoosts = new HashSet<BytesRef>(boosted.size() * 2);
                Iterator<String> boostedIt = boosted.iterator();
                while (boostedIt.hasNext()) {
                    localBoosts.add(new BytesRef(boostedIt.next()));
                }
                boostDocs = new IntOpenHashSet(boosted.size() * 2);
                List<AtomicReaderContext> leaves = indexSearcher.getTopReaderContext().leaves();
                TermsEnum termsEnum = null;
                DocsEnum docsEnum = null;
                for (AtomicReaderContext leaf : leaves) {
                    AtomicReader reader = leaf.reader();
                    int docBase = leaf.docBase;
                    Bits liveDocs = reader.getLiveDocs();
                    Terms terms = reader.terms(fieldName);
                    termsEnum = terms.iterator(termsEnum);
                    Iterator it = localBoosts.iterator();
                    while (it.hasNext()) {
                        int doc;
                        BytesRef ref = (BytesRef)it.next();
                        if (!termsEnum.seekExact(ref) || (doc = (docsEnum = termsEnum.docs(liveDocs, docsEnum)).nextDoc()) == -1) continue;
                        boostDocs.add(doc + docBase);
                        it.remove();
                    }
                }
            }
            return boostDocs;
        }

        @Override
        public DelegatingCollector getFilterCollector(IndexSearcher indexSearcher) {
            try {
                SolrRequestInfo info;
                FunctionQParser functionQParser;
                ModifiableSolrParams params;
                SolrQueryRequestBase request;
                SolrIndexSearcher searcher = (SolrIndexSearcher)indexSearcher;
                IndexSchema schema = searcher.getSchema();
                SchemaField schemaField = schema.getField(this.field);
                SortedDocValues docValues = null;
                FunctionQuery funcQuery = null;
                docValues = schemaField.hasDocValues() ? searcher.getAtomicReader().getSortedDocValues(this.field) : FieldCache.DEFAULT.getTermsIndex(searcher.getAtomicReader(), this.field);
                FieldType fieldType = null;
                if (this.max != null) {
                    if (this.max.indexOf("(") == -1) {
                        fieldType = searcher.getSchema().getField(this.max).getType();
                    } else {
                        request = null;
                        try {
                            params = new ModifiableSolrParams();
                            request = new LocalSolrQueryRequest(searcher.getCore(), params);
                            functionQParser = new FunctionQParser(this.max, null, null, request);
                            funcQuery = (FunctionQuery)functionQParser.parse();
                        }
                        catch (Exception e) {
                            throw new IOException(e);
                        }
                        finally {
                            request.close();
                        }
                    }
                }
                if (this.min != null) {
                    if (this.min.indexOf("(") == -1) {
                        fieldType = searcher.getSchema().getField(this.min).getType();
                    } else {
                        request = null;
                        try {
                            params = new ModifiableSolrParams();
                            request = new LocalSolrQueryRequest(searcher.getCore(), params);
                            functionQParser = new FunctionQParser(this.min, null, null, request);
                            funcQuery = (FunctionQuery)functionQParser.parse();
                        }
                        catch (Exception e) {
                            throw new IOException(e);
                        }
                        finally {
                            request.close();
                        }
                    }
                }
                int maxDoc = searcher.maxDoc();
                int leafCount = searcher.getTopReaderContext().leaves().size();
                if (this.boosted == null && (info = SolrRequestInfo.getRequestInfo()) != null) {
                    this.boosted = (Set)info.getReq().getContext().get("BOOSTED");
                }
                IntOpenHashSet boostDocs = this.getBoostDocs(searcher, this.boosted);
                if (this.min != null || this.max != null) {
                    return new CollapsingFieldValueCollector(maxDoc, leafCount, docValues, this.nullPolicy, this.max != null ? this.max : this.min, this.max != null, this.needsScores, fieldType, boostDocs, funcQuery, searcher);
                }
                return new CollapsingScoreCollector(maxDoc, leafCount, docValues, this.nullPolicy, boostDocs);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }

        private boolean needsScores(SolrParams params) {
            String sortSpec = params.get("sort");
            if (sortSpec != null && sortSpec.length() != 0) {
                String[] sorts;
                for (String s : sorts = sortSpec.split(",")) {
                    String[] parts = s.split(" ");
                    if (!parts[0].equals("score")) continue;
                    return true;
                }
            } else {
                return true;
            }
            String fl = params.get("fl");
            if (fl != null) {
                String[] fls;
                for (String f : fls = fl.split(",")) {
                    if (!f.trim().equals("score")) continue;
                    return true;
                }
            }
            return this.boosted != null;
        }
    }

    private class CollapsingQParser
    extends QParser {
        public CollapsingQParser(String qstr, SolrParams localParams, SolrParams params, SolrQueryRequest request) {
            super(qstr, localParams, params, request);
        }

        @Override
        public Query parse() throws SyntaxError {
            try {
                return new CollapsingPostFilter(this.localParams, this.params, this.req);
            }
            catch (Exception e) {
                throw new SyntaxError(e.getMessage(), e);
            }
        }
    }
}

