/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.store.blockcache;

import java.io.IOException;
import org.apache.lucene.store.IndexOutput;
import org.apache.solr.store.blockcache.BlockDirectory;
import org.apache.solr.store.blockcache.Cache;
import org.apache.solr.store.blockcache.ReusedBufferedIndexOutput;

public class CachedIndexOutput
extends ReusedBufferedIndexOutput {
    private final BlockDirectory directory;
    private final IndexOutput dest;
    private final int blockSize;
    private final String name;
    private final String location;
    private final Cache cache;

    public CachedIndexOutput(BlockDirectory directory, IndexOutput dest, int blockSize, String name, Cache cache, int bufferSize) {
        super(bufferSize);
        this.directory = directory;
        this.dest = dest;
        this.blockSize = blockSize;
        this.name = name;
        this.location = directory.getFileCacheLocation(name);
        this.cache = cache;
    }

    @Override
    public void flushInternal() throws IOException {
        this.dest.flush();
    }

    @Override
    public void closeInternal() throws IOException {
        this.dest.close();
        this.cache.renameCacheFile(this.location, this.directory.getFileCacheName(this.name));
    }

    @Override
    public void seekInternal(long pos) throws IOException {
        throw new IOException("Seek not supported");
    }

    private int writeBlock(long position, byte[] b, int offset, int length) throws IOException {
        long blockId = BlockDirectory.getBlock(position);
        int blockOffset = (int)BlockDirectory.getPosition(position);
        int lengthToWriteInBlock = Math.min(length, this.blockSize - blockOffset);
        this.dest.writeBytes(b, offset, lengthToWriteInBlock);
        this.cache.update(this.location, blockId, blockOffset, b, offset, lengthToWriteInBlock);
        return lengthToWriteInBlock;
    }

    @Override
    public void writeInternal(byte[] b, int offset, int length) throws IOException {
        long position = this.getBufferStart();
        while (length > 0) {
            int len = this.writeBlock(position, b, offset, length);
            position += (long)len;
            length -= len;
            offset += len;
        }
    }
}

