/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailet.crypto;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.security.InvalidAlgorithmParameterException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.cert.CertPath;
import java.security.cert.CertPathBuilder;
import java.security.cert.CertPathBuilderException;
import java.security.cert.CertPathBuilderResult;
import java.security.cert.CertSelector;
import java.security.cert.CertStore;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.PKIXBuilderParameters;
import java.security.cert.X509CertSelector;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import javax.mail.MessagingException;
import org.apache.james.mailet.crypto.InitJCE;
import org.apache.james.mailet.crypto.SMIMESignerInfo;
import org.bouncycastle.cms.SignerInformation;
import org.bouncycastle.cms.SignerInformationStore;
import org.bouncycastle.mail.smime.SMIMESigned;

public class KeyStoreHolder {
    protected KeyStore keyStore;

    public KeyStoreHolder() throws IOException, GeneralSecurityException {
        this("changeit");
    }

    public KeyStoreHolder(String password) throws IOException, GeneralSecurityException {
        this(System.getProperty("java.home") + "/lib/security/cacerts".replace('/', File.separatorChar), password, KeyStore.getDefaultType());
    }

    public KeyStoreHolder(String keyStoreFileName, String keyStorePassword, String keyStoreType) throws KeyStoreException, NoSuchAlgorithmException, CertificateException, NoSuchProviderException, IOException {
        if (keyStorePassword == null) {
            keyStorePassword = "";
        }
        try {
            InitJCE.init();
        }
        catch (InstantiationException e) {
            NoSuchProviderException ex = new NoSuchProviderException("Error during cryptography provider initialization. Has bcprov-jdkxx-yyy.jar been copied in the lib directory or installed in the system?");
            ex.initCause(e);
            throw ex;
        }
        catch (IllegalAccessException e) {
            NoSuchProviderException ex = new NoSuchProviderException("Error during cryptography provider initialization. Has bcprov-jdkxx-yyy.jar been copied in the lib directory or installed in the system?");
            ex.initCause(e);
            throw ex;
        }
        catch (ClassNotFoundException e) {
            NoSuchProviderException ex = new NoSuchProviderException("Error during cryptography provider initialization. Has bcprov-jdkxx-yyy.jar been copied in the lib directory or installed in the system?");
            ex.initCause(e);
            throw ex;
        }
        if (keyStoreType == null) {
            keyStoreType = KeyStore.getDefaultType();
        }
        this.keyStore = KeyStore.getInstance(keyStoreType);
        this.keyStore.load(new BufferedInputStream(new FileInputStream(keyStoreFileName)), keyStorePassword.toCharArray());
        if (this.keyStore.size() == 0) {
            throw new KeyStoreException("The keystore must be not empty");
        }
    }

    public List verifySignatures(SMIMESigned signed) throws Exception, MessagingException {
        CertStore certs = signed.getCertificatesAndCRLs("Collection", "BC");
        SignerInformationStore siginfo = signed.getSignerInfos();
        Collection sigCol = siginfo.getSigners();
        Iterator sigIterator = sigCol.iterator();
        ArrayList<SMIMESignerInfo> result = new ArrayList<SMIMESignerInfo>(sigCol.size());
        int i = 0;
        while (sigIterator.hasNext()) {
            SignerInformation info = (SignerInformation)sigIterator.next();
            Collection<? extends Certificate> certCollection = certs.getCertificates((CertSelector)info.getSID());
            Iterator<? extends Certificate> certIter = certCollection.iterator();
            if (certIter.hasNext()) {
                X509Certificate signerCert = (X509Certificate)certIter.next();
                CertPath path = KeyStoreHolder.verifyCertificate(signerCert, certs, this.keyStore);
                try {
                    if (info.verify(signerCert, "BC")) {
                        result.add(new SMIMESignerInfo(signerCert, path, true));
                    }
                }
                catch (Exception e) {
                    result.add(new SMIMESignerInfo(signerCert, path, false));
                }
            }
            ++i;
        }
        return result;
    }

    private static CertPath verifyCertificate(X509Certificate cert, CertStore store, KeyStore trustedStore) throws InvalidAlgorithmParameterException, KeyStoreException, MessagingException, CertPathBuilderException {
        CertPathBuilder pathBuilder;
        if (cert == null || store == null || trustedStore == null) {
            throw new IllegalArgumentException("cert == " + cert + ", store == " + store + ", trustedStore == " + trustedStore);
        }
        try {
            pathBuilder = CertPathBuilder.getInstance("PKIX", "BC");
        }
        catch (Exception e) {
            throw new MessagingException("Error during the creation of the certpathbuilder.", e);
        }
        X509CertSelector xcs = new X509CertSelector();
        xcs.setCertificate(cert);
        PKIXBuilderParameters params = new PKIXBuilderParameters(trustedStore, (CertSelector)xcs);
        params.addCertStore(store);
        params.setRevocationEnabled(false);
        try {
            CertPathBuilderResult result = pathBuilder.build(params);
            CertPath path = result.getCertPath();
            return path;
        }
        catch (CertPathBuilderException e) {
            return null;
        }
        catch (InvalidAlgorithmParameterException e) {
            throw new MessagingException("Error during the certification path search.", (Exception)e);
        }
    }
}

