/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailet.crypto.mailet;

import java.io.IOException;
import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.util.Enumeration;
import java.util.Properties;
import javax.mail.Address;
import javax.mail.MessagingException;
import javax.mail.Session;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;
import javax.mail.internet.ParseException;
import org.apache.james.mailet.crypto.KeyHolder;
import org.apache.mailet.Mail;
import org.apache.mailet.MailAddress;
import org.apache.mailet.base.GenericMailet;

public abstract class AbstractSign
extends GenericMailet {
    private static final String HEADERS_PATTERN = "[headers]";
    private static final String SIGNER_NAME_PATTERN = "[signerName]";
    private static final String SIGNER_ADDRESS_PATTERN = "[signerAddress]";
    private static final String REVERSE_PATH_PATTERN = "[reversePath]";
    private boolean debug;
    private Class keyHolderClass;
    private String explanationText;
    private KeyHolder keyHolder;
    private boolean postmasterSigns;
    private boolean rebuildFrom;
    private String signerName;

    protected abstract String[] getAllowedInitParameters();

    protected void initDebug() {
        this.setDebug(this.getInitParameter("debug") == null ? false : new Boolean(this.getInitParameter("debug")));
    }

    public boolean isDebug() {
        return this.debug;
    }

    public void setDebug(boolean debug) {
        this.debug = debug;
    }

    protected void initKeyHolderClass() throws MessagingException {
        String keyHolderClassName = this.getInitParameter("keyHolderClass");
        if (keyHolderClassName == null) {
            throw new MessagingException("<keyHolderClass> parameter missing.");
        }
        try {
            this.setKeyHolderClass(Class.forName(keyHolderClassName));
        }
        catch (ClassNotFoundException cnfe) {
            throw new MessagingException("The specified <keyHolderClass> does not exist: " + keyHolderClassName);
        }
        if (this.isDebug()) {
            this.log("keyHolderClass: " + this.getKeyHolderClass());
        }
    }

    public Class getKeyHolderClass() {
        return this.keyHolderClass;
    }

    public void setKeyHolderClass(Class keyHolderClass) {
        this.keyHolderClass = keyHolderClass;
    }

    protected void initExplanationText() {
        this.setExplanationText(this.getInitParameter("explanationText"));
        if (this.isDebug()) {
            this.log("Explanation text:\r\n" + this.getExplanationText());
        }
    }

    public String getExplanationText() {
        return this.explanationText;
    }

    public void setExplanationText(String explanationText) {
        this.explanationText = explanationText;
    }

    protected void initKeyHolder() throws Exception {
        String keyAlias;
        String keyStoreType;
        Constructor keyHolderConstructor = null;
        try {
            keyHolderConstructor = this.keyHolderClass.getConstructor(String.class, String.class, String.class, String.class, String.class);
        }
        catch (NoSuchMethodException nsme) {
            throw new MessagingException("The needed constructor does not exist: " + this.keyHolderClass + "(String, String, String, String, String)");
        }
        String keyStoreFileName = this.getInitParameter("keyStoreFileName");
        if (keyStoreFileName == null) {
            throw new MessagingException("<keyStoreFileName> parameter missing.");
        }
        String keyStorePassword = this.getInitParameter("keyStorePassword");
        if (keyStorePassword == null) {
            throw new MessagingException("<keyStorePassword> parameter missing.");
        }
        String keyAliasPassword = this.getInitParameter("keyAliasPassword");
        if (keyAliasPassword == null) {
            keyAliasPassword = keyStorePassword;
            if (this.isDebug()) {
                this.log("<keyAliasPassword> parameter not specified: will default to the <keyStorePassword> parameter.");
            }
        }
        if ((keyStoreType = this.getInitParameter("keyStoreType")) == null && this.isDebug()) {
            this.log("<keyStoreType> parameter not specified: the default will be as appropriate to the keyStore requested.");
        }
        if ((keyAlias = this.getInitParameter("keyAlias")) == null && this.isDebug()) {
            this.log("<keyAlias> parameter not specified: will look for the first one in the keystore.");
        }
        if (this.isDebug()) {
            StringBuffer logBuffer = new StringBuffer(1024).append("KeyStore related parameters:").append("  keyStoreFileName=").append(keyStoreFileName).append(", keyStoreType=").append(keyStoreType).append(", keyAlias=").append(keyAlias).append(" ");
            this.log(logBuffer.toString());
        }
        Object[] parameters = new String[]{keyStoreFileName, keyStorePassword, keyAlias, keyAliasPassword, keyStoreType};
        this.setKeyHolder((KeyHolder)keyHolderConstructor.newInstance(parameters));
        if (this.isDebug()) {
            this.log("Subject Distinguished Name: " + this.getKeyHolder().getSignerDistinguishedName());
        }
        if (this.getKeyHolder().getSignerAddress() == null) {
            throw new MessagingException("Signer address missing in the certificate.");
        }
    }

    protected KeyHolder getKeyHolder() {
        return this.keyHolder;
    }

    protected void setKeyHolder(KeyHolder keyHolder) {
        this.keyHolder = keyHolder;
    }

    protected void initPostmasterSigns() {
        this.setPostmasterSigns(this.getInitParameter("postmasterSigns") == null ? false : new Boolean(this.getInitParameter("postmasterSigns")));
    }

    public boolean isPostmasterSigns() {
        return this.postmasterSigns;
    }

    public void setPostmasterSigns(boolean postmasterSigns) {
        this.postmasterSigns = postmasterSigns;
    }

    protected void initRebuildFrom() throws MessagingException {
        this.setRebuildFrom(this.getInitParameter("rebuildFrom") == null ? false : new Boolean(this.getInitParameter("rebuildFrom")));
        if (this.isDebug()) {
            if (this.isRebuildFrom()) {
                this.log("Will modify the \"From:\" header.");
            } else {
                this.log("Will leave the \"From:\" header unchanged.");
            }
        }
    }

    public boolean isRebuildFrom() {
        return this.rebuildFrom;
    }

    public void setRebuildFrom(boolean rebuildFrom) {
        this.rebuildFrom = rebuildFrom;
    }

    protected void initSignerName() {
        this.setSignerName(this.getInitParameter("signerName"));
        if (this.getSignerName() == null) {
            if (this.getKeyHolder() == null) {
                throw new RuntimeException("initKeyHolder() must be invoked before initSignerName()");
            }
            this.setSignerName(this.getKeyHolder().getSignerCN());
            if (this.isDebug()) {
                this.log("<signerName> parameter not specified: will use the certificate signer \"CN=\" attribute.");
            }
        }
    }

    public String getSignerName() {
        return this.signerName;
    }

    public void setSignerName(String signerName) {
        this.signerName = signerName;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void init() throws MessagingException {
        StringBuffer logBuffer222;
        this.checkInitParameters(this.getAllowedInitParameters());
        try {
            try {
                this.initDebug();
                if (this.isDebug()) {
                    this.log("Initializing");
                }
                this.initKeyHolderClass();
                this.initKeyHolder();
                this.initSignerName();
                this.initPostmasterSigns();
                this.initRebuildFrom();
                this.initExplanationText();
            }
            catch (MessagingException me) {
                throw me;
            }
            catch (Exception e) {
                this.log("Exception thrown", e);
                throw new MessagingException("Exception thrown", e);
            }
            Object var3_1 = null;
            if (!this.isDebug()) return;
            logBuffer222 = new StringBuffer(1024).append("Other parameters:").append(", signerName=").append(this.getSignerName()).append(", postmasterSigns=").append(this.postmasterSigns).append(", rebuildFrom=").append(this.rebuildFrom).append(" ");
        }
        catch (Throwable throwable) {
            Object var3_2 = null;
            if (!this.isDebug()) throw throwable;
            StringBuffer logBuffer222 = new StringBuffer(1024).append("Other parameters:").append(", signerName=").append(this.getSignerName()).append(", postmasterSigns=").append(this.postmasterSigns).append(", rebuildFrom=").append(this.rebuildFrom).append(" ");
            this.log(logBuffer222.toString());
            throw throwable;
        }
        this.log(logBuffer222.toString());
    }

    public void service(Mail mail) throws MessagingException {
        try {
            if (!this.isOkToSign(mail)) {
                return;
            }
            MimeBodyPart wrapperBodyPart = this.getWrapperBodyPart(mail);
            MimeMessage originalMessage = mail.getMessage();
            MimeMultipart signedMimeMultipart = wrapperBodyPart != null ? this.getKeyHolder().generate(wrapperBodyPart) : this.getKeyHolder().generate(originalMessage);
            MimeMessage newMessage = new MimeMessage(Session.getDefaultInstance((Properties)System.getProperties(), null));
            Enumeration headerEnum = originalMessage.getAllHeaderLines();
            while (headerEnum.hasMoreElements()) {
                newMessage.addHeaderLine((String)headerEnum.nextElement());
            }
            newMessage.setSender((Address)new InternetAddress(this.getKeyHolder().getSignerAddress(), this.getSignerName()));
            if (this.isRebuildFrom()) {
                InternetAddress modifiedFromIA = new InternetAddress(this.getKeyHolder().getSignerAddress(), mail.getSender().toString());
                newMessage.setFrom((Address)modifiedFromIA);
                newMessage.setReplyTo(originalMessage.getReplyTo());
            }
            newMessage.setContent((Object)signedMimeMultipart, signedMimeMultipart.getContentType());
            String messageId = originalMessage.getMessageID();
            newMessage.saveChanges();
            if (messageId != null) {
                newMessage.setHeader("Message-ID", messageId);
            }
            mail.setMessage(newMessage);
            mail.setAttribute("org.apache.james.smime.signing.mailetname", (Serializable)((Object)((Object)((Object)this)).getClass().getName()));
            mail.setAttribute("org.apache.james.smime.signature.validity", (Serializable)((Object)"valid"));
            mail.setAttribute("org.apache.james.smime.signer.address", (Serializable)((Object)this.getKeyHolder().getSignerAddress()));
            if (this.isDebug()) {
                this.log("Message signed, reverse-path: " + mail.getSender() + ", Id: " + messageId);
            }
        }
        catch (MessagingException me) {
            this.log("MessagingException found - could not sign!", me);
            throw me;
        }
        catch (Exception e) {
            this.log("Exception found", e);
            throw new MessagingException("Exception thrown - could not sign!", e);
        }
    }

    protected boolean isOkToSign(Mail mail) throws MessagingException {
        MimeMessage mimeMessage;
        MailAddress reversePath = mail.getSender();
        if (reversePath == null) {
            return false;
        }
        String authUser = (String)((Object)mail.getAttribute("org.apache.james.SMTPAuthUser"));
        if (authUser == null) {
            return false;
        }
        if (this.getMailetContext().getPostmaster().equals((Object)reversePath)) {
            if (!this.isPostmasterSigns()) {
                return false;
            }
        } else {
            if (!reversePath.getUser().equals(authUser)) {
                return false;
            }
            if (!this.fromAddressSameAsReverse(mail)) {
                return false;
            }
        }
        return !(mimeMessage = mail.getMessage()).isMimeType("multipart/signed") && !mimeMessage.isMimeType("application/pkcs7-mime");
    }

    protected abstract MimeBodyPart getWrapperBodyPart(Mail var1) throws MessagingException, IOException;

    protected final boolean fromAddressSameAsReverse(Mail mail) {
        block6: {
            MailAddress reversePath = mail.getSender();
            if (reversePath == null) {
                return false;
            }
            try {
                InternetAddress[] fromArray = (InternetAddress[])mail.getMessage().getFrom();
                if (fromArray == null) break block6;
                for (int i = 0; i < fromArray.length; ++i) {
                    MailAddress mailAddress = null;
                    try {
                        mailAddress = new MailAddress(fromArray[i]);
                    }
                    catch (ParseException pe) {
                        this.log("Unable to parse a \"FROM\" header address: " + fromArray[i].toString() + "; ignoring.");
                        continue;
                    }
                    if (!mailAddress.equals((Object)reversePath)) continue;
                    return true;
                }
            }
            catch (MessagingException me) {
                this.log("Unable to parse the \"FROM\" header; ignoring.");
            }
        }
        return false;
    }

    protected final String getMessageHeaders(MimeMessage message) throws MessagingException {
        Enumeration heads = message.getAllHeaderLines();
        StringBuffer headBuffer = new StringBuffer(1024);
        while (heads.hasMoreElements()) {
            headBuffer.append(heads.nextElement().toString()).append("\r\n");
        }
        return headBuffer.toString();
    }

    protected final String getReplacedExplanationText(String explanationText, String signerName, String signerAddress, String reversePath, String headers) {
        String replacedExplanationText = explanationText;
        replacedExplanationText = this.getReplacedString(replacedExplanationText, SIGNER_NAME_PATTERN, signerName);
        replacedExplanationText = this.getReplacedString(replacedExplanationText, SIGNER_ADDRESS_PATTERN, signerAddress);
        replacedExplanationText = this.getReplacedString(replacedExplanationText, REVERSE_PATH_PATTERN, reversePath);
        replacedExplanationText = this.getReplacedString(replacedExplanationText, HEADERS_PATTERN, headers);
        return replacedExplanationText;
    }

    private String getReplacedString(String template, String pattern, String actual) {
        if (actual != null) {
            int index;
            StringBuffer sb = new StringBuffer(template.length());
            int fromIndex = 0;
            while ((index = template.indexOf(pattern, fromIndex)) >= 0) {
                sb.append(template.substring(fromIndex, index));
                sb.append(actual);
                fromIndex = index + pattern.length();
            }
            if (fromIndex < template.length()) {
                sb.append(template.substring(fromIndex));
            }
            return sb.toString();
        }
        return new String(template);
    }
}

