/****************************************************************
 * Licensed to the Apache Software Foundation (ASF) under one   *
 * or more contributor license agreements.  See the NOTICE file *
 * distributed with this work for additional information        *
 * regarding copyright ownership.  The ASF licenses this file   *
 * to you under the Apache License, Version 2.0 (the            *
 * "License"); you may not use this file except in compliance   *
 * with the License.  You may obtain a copy of the License at   *
 *                                                              *
 *   http://www.apache.org/licenses/LICENSE-2.0                 *
 *                                                              *
 * Unless required by applicable law or agreed to in writing,   *
 * software distributed under the License is distributed on an  *
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY       *
 * KIND, either express or implied.  See the License for the    *
 * specific language governing permissions and limitations      *
 * under the License.                                           *
 ****************************************************************/

/**
 * 
 */
package org.apache.james.imap.processor.fetch;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.channels.Channels;
import java.nio.channels.WritableByteChannel;

import org.apache.james.imap.message.response.FetchResponse.BodyElement;
import org.apache.james.mailbox.Content;
import org.apache.james.mailbox.InputStreamContent;

final class ContentBodyElement implements BodyElement {
    private final String name;

    private final Content content;

    public ContentBodyElement(final String name, final Content content) {
        super();
        this.name = name;
        this.content = content;
    }

    /**
     * @see org.apache.james.imap.message.response.FetchResponse.BodyElement#getName()
     */
    public String getName() {
        return name;
    }

    /**
     * @see org.apache.james.imap.message.response.FetchResponse.BodyElement#size()
     */
    public long size() {
        return content.size();
    }

    /**
     * @see org.apache.james.imap.message.response.FetchResponse.BodyElement#writeTo(WritableByteChannel)
     */
    public void writeTo(WritableByteChannel channel) throws IOException {
        content.writeTo(channel);
    }

    /*
     * (non-Javadoc)
     * @see org.apache.james.imap.message.response.Literal#getInputStream()
     */
    public InputStream getInputStream() throws IOException {
        if (content instanceof InputStreamContent) {
            return ((InputStreamContent) content).getInputStream();
        }
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        writeTo(Channels.newChannel(out));
        return new ByteArrayInputStream(out.toByteArray());
    }
}