/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jsieve;

import java.util.concurrent.ConcurrentMap;
import org.apache.jsieve.TestManager;
import org.apache.jsieve.exception.LookupException;
import org.apache.jsieve.tests.ExecutableTest;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TestManagerImpl
implements TestManager {
    private final ConcurrentMap<String, String> classNameMap;

    public TestManagerImpl(ConcurrentMap<String, String> classNameMap) {
        this.classNameMap = classNameMap;
    }

    public Class lookup(String name) throws LookupException {
        Class<?> testClass = null;
        try {
            testClass = this.getClass().getClassLoader().loadClass(this.getClassName(name));
        }
        catch (ClassNotFoundException e) {
            throw new LookupException("Test named '" + name + "' not found.");
        }
        if (!ExecutableTest.class.isAssignableFrom(testClass)) {
            throw new LookupException("Class " + testClass.getName() + " must implement " + ExecutableTest.class.getName());
        }
        return testClass;
    }

    @Override
    public ExecutableTest getTest(String name) throws LookupException {
        try {
            return (ExecutableTest)this.lookup(name).newInstance();
        }
        catch (InstantiationException e) {
            throw new LookupException(e.getMessage());
        }
        catch (IllegalAccessException e) {
            throw new LookupException(e.getMessage());
        }
    }

    private String getClassName(String name) throws LookupException {
        String className = (String)this.classNameMap.get(name.toLowerCase());
        if (null == className) {
            throw new LookupException("Test named '" + name + "' not mapped.");
        }
        return className;
    }
}

