/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jsieve;

import org.apache.jsieve.Argument;
import org.apache.jsieve.parser.generated.Token;

public class NumberArgument
implements Argument {
    private Integer fieldValue;

    private NumberArgument() {
    }

    public NumberArgument(Token token) {
        this();
        this.setValue(token);
    }

    protected void setValue(Integer number) {
        this.fieldValue = number;
    }

    public Object getValue() {
        return this.fieldValue;
    }

    public Integer getInteger() {
        return this.fieldValue;
    }

    protected void setValue(Token aToken) {
        int endIndex = aToken.image.length();
        int magnitude = 1;
        if (aToken.image.endsWith("K")) {
            magnitude = 1024;
            --endIndex;
        } else if (aToken.image.endsWith("M")) {
            magnitude = 0x100000;
            --endIndex;
        } else if (aToken.image.endsWith("G")) {
            magnitude = 0x40000000;
            --endIndex;
        }
        this.setValue(new Integer(Integer.parseInt(aToken.image.substring(0, endIndex)) * magnitude));
    }

    public String toString() {
        return this.getValue() == null ? "null" : this.getValue().toString();
    }
}

