/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jsieve.tests;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import org.apache.jsieve.Argument;
import org.apache.jsieve.Arguments;
import org.apache.jsieve.SieveContext;
import org.apache.jsieve.StringListArgument;
import org.apache.jsieve.TagArgument;
import org.apache.jsieve.comparators.ComparatorUtils;
import org.apache.jsieve.exception.SieveException;
import org.apache.jsieve.mail.MailAdapter;
import org.apache.jsieve.tests.AbstractTest;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Header
extends AbstractTest {
    @Override
    protected boolean executeBasic(MailAdapter mail, Arguments arguments, SieveContext context) throws SieveException {
        Argument argument;
        String comparator = null;
        String matchType = null;
        List<String> headerNames = null;
        List<String> keys = null;
        ListIterator<Argument> argumentsIter = arguments.getArgumentList().listIterator();
        boolean stop = false;
        while (!stop && argumentsIter.hasNext()) {
            argument = argumentsIter.next();
            if (argument instanceof TagArgument) {
                String tag = ((TagArgument)argument).getTag();
                if (null == comparator && tag.equals(":comparator")) {
                    if (!argumentsIter.hasNext()) continue;
                    argument = argumentsIter.next();
                    if (argument instanceof StringListArgument) {
                        List<String> stringList = ((StringListArgument)argument).getList();
                        if (stringList.size() != 1) {
                            throw context.getCoordinate().syntaxException("Expecting exactly one String");
                        }
                        comparator = stringList.get(0);
                        continue;
                    }
                    throw context.getCoordinate().syntaxException("Expecting a StringList");
                }
                if (null == matchType && (tag.equals(":is") || tag.equals(":contains") || tag.equals(":matches"))) {
                    matchType = tag;
                    continue;
                }
                throw context.getCoordinate().syntaxException("Found unexpected TagArgument: \"" + tag + "\"");
            }
            argumentsIter.previous();
            stop = true;
        }
        if (argumentsIter.hasNext() && (argument = argumentsIter.next()) instanceof StringListArgument) {
            headerNames = ((StringListArgument)argument).getList();
        }
        if (null == headerNames) {
            throw context.getCoordinate().syntaxException("Expecting a StringListof header names");
        }
        if (argumentsIter.hasNext() && (argument = argumentsIter.next()) instanceof StringListArgument) {
            keys = ((StringListArgument)argument).getList();
        }
        if (null == keys) {
            throw context.getCoordinate().syntaxException("Expecting a StringList of keys");
        }
        if (argumentsIter.hasNext()) {
            throw context.getCoordinate().syntaxException("Found unexpected arguments");
        }
        return this.match(mail, comparator == null ? "i;ascii-casemap" : comparator, matchType == null ? ":is" : matchType, headerNames, keys, context);
    }

    protected boolean match(MailAdapter mail, String comparator, String matchType, List<String> headerNames, List<String> keys, SieveContext context) throws SieveException {
        boolean isMatched = false;
        Iterator<String> headerNamesIter = headerNames.iterator();
        while (!isMatched && headerNamesIter.hasNext()) {
            isMatched = this.match(comparator, matchType, mail.getMatchingHeader(headerNamesIter.next()), keys, context);
        }
        return isMatched;
    }

    protected boolean match(String comparator, String matchType, List<String> headerValues, List<String> keys, SieveContext context) throws SieveException {
        if (headerValues.isEmpty()) {
            if (matchType.equals(":contains")) {
                headerValues = new ArrayList<String>(headerValues);
                headerValues.add("");
            } else {
                return false;
            }
        }
        boolean isMatched = false;
        Iterator<String> headerValuesIter = headerValues.iterator();
        while (!isMatched && headerValuesIter.hasNext()) {
            isMatched = this.match(comparator, matchType, headerValuesIter.next(), keys, context);
        }
        return isMatched;
    }

    protected boolean match(String comparator, String matchType, String headerValue, List<String> keys, SieveContext context) throws SieveException {
        String key;
        boolean isMatched = false;
        Iterator<String> i$ = keys.iterator();
        while (i$.hasNext() && !(isMatched = ComparatorUtils.match(comparator, matchType, headerValue, key = i$.next(), context))) {
        }
        return isMatched;
    }

    @Override
    protected void validateArguments(Arguments arguments, SieveContext context) throws SieveException {
        if (arguments.hasTests()) {
            throw context.getCoordinate().syntaxException("Found unexpected tests");
        }
    }
}

