/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jsieve.mailet;

import javax.mail.MessagingException;
import javax.mail.internet.MimeMessage;
import org.apache.commons.logging.Log;
import org.apache.jsieve.mail.Action;
import org.apache.jsieve.mail.ActionFileInto;
import org.apache.jsieve.mailet.ActionContext;
import org.apache.jsieve.mailet.ActionUtils;
import org.apache.jsieve.mailet.MailAction;
import org.apache.mailet.Mail;
import org.apache.mailet.MailAddress;

public class FileIntoAction
implements MailAction {
    private static final char HIERARCHY_DELIMITER = '.';

    public void execute(Action action, Mail mail, ActionContext context) throws MessagingException {
        if (action instanceof ActionFileInto) {
            ActionFileInto fileIntoAction = (ActionFileInto)action;
            this.execute(fileIntoAction, mail, context);
        }
    }

    public void execute(ActionFileInto anAction, Mail aMail, ActionContext context) throws MessagingException {
        Log log;
        String destinationMailbox = anAction.getDestination();
        boolean delivered = false;
        try {
            String mailbox;
            MailAddress recipient = ActionUtils.getSoleRecipient(aMail);
            MimeMessage localMessage = FileIntoAction.createMimeMessage(aMail, recipient);
            if (destinationMailbox.length() <= 0 || destinationMailbox.charAt(0) != '.') {
                destinationMailbox = '.' + destinationMailbox;
            }
            String host = (mailbox = destinationMailbox.replace('.', '/')).charAt(0) == '/' ? "@localhost" : "@localhost/";
            String url = "mailbox://" + recipient.getUser() + host + mailbox;
            context.post(url, localMessage);
            delivered = true;
        }
        catch (MessagingException ex) {
            Log log2 = context.getLog();
            if (log2.isDebugEnabled()) {
                log2.debug((Object)("Error while storing mail into. " + destinationMailbox), (Throwable)ex);
            }
            throw ex;
        }
        finally {
            aMail.setState("ghost");
        }
        if (delivered && (log = context.getLog()).isDebugEnabled()) {
            log.debug((Object)("Filed Message ID: " + aMail.getMessage().getMessageID() + " into destination: \"" + destinationMailbox + "\""));
        }
    }

    private static MimeMessage createMimeMessage(Mail aMail, MailAddress recipient) throws MessagingException {
        MimeMessage localMessage = new MimeMessage(aMail.getMessage()){

            protected void updateHeaders() throws MessagingException {
                if (this.getMessageID() == null) {
                    super.updateHeaders();
                } else {
                    this.modified = false;
                }
            }
        };
        localMessage.addHeader("Delivered-To", recipient.toString());
        localMessage.saveChanges();
        return localMessage;
    }
}

