/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailbox.jpa;

import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import org.apache.james.mailbox.MailboxSession;
import org.apache.james.mailbox.jpa.mail.JPAMailboxMapper;
import org.apache.james.mailbox.jpa.mail.JPAMessageMapper;
import org.apache.james.mailbox.jpa.user.JPASubscriptionMapper;
import org.apache.james.mailbox.store.MailboxSessionMapperFactory;
import org.apache.james.mailbox.store.mail.MailboxMapper;
import org.apache.james.mailbox.store.mail.MessageMapper;
import org.apache.james.mailbox.store.user.SubscriptionMapper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JPAMailboxSessionMapperFactory
extends MailboxSessionMapperFactory<Long> {
    private final EntityManagerFactory entityManagerFactory;
    private final char delimiter;

    public JPAMailboxSessionMapperFactory(EntityManagerFactory entityManagerFactory) {
        this(entityManagerFactory, '.');
    }

    public JPAMailboxSessionMapperFactory(EntityManagerFactory entityManagerFactory, char delimiter) {
        this.entityManagerFactory = entityManagerFactory;
        this.delimiter = delimiter;
    }

    public MailboxMapper<Long> createMailboxMapper(MailboxSession session) {
        return new JPAMailboxMapper(this.entityManagerFactory, this.delimiter);
    }

    public MessageMapper<Long> createMessageMapper(MailboxSession session) {
        return new JPAMessageMapper(this.entityManagerFactory);
    }

    public SubscriptionMapper createSubscriptionMapper(MailboxSession session) {
        return new JPASubscriptionMapper(this.entityManagerFactory);
    }

    public EntityManager createEntityManager() {
        return this.entityManagerFactory.createEntityManager();
    }
}

