/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailbox.jpa.mail.model.openjpa;

import java.io.Serializable;
import java.util.Date;
import java.util.List;
import javax.mail.Flags;
import javax.persistence.Basic;
import javax.persistence.Id;
import javax.persistence.IdClass;
import javax.persistence.MappedSuperclass;
import javax.persistence.NamedQueries;
import javax.persistence.NamedQuery;
import org.apache.james.mailbox.MailboxException;
import org.apache.james.mailbox.jpa.mail.model.JPAHeader;
import org.apache.james.mailbox.store.mail.model.AbstractMailboxMembership;
import org.apache.james.mailbox.store.mail.model.MailboxMembership;
import org.apache.james.mailbox.store.mail.model.PropertyBuilder;
import org.apache.openjpa.enhance.FieldConsumer;
import org.apache.openjpa.enhance.FieldSupplier;
import org.apache.openjpa.enhance.PCRegistry;
import org.apache.openjpa.enhance.PersistenceCapable;
import org.apache.openjpa.enhance.RedefinitionHelper;
import org.apache.openjpa.enhance.StateManager;
import org.apache.openjpa.persistence.jdbc.Index;
import org.apache.openjpa.util.ObjectId;
import org.apache.openjpa.util.UserException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@MappedSuperclass
@IdClass(value=MailboxIdUidKey.class)
@NamedQueries(value={@NamedQuery(name="findRecentMessagesInMailbox", query="SELECT membership FROM Membership membership WHERE membership.mailboxId = :idParam AND membership.recent = TRUE"), @NamedQuery(name="findUnseenMessagesInMailboxOrderByUid", query="SELECT membership FROM Membership membership WHERE membership.mailboxId = :idParam AND membership.seen = FALSE ORDER BY membership.uid ASC"), @NamedQuery(name="findMessagesInMailbox", query="SELECT membership FROM Membership membership WHERE membership.mailboxId = :idParam"), @NamedQuery(name="findMessagesInMailboxBetweenUIDs", query="SELECT membership FROM Membership membership WHERE membership.mailboxId = :idParam AND membership.uid BETWEEN :fromParam AND :toParam"), @NamedQuery(name="findMessagesInMailboxWithUID", query="SELECT membership FROM Membership membership WHERE membership.mailboxId = :idParam AND membership.uid=:uidParam"), @NamedQuery(name="findMessagesInMailboxAfterUID", query="SELECT membership FROM Membership membership WHERE membership.mailboxId = :idParam AND membership.uid>=:uidParam"), @NamedQuery(name="findDeletedMessagesInMailbox", query="SELECT membership FROM Membership membership WHERE membership.mailboxId = :idParam AND membership.deleted=TRUE"), @NamedQuery(name="findDeletedMessagesInMailboxBetweenUIDs", query="SELECT membership FROM Membership membership WHERE membership.mailboxId = :idParam AND membership.uid BETWEEN :fromParam AND :toParam AND membership.deleted=TRUE"), @NamedQuery(name="findDeletedMessagesInMailboxWithUID", query="SELECT membership FROM Membership membership WHERE membership.mailboxId = :idParam AND membership.uid=:uidParam AND membership.deleted=TRUE"), @NamedQuery(name="findDeletedMessagesInMailboxAfterUID", query="SELECT membership FROM Membership membership WHERE membership.mailboxId = :idParam AND membership.uid>=:uidParam AND membership.deleted=TRUE"), @NamedQuery(name="countUnseenMessagesInMailbox", query="SELECT COUNT(membership) FROM Membership membership WHERE membership.mailboxId = :idParam AND membership.seen=FALSE"), @NamedQuery(name="countMessagesInMailbox", query="SELECT COUNT(membership) FROM Membership membership WHERE membership.mailboxId = :idParam"), @NamedQuery(name="deleteMessages", query="DELETE FROM Membership membership WHERE membership.mailboxId = :idParam")})
public abstract class AbstractJPAMailboxMembership
extends AbstractMailboxMembership<Long> {
    private static final String TOSTRING_SEPARATOR = " ";
    @Id
    private long mailboxId;
    @Id
    private long uid;
    @Basic(optional=false)
    private Date internalDate;
    @Basic(optional=false)
    private boolean answered = false;
    @Basic(optional=false)
    @Index
    private boolean deleted = false;
    @Basic(optional=false)
    private boolean draft = false;
    @Basic(optional=false)
    private boolean flagged = false;
    @Basic(optional=false)
    @Index
    private boolean recent = false;
    @Basic(optional=false)
    @Index
    private boolean seen = false;
    private static int pcInheritedFieldCount;
    private static String[] pcFieldNames;
    private static Class[] pcFieldTypes;
    private static byte[] pcFieldFlags;
    private static Class pcPCSuperclass;
    protected transient StateManager pcStateManager;
    static /* synthetic */ Class class$Ljava$util$Date;
    static /* synthetic */ Class class$Lorg$apache$james$mailbox$jpa$mail$model$openjpa$AbstractJPAMailboxMembership;
    private transient Object pcDetachedState;

    @Deprecated
    public AbstractJPAMailboxMembership() {
    }

    public AbstractJPAMailboxMembership(long mailboxId, Date internalDate, Flags flags, int bodyStartOctet, List<JPAHeader> headers, PropertyBuilder propertyBuilder) throws MailboxException {
        this.mailboxId = mailboxId;
        this.internalDate = internalDate;
        this.setFlags(flags);
    }

    public AbstractJPAMailboxMembership(long mailboxId, MailboxMembership<?> original) throws MailboxException {
        this.mailboxId = mailboxId;
        this.internalDate = original.getInternalDate();
        this.answered = original.isAnswered();
        this.deleted = original.isDeleted();
        this.draft = original.isDraft();
        this.flagged = original.isFlagged();
        this.recent = original.isRecent();
        this.seen = original.isSeen();
    }

    public Date getInternalDate() {
        return AbstractJPAMailboxMembership.pcGetinternalDate(this);
    }

    public Long getMailboxId() {
        return AbstractJPAMailboxMembership.pcGetmailboxId(this);
    }

    public long getUid() {
        return AbstractJPAMailboxMembership.pcGetuid(this);
    }

    public boolean isAnswered() {
        return AbstractJPAMailboxMembership.pcGetanswered(this);
    }

    public boolean isDeleted() {
        return AbstractJPAMailboxMembership.pcGetdeleted(this);
    }

    public boolean isDraft() {
        return AbstractJPAMailboxMembership.pcGetdraft(this);
    }

    public boolean isFlagged() {
        return AbstractJPAMailboxMembership.pcGetflagged(this);
    }

    public boolean isRecent() {
        return AbstractJPAMailboxMembership.pcGetrecent(this);
    }

    public boolean isSeen() {
        return AbstractJPAMailboxMembership.pcGetseen(this);
    }

    public void unsetRecent() {
        AbstractJPAMailboxMembership.pcSetrecent(this, false);
    }

    public void setFlags(Flags flags) {
        AbstractJPAMailboxMembership.pcSetanswered(this, flags.contains(Flags.Flag.ANSWERED));
        AbstractJPAMailboxMembership.pcSetdeleted(this, flags.contains(Flags.Flag.DELETED));
        AbstractJPAMailboxMembership.pcSetdraft(this, flags.contains(Flags.Flag.DRAFT));
        AbstractJPAMailboxMembership.pcSetflagged(this, flags.contains(Flags.Flag.FLAGGED));
        AbstractJPAMailboxMembership.pcSetrecent(this, flags.contains(Flags.Flag.RECENT));
        AbstractJPAMailboxMembership.pcSetseen(this, flags.contains(Flags.Flag.SEEN));
    }

    public int hashCode() {
        int PRIME = 31;
        int result = 1;
        result = 31 * result + (int)(AbstractJPAMailboxMembership.pcGetmailboxId(this) ^ AbstractJPAMailboxMembership.pcGetmailboxId(this) >>> 32);
        result = 31 * result + (int)(AbstractJPAMailboxMembership.pcGetuid(this) ^ AbstractJPAMailboxMembership.pcGetuid(this) >>> 32);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (((Object)((Object)this)).getClass() != obj.getClass()) {
            return false;
        }
        AbstractJPAMailboxMembership other = (AbstractJPAMailboxMembership)((Object)obj);
        if (AbstractJPAMailboxMembership.pcGetmailboxId(this) != AbstractJPAMailboxMembership.pcGetmailboxId(other)) {
            return false;
        }
        return AbstractJPAMailboxMembership.pcGetuid(this) == AbstractJPAMailboxMembership.pcGetuid(other);
    }

    public String toString() {
        String retValue = "mailbox(mailboxId = " + AbstractJPAMailboxMembership.pcGetmailboxId(this) + TOSTRING_SEPARATOR + "uid = " + AbstractJPAMailboxMembership.pcGetuid(this) + TOSTRING_SEPARATOR + "internalDate = " + AbstractJPAMailboxMembership.pcGetinternalDate(this) + TOSTRING_SEPARATOR + "answered = " + AbstractJPAMailboxMembership.pcGetanswered(this) + TOSTRING_SEPARATOR + "deleted = " + AbstractJPAMailboxMembership.pcGetdeleted(this) + TOSTRING_SEPARATOR + "draft = " + AbstractJPAMailboxMembership.pcGetdraft(this) + TOSTRING_SEPARATOR + "flagged = " + AbstractJPAMailboxMembership.pcGetflagged(this) + TOSTRING_SEPARATOR + "recent = " + AbstractJPAMailboxMembership.pcGetrecent(this) + TOSTRING_SEPARATOR + "seen = " + AbstractJPAMailboxMembership.pcGetseen(this) + TOSTRING_SEPARATOR + " )";
        return retValue;
    }

    public void setUid(long uid) {
        AbstractJPAMailboxMembership.pcSetuid(this, uid);
    }

    public int pcGetEnhancementContractVersion() {
        return 2;
    }

    static {
        pcFieldNames = new String[]{"answered", "deleted", "draft", "flagged", "internalDate", "mailboxId", "recent", "seen", "uid"};
        Class[] classArray = new Class[9];
        classArray[0] = Boolean.TYPE;
        classArray[1] = Boolean.TYPE;
        classArray[2] = Boolean.TYPE;
        classArray[3] = Boolean.TYPE;
        Class clazz = class$Ljava$util$Date != null ? class$Ljava$util$Date : (class$Ljava$util$Date = AbstractJPAMailboxMembership.class$("java.util.Date"));
        classArray[4] = clazz;
        classArray[5] = Long.TYPE;
        classArray[6] = Boolean.TYPE;
        classArray[7] = Boolean.TYPE;
        classArray[8] = Long.TYPE;
        pcFieldTypes = classArray;
        pcFieldFlags = new byte[]{26, 26, 26, 26, 26, 26, 26, 26, 26};
        Class clazz2 = class$Lorg$apache$james$mailbox$jpa$mail$model$openjpa$AbstractJPAMailboxMembership != null ? class$Lorg$apache$james$mailbox$jpa$mail$model$openjpa$AbstractJPAMailboxMembership : (class$Lorg$apache$james$mailbox$jpa$mail$model$openjpa$AbstractJPAMailboxMembership = AbstractJPAMailboxMembership.class$("org.apache.james.mailbox.jpa.mail.model.openjpa.AbstractJPAMailboxMembership"));
        PCRegistry.register((Class)clazz2, (String[])pcFieldNames, (Class[])pcFieldTypes, (byte[])pcFieldFlags, (Class)pcPCSuperclass, (String)"AbstractJPAMailboxMembership", null);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    protected void pcClearFields() {
        this.answered = false;
        this.deleted = false;
        this.draft = false;
        this.flagged = false;
        this.internalDate = null;
        this.mailboxId = 0L;
        this.recent = false;
        this.seen = false;
        this.uid = 0L;
    }

    public PersistenceCapable pcNewInstance(StateManager stateManager, Object object, boolean bl) {
        throw new UserException();
    }

    public PersistenceCapable pcNewInstance(StateManager stateManager, boolean bl) {
        throw new UserException();
    }

    protected static int pcGetManagedFieldCount() {
        return 9;
    }

    public void pcReplaceField(int n) {
        int n2 = n - pcInheritedFieldCount;
        if (n2 < 0) {
            throw new IllegalArgumentException();
        }
        switch (n2) {
            case 0: {
                this.answered = this.pcStateManager.replaceBooleanField((PersistenceCapable)this, n);
                return;
            }
            case 1: {
                this.deleted = this.pcStateManager.replaceBooleanField((PersistenceCapable)this, n);
                return;
            }
            case 2: {
                this.draft = this.pcStateManager.replaceBooleanField((PersistenceCapable)this, n);
                return;
            }
            case 3: {
                this.flagged = this.pcStateManager.replaceBooleanField((PersistenceCapable)this, n);
                return;
            }
            case 4: {
                this.internalDate = (Date)this.pcStateManager.replaceObjectField((PersistenceCapable)this, n);
                return;
            }
            case 5: {
                this.mailboxId = this.pcStateManager.replaceLongField((PersistenceCapable)this, n);
                return;
            }
            case 6: {
                this.recent = this.pcStateManager.replaceBooleanField((PersistenceCapable)this, n);
                return;
            }
            case 7: {
                this.seen = this.pcStateManager.replaceBooleanField((PersistenceCapable)this, n);
                return;
            }
            case 8: {
                this.uid = this.pcStateManager.replaceLongField((PersistenceCapable)this, n);
                return;
            }
        }
        throw new IllegalArgumentException();
    }

    public void pcReplaceFields(int[] nArray) {
        int n = 0;
        while (n < nArray.length) {
            this.pcReplaceField(nArray[n]);
            ++n;
        }
    }

    public void pcProvideField(int n) {
        int n2 = n - pcInheritedFieldCount;
        if (n2 < 0) {
            throw new IllegalArgumentException();
        }
        switch (n2) {
            case 0: {
                this.pcStateManager.providedBooleanField((PersistenceCapable)this, n, this.answered);
                return;
            }
            case 1: {
                this.pcStateManager.providedBooleanField((PersistenceCapable)this, n, this.deleted);
                return;
            }
            case 2: {
                this.pcStateManager.providedBooleanField((PersistenceCapable)this, n, this.draft);
                return;
            }
            case 3: {
                this.pcStateManager.providedBooleanField((PersistenceCapable)this, n, this.flagged);
                return;
            }
            case 4: {
                this.pcStateManager.providedObjectField((PersistenceCapable)this, n, (Object)this.internalDate);
                return;
            }
            case 5: {
                this.pcStateManager.providedLongField((PersistenceCapable)this, n, this.mailboxId);
                return;
            }
            case 6: {
                this.pcStateManager.providedBooleanField((PersistenceCapable)this, n, this.recent);
                return;
            }
            case 7: {
                this.pcStateManager.providedBooleanField((PersistenceCapable)this, n, this.seen);
                return;
            }
            case 8: {
                this.pcStateManager.providedLongField((PersistenceCapable)this, n, this.uid);
                return;
            }
        }
        throw new IllegalArgumentException();
    }

    public void pcProvideFields(int[] nArray) {
        int n = 0;
        while (n < nArray.length) {
            this.pcProvideField(nArray[n]);
            ++n;
        }
    }

    protected void pcCopyField(AbstractJPAMailboxMembership abstractJPAMailboxMembership, int n) {
        int n2 = n - pcInheritedFieldCount;
        if (n2 < 0) {
            throw new IllegalArgumentException();
        }
        switch (n2) {
            case 0: {
                this.answered = abstractJPAMailboxMembership.answered;
                return;
            }
            case 1: {
                this.deleted = abstractJPAMailboxMembership.deleted;
                return;
            }
            case 2: {
                this.draft = abstractJPAMailboxMembership.draft;
                return;
            }
            case 3: {
                this.flagged = abstractJPAMailboxMembership.flagged;
                return;
            }
            case 4: {
                this.internalDate = abstractJPAMailboxMembership.internalDate;
                return;
            }
            case 5: {
                this.mailboxId = abstractJPAMailboxMembership.mailboxId;
                return;
            }
            case 6: {
                this.recent = abstractJPAMailboxMembership.recent;
                return;
            }
            case 7: {
                this.seen = abstractJPAMailboxMembership.seen;
                return;
            }
            case 8: {
                this.uid = abstractJPAMailboxMembership.uid;
                return;
            }
        }
        throw new IllegalArgumentException();
    }

    public void pcCopyFields(Object object, int[] nArray) {
        AbstractJPAMailboxMembership abstractJPAMailboxMembership = (AbstractJPAMailboxMembership)((Object)object);
        if (abstractJPAMailboxMembership.pcStateManager != this.pcStateManager) {
            throw new IllegalArgumentException();
        }
        if (this.pcStateManager == null) {
            throw new IllegalStateException();
        }
        int n = 0;
        while (n < nArray.length) {
            this.pcCopyField(abstractJPAMailboxMembership, nArray[n]);
            ++n;
        }
    }

    public Object pcGetGenericContext() {
        if (this.pcStateManager == null) {
            return null;
        }
        return this.pcStateManager.getGenericContext();
    }

    public Object pcFetchObjectId() {
        if (this.pcStateManager == null) {
            return null;
        }
        return this.pcStateManager.fetchObjectId();
    }

    public boolean pcIsDeleted() {
        if (this.pcStateManager == null) {
            return false;
        }
        return this.pcStateManager.isDeleted();
    }

    public boolean pcIsDirty() {
        if (this.pcStateManager == null) {
            return false;
        }
        StateManager stateManager = this.pcStateManager;
        RedefinitionHelper.dirtyCheck((StateManager)stateManager);
        return stateManager.isDirty();
    }

    public boolean pcIsNew() {
        if (this.pcStateManager == null) {
            return false;
        }
        return this.pcStateManager.isNew();
    }

    public boolean pcIsPersistent() {
        if (this.pcStateManager == null) {
            return false;
        }
        return this.pcStateManager.isPersistent();
    }

    public boolean pcIsTransactional() {
        if (this.pcStateManager == null) {
            return false;
        }
        return this.pcStateManager.isTransactional();
    }

    public boolean pcSerializing() {
        if (this.pcStateManager == null) {
            return false;
        }
        return this.pcStateManager.serializing();
    }

    public void pcDirty(String string) {
        if (this.pcStateManager == null) {
            return;
        }
        this.pcStateManager.dirty(string);
    }

    public StateManager pcGetStateManager() {
        return this.pcStateManager;
    }

    public Object pcGetVersion() {
        if (this.pcStateManager == null) {
            return null;
        }
        return this.pcStateManager.getVersion();
    }

    public synchronized void pcReplaceStateManager(StateManager stateManager) throws SecurityException {
        if (this.pcStateManager != null) {
            this.pcStateManager = this.pcStateManager.replaceStateManager(stateManager);
            return;
        }
        this.pcStateManager = stateManager;
    }

    public void pcCopyKeyFieldsToObjectId(FieldSupplier fieldSupplier, Object object) {
        MailboxIdUidKey mailboxIdUidKey = (MailboxIdUidKey)((ObjectId)object).getId();
        int n = pcInheritedFieldCount;
        mailboxIdUidKey.mailboxId = fieldSupplier.fetchLongField(5 + n);
        mailboxIdUidKey.uid = fieldSupplier.fetchLongField(8 + n);
    }

    public void pcCopyKeyFieldsToObjectId(Object object) {
        MailboxIdUidKey mailboxIdUidKey = (MailboxIdUidKey)((ObjectId)object).getId();
        mailboxIdUidKey.mailboxId = this.mailboxId;
        mailboxIdUidKey.uid = this.uid;
    }

    public void pcCopyKeyFieldsFromObjectId(FieldConsumer fieldConsumer, Object object) {
        MailboxIdUidKey mailboxIdUidKey = (MailboxIdUidKey)((ObjectId)object).getId();
        fieldConsumer.storeLongField(5 + pcInheritedFieldCount, mailboxIdUidKey.mailboxId);
        fieldConsumer.storeLongField(8 + pcInheritedFieldCount, mailboxIdUidKey.uid);
    }

    public void pcCopyKeyFieldsFromObjectId(Object object) {
        MailboxIdUidKey mailboxIdUidKey = (MailboxIdUidKey)((ObjectId)object).getId();
        this.mailboxId = mailboxIdUidKey.mailboxId;
        this.uid = mailboxIdUidKey.uid;
    }

    public Class pcGetIDOwningClass() {
        Class clazz = class$Lorg$apache$james$mailbox$jpa$mail$model$openjpa$AbstractJPAMailboxMembership != null ? class$Lorg$apache$james$mailbox$jpa$mail$model$openjpa$AbstractJPAMailboxMembership : (class$Lorg$apache$james$mailbox$jpa$mail$model$openjpa$AbstractJPAMailboxMembership = AbstractJPAMailboxMembership.class$("org.apache.james.mailbox.jpa.mail.model.openjpa.AbstractJPAMailboxMembership"));
        return clazz;
    }

    public Object pcNewObjectIdInstance(Object object) {
        throw new IllegalArgumentException("The id type \"class org.apache.james.mailbox.jpa.mail.model.openjpa.AbstractJPAMailboxMembership$MailboxIdUidKey\" specified by persistent type \"class org.apache.james.mailbox.jpa.mail.model.openjpa.AbstractJPAMailboxMembership\" does not have a public class org.apache.james.mailbox.jpa.mail.model.openjpa.AbstractJPAMailboxMembership$MailboxIdUidKey(String) or class org.apache.james.mailbox.jpa.mail.model.openjpa.AbstractJPAMailboxMembership$MailboxIdUidKey(Class, String) constructor.");
    }

    public Object pcNewObjectIdInstance() {
        return new ObjectId(this.pcGetIDOwningClass(), (Object)new MailboxIdUidKey());
    }

    private static final boolean pcGetanswered(AbstractJPAMailboxMembership abstractJPAMailboxMembership) {
        if (abstractJPAMailboxMembership.pcStateManager == null) {
            return abstractJPAMailboxMembership.answered;
        }
        int n = pcInheritedFieldCount + 0;
        abstractJPAMailboxMembership.pcStateManager.accessingField(n);
        return abstractJPAMailboxMembership.answered;
    }

    private static final void pcSetanswered(AbstractJPAMailboxMembership abstractJPAMailboxMembership, boolean bl) {
        if (abstractJPAMailboxMembership.pcStateManager == null) {
            abstractJPAMailboxMembership.answered = bl;
            return;
        }
        abstractJPAMailboxMembership.pcStateManager.settingBooleanField((PersistenceCapable)abstractJPAMailboxMembership, pcInheritedFieldCount + 0, abstractJPAMailboxMembership.answered, bl, 0);
    }

    private static final boolean pcGetdeleted(AbstractJPAMailboxMembership abstractJPAMailboxMembership) {
        if (abstractJPAMailboxMembership.pcStateManager == null) {
            return abstractJPAMailboxMembership.deleted;
        }
        int n = pcInheritedFieldCount + 1;
        abstractJPAMailboxMembership.pcStateManager.accessingField(n);
        return abstractJPAMailboxMembership.deleted;
    }

    private static final void pcSetdeleted(AbstractJPAMailboxMembership abstractJPAMailboxMembership, boolean bl) {
        if (abstractJPAMailboxMembership.pcStateManager == null) {
            abstractJPAMailboxMembership.deleted = bl;
            return;
        }
        abstractJPAMailboxMembership.pcStateManager.settingBooleanField((PersistenceCapable)abstractJPAMailboxMembership, pcInheritedFieldCount + 1, abstractJPAMailboxMembership.deleted, bl, 0);
    }

    private static final boolean pcGetdraft(AbstractJPAMailboxMembership abstractJPAMailboxMembership) {
        if (abstractJPAMailboxMembership.pcStateManager == null) {
            return abstractJPAMailboxMembership.draft;
        }
        int n = pcInheritedFieldCount + 2;
        abstractJPAMailboxMembership.pcStateManager.accessingField(n);
        return abstractJPAMailboxMembership.draft;
    }

    private static final void pcSetdraft(AbstractJPAMailboxMembership abstractJPAMailboxMembership, boolean bl) {
        if (abstractJPAMailboxMembership.pcStateManager == null) {
            abstractJPAMailboxMembership.draft = bl;
            return;
        }
        abstractJPAMailboxMembership.pcStateManager.settingBooleanField((PersistenceCapable)abstractJPAMailboxMembership, pcInheritedFieldCount + 2, abstractJPAMailboxMembership.draft, bl, 0);
    }

    private static final boolean pcGetflagged(AbstractJPAMailboxMembership abstractJPAMailboxMembership) {
        if (abstractJPAMailboxMembership.pcStateManager == null) {
            return abstractJPAMailboxMembership.flagged;
        }
        int n = pcInheritedFieldCount + 3;
        abstractJPAMailboxMembership.pcStateManager.accessingField(n);
        return abstractJPAMailboxMembership.flagged;
    }

    private static final void pcSetflagged(AbstractJPAMailboxMembership abstractJPAMailboxMembership, boolean bl) {
        if (abstractJPAMailboxMembership.pcStateManager == null) {
            abstractJPAMailboxMembership.flagged = bl;
            return;
        }
        abstractJPAMailboxMembership.pcStateManager.settingBooleanField((PersistenceCapable)abstractJPAMailboxMembership, pcInheritedFieldCount + 3, abstractJPAMailboxMembership.flagged, bl, 0);
    }

    private static final Date pcGetinternalDate(AbstractJPAMailboxMembership abstractJPAMailboxMembership) {
        if (abstractJPAMailboxMembership.pcStateManager == null) {
            return abstractJPAMailboxMembership.internalDate;
        }
        int n = pcInheritedFieldCount + 4;
        abstractJPAMailboxMembership.pcStateManager.accessingField(n);
        return abstractJPAMailboxMembership.internalDate;
    }

    private static final void pcSetinternalDate(AbstractJPAMailboxMembership abstractJPAMailboxMembership, Date date) {
        if (abstractJPAMailboxMembership.pcStateManager == null) {
            abstractJPAMailboxMembership.internalDate = date;
            return;
        }
        abstractJPAMailboxMembership.pcStateManager.settingObjectField((PersistenceCapable)abstractJPAMailboxMembership, pcInheritedFieldCount + 4, (Object)abstractJPAMailboxMembership.internalDate, (Object)date, 0);
    }

    private static final long pcGetmailboxId(AbstractJPAMailboxMembership abstractJPAMailboxMembership) {
        if (abstractJPAMailboxMembership.pcStateManager == null) {
            return abstractJPAMailboxMembership.mailboxId;
        }
        int n = pcInheritedFieldCount + 5;
        abstractJPAMailboxMembership.pcStateManager.accessingField(n);
        return abstractJPAMailboxMembership.mailboxId;
    }

    private static final void pcSetmailboxId(AbstractJPAMailboxMembership abstractJPAMailboxMembership, long l) {
        if (abstractJPAMailboxMembership.pcStateManager == null) {
            abstractJPAMailboxMembership.mailboxId = l;
            return;
        }
        abstractJPAMailboxMembership.pcStateManager.settingLongField((PersistenceCapable)abstractJPAMailboxMembership, pcInheritedFieldCount + 5, abstractJPAMailboxMembership.mailboxId, l, 0);
    }

    private static final boolean pcGetrecent(AbstractJPAMailboxMembership abstractJPAMailboxMembership) {
        if (abstractJPAMailboxMembership.pcStateManager == null) {
            return abstractJPAMailboxMembership.recent;
        }
        int n = pcInheritedFieldCount + 6;
        abstractJPAMailboxMembership.pcStateManager.accessingField(n);
        return abstractJPAMailboxMembership.recent;
    }

    private static final void pcSetrecent(AbstractJPAMailboxMembership abstractJPAMailboxMembership, boolean bl) {
        if (abstractJPAMailboxMembership.pcStateManager == null) {
            abstractJPAMailboxMembership.recent = bl;
            return;
        }
        abstractJPAMailboxMembership.pcStateManager.settingBooleanField((PersistenceCapable)abstractJPAMailboxMembership, pcInheritedFieldCount + 6, abstractJPAMailboxMembership.recent, bl, 0);
    }

    private static final boolean pcGetseen(AbstractJPAMailboxMembership abstractJPAMailboxMembership) {
        if (abstractJPAMailboxMembership.pcStateManager == null) {
            return abstractJPAMailboxMembership.seen;
        }
        int n = pcInheritedFieldCount + 7;
        abstractJPAMailboxMembership.pcStateManager.accessingField(n);
        return abstractJPAMailboxMembership.seen;
    }

    private static final void pcSetseen(AbstractJPAMailboxMembership abstractJPAMailboxMembership, boolean bl) {
        if (abstractJPAMailboxMembership.pcStateManager == null) {
            abstractJPAMailboxMembership.seen = bl;
            return;
        }
        abstractJPAMailboxMembership.pcStateManager.settingBooleanField((PersistenceCapable)abstractJPAMailboxMembership, pcInheritedFieldCount + 7, abstractJPAMailboxMembership.seen, bl, 0);
    }

    private static final long pcGetuid(AbstractJPAMailboxMembership abstractJPAMailboxMembership) {
        if (abstractJPAMailboxMembership.pcStateManager == null) {
            return abstractJPAMailboxMembership.uid;
        }
        int n = pcInheritedFieldCount + 8;
        abstractJPAMailboxMembership.pcStateManager.accessingField(n);
        return abstractJPAMailboxMembership.uid;
    }

    private static final void pcSetuid(AbstractJPAMailboxMembership abstractJPAMailboxMembership, long l) {
        if (abstractJPAMailboxMembership.pcStateManager == null) {
            abstractJPAMailboxMembership.uid = l;
            return;
        }
        abstractJPAMailboxMembership.pcStateManager.settingLongField((PersistenceCapable)abstractJPAMailboxMembership, pcInheritedFieldCount + 8, abstractJPAMailboxMembership.uid, l, 0);
    }

    public Boolean pcIsDetached() {
        if (this.pcStateManager != null) {
            if (this.pcStateManager.isDetached()) {
                return Boolean.TRUE;
            }
            return Boolean.FALSE;
        }
        if (this.pcGetDetachedState() != null && this.pcGetDetachedState() != PersistenceCapable.DESERIALIZED) {
            return Boolean.TRUE;
        }
        if (!this.pcisDetachedStateDefinitive()) {
            return null;
        }
        return Boolean.FALSE;
    }

    private boolean pcisDetachedStateDefinitive() {
        return false;
    }

    public Object pcGetDetachedState() {
        return this.pcDetachedState;
    }

    public void pcSetDetachedState(Object object) {
        this.pcDetachedState = object;
    }

    public static class MailboxIdUidKey
    implements Serializable {
        private static final long serialVersionUID = 7847632032426660997L;
        public long mailboxId;
        public long uid;

        public int hashCode() {
            int PRIME = 31;
            int result = 1;
            result = 31 * result + (int)(this.mailboxId ^ this.mailboxId >>> 32);
            result = 31 * result + (int)(this.uid ^ this.uid >>> 32);
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            MailboxIdUidKey other = (MailboxIdUidKey)obj;
            if (this.mailboxId != other.mailboxId) {
                return false;
            }
            return this.uid == other.uid;
        }
    }
}

