/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailbox.jpa.openjpa;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.concurrent.atomic.AtomicLong;
import javax.mail.Flags;
import org.apache.james.mailbox.MailboxException;
import org.apache.james.mailbox.jpa.JPAMailboxSessionMapperFactory;
import org.apache.james.mailbox.jpa.JPAMessageManager;
import org.apache.james.mailbox.jpa.mail.model.JPAHeader;
import org.apache.james.mailbox.jpa.mail.model.openjpa.JPAStreamingMailboxMembership;
import org.apache.james.mailbox.store.mail.model.Header;
import org.apache.james.mailbox.store.mail.model.Mailbox;
import org.apache.james.mailbox.store.mail.model.MailboxMembership;
import org.apache.james.mailbox.store.mail.model.PropertyBuilder;
import org.apache.james.mailbox.util.MailboxEventDispatcher;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OpenJPAMessageManager
extends JPAMessageManager {
    private final boolean useStreaming;

    public OpenJPAMessageManager(JPAMailboxSessionMapperFactory mapperFactory, AtomicLong lastUid, MailboxEventDispatcher dispatcher, Mailbox<Long> mailbox) throws MailboxException {
        this(mapperFactory, lastUid, dispatcher, mailbox, false);
    }

    public OpenJPAMessageManager(JPAMailboxSessionMapperFactory mapperFactory, AtomicLong lastUid, MailboxEventDispatcher dispatcher, Mailbox<Long> mailbox, boolean useStreaming) throws MailboxException {
        super(mapperFactory, lastUid, dispatcher, mailbox);
        this.useStreaming = useStreaming;
    }

    @Override
    protected MailboxMembership<Long> createMessage(Date internalDate, int size, int bodyStartOctet, InputStream document, Flags flags, List<Header> headers, PropertyBuilder propertyBuilder) throws MailboxException {
        if (this.useStreaming) {
            ArrayList<JPAHeader> jpaHeaders = new ArrayList<JPAHeader>(headers.size());
            for (Header header : headers) {
                jpaHeaders.add((JPAHeader)header);
            }
            return new JPAStreamingMailboxMembership((Long)this.getMailboxEntity().getMailboxId(), internalDate, size, flags, document, bodyStartOctet, jpaHeaders, propertyBuilder);
        }
        return super.createMessage(internalDate, size, bodyStartOctet, document, flags, headers, propertyBuilder);
    }
}

