/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailbox.jpa.mail;

import java.util.List;
import javax.persistence.EntityExistsException;
import javax.persistence.EntityManagerFactory;
import javax.persistence.NoResultException;
import javax.persistence.PersistenceException;
import javax.persistence.RollbackException;
import org.apache.james.mailbox.MailboxException;
import org.apache.james.mailbox.MailboxExistsException;
import org.apache.james.mailbox.MailboxNotFoundException;
import org.apache.james.mailbox.MailboxPath;
import org.apache.james.mailbox.jpa.JPATransactionalMapper;
import org.apache.james.mailbox.jpa.mail.model.JPAMailbox;
import org.apache.james.mailbox.store.mail.MailboxMapper;
import org.apache.james.mailbox.store.mail.model.Mailbox;

public class JPAMailboxMapper
extends JPATransactionalMapper
implements MailboxMapper<Long> {
    private static final char SQL_WILDCARD_CHAR = '%';
    private String lastMailboxName;

    public JPAMailboxMapper(EntityManagerFactory entityManagerFactory) {
        super(entityManagerFactory);
    }

    @Override
    protected void commit() throws MailboxException {
        try {
            this.getEntityManager().getTransaction().commit();
        }
        catch (PersistenceException e) {
            Throwable t;
            if (e instanceof EntityExistsException) {
                throw new MailboxExistsException(this.lastMailboxName);
            }
            if (e instanceof RollbackException && (t = e.getCause()) != null && t instanceof EntityExistsException) {
                throw new MailboxExistsException(this.lastMailboxName);
            }
            throw new MailboxException("Commit of transaction failed", (Exception)((Object)e));
        }
    }

    public void save(Mailbox<Long> mailbox) throws MailboxException {
        try {
            this.lastMailboxName = mailbox.getName();
            this.getEntityManager().persist(mailbox);
        }
        catch (PersistenceException e) {
            throw new MailboxException("Save of mailbox " + mailbox.getName() + " failed", (Exception)((Object)e));
        }
    }

    public Mailbox<Long> findMailboxByPath(MailboxPath mailboxPath) throws MailboxException, MailboxNotFoundException {
        try {
            if (mailboxPath.getUser() == null) {
                return (JPAMailbox)this.getEntityManager().createNamedQuery("findMailboxByName").setParameter("nameParam", (Object)mailboxPath.getName()).setParameter("namespaceParam", (Object)mailboxPath.getNamespace()).getSingleResult();
            }
            return (JPAMailbox)this.getEntityManager().createNamedQuery("findMailboxByNameWithUser").setParameter("nameParam", (Object)mailboxPath.getName()).setParameter("namespaceParam", (Object)mailboxPath.getNamespace()).setParameter("userParam", (Object)mailboxPath.getUser()).getSingleResult();
        }
        catch (NoResultException e) {
            throw new MailboxNotFoundException(mailboxPath);
        }
        catch (PersistenceException e) {
            throw new MailboxException("Search of mailbox " + mailboxPath + " failed", (Exception)((Object)e));
        }
    }

    public void delete(Mailbox<Long> mailbox) throws MailboxException {
        try {
            this.getEntityManager().createNamedQuery("deleteMessages").setParameter("idParam", mailbox.getMailboxId()).executeUpdate();
            this.getEntityManager().remove(mailbox);
        }
        catch (PersistenceException e) {
            throw new MailboxException("Delete of mailbox " + mailbox + " failed", (Exception)((Object)e));
        }
    }

    public List<Mailbox<Long>> findMailboxWithPathLike(MailboxPath path) throws MailboxException {
        try {
            if (path.getUser() == null) {
                return this.getEntityManager().createNamedQuery("findMailboxWithNameLike").setParameter("nameParam", (Object)('%' + path.getName() + '%')).setParameter("namespaceParam", (Object)path.getNamespace()).getResultList();
            }
            return this.getEntityManager().createNamedQuery("findMailboxWithNameLikeWithUser").setParameter("nameParam", (Object)('%' + path.getName() + '%')).setParameter("namespaceParam", (Object)path.getNamespace()).setParameter("userParam", (Object)path.getUser()).getResultList();
        }
        catch (PersistenceException e) {
            throw new MailboxException("Search of mailbox " + path + " failed", (Exception)((Object)e));
        }
    }

    public void deleteAllMemberships() throws MailboxException {
        try {
            this.getEntityManager().createNamedQuery("deleteAllMemberships").executeUpdate();
        }
        catch (PersistenceException e) {
            throw new MailboxException("Delete of mailboxes failed", (Exception)((Object)e));
        }
    }

    public void deleteAllMailboxes() throws MailboxException {
        try {
            this.getEntityManager().createNamedQuery("deleteAllMailboxes").executeUpdate();
        }
        catch (PersistenceException e) {
            throw new MailboxException("Delete of mailboxes failed", (Exception)((Object)e));
        }
    }

    public boolean hasChildren(Mailbox<Long> mailbox, char delimiter) throws MailboxException, MailboxNotFoundException {
        String name = mailbox.getName() + delimiter + '%';
        Long numberOfChildMailboxes = mailbox.getUser() == null ? (Long)this.getEntityManager().createNamedQuery("countMailboxesWithNameLike").setParameter("nameParam", (Object)name).setParameter("namespaceParam", (Object)mailbox.getNamespace()).getSingleResult() : (Long)this.getEntityManager().createNamedQuery("countMailboxesWithNameLikeWithUser").setParameter("nameParam", (Object)name).setParameter("namespaceParam", (Object)mailbox.getNamespace()).setParameter("userParam", (Object)mailbox.getUser()).getSingleResult();
        return numberOfChildMailboxes != null && numberOfChildMailboxes > 0L;
    }

    public List<Mailbox<Long>> list() throws MailboxException {
        try {
            return this.getEntityManager().createNamedQuery("listMailboxes").getResultList();
        }
        catch (PersistenceException e) {
            throw new MailboxException("Delete of mailboxes failed", (Exception)((Object)e));
        }
    }
}

