/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailbox.jpa.mail;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.mail.Flags;
import javax.persistence.EntityManagerFactory;
import javax.persistence.PersistenceException;
import javax.persistence.Query;
import org.apache.james.mailbox.MailboxException;
import org.apache.james.mailbox.MessageRange;
import org.apache.james.mailbox.UpdatedFlags;
import org.apache.james.mailbox.jpa.JPATransactionalMapper;
import org.apache.james.mailbox.jpa.mail.model.JPAMailbox;
import org.apache.james.mailbox.jpa.mail.model.openjpa.AbstractJPAMessage;
import org.apache.james.mailbox.jpa.mail.model.openjpa.JPAMessage;
import org.apache.james.mailbox.jpa.mail.model.openjpa.JPAStreamingMessage;
import org.apache.james.mailbox.store.mail.MessageMapper;
import org.apache.james.mailbox.store.mail.model.Mailbox;
import org.apache.james.mailbox.store.mail.model.Message;
import org.apache.james.mailbox.store.transaction.Mapper;
import org.apache.openjpa.persistence.ArgumentException;

public class JPAMessageMapper
extends JPATransactionalMapper
implements MessageMapper<Long> {
    public JPAMessageMapper(EntityManagerFactory entityManagerFactory) {
        super(entityManagerFactory);
    }

    public void findInMailbox(Mailbox<Long> mailbox, MessageRange set, Mapper.MailboxMembershipCallback<Long> callback) throws MailboxException {
        try {
            List<Message<Long>> results;
            long from = set.getUidFrom();
            long to = set.getUidTo();
            int batchSize = set.getBatchSize();
            MessageRange.Type type = set.getType();
            do {
                switch (type) {
                    default: {
                        results = this.findMessagesInMailbox(mailbox, batchSize);
                        break;
                    }
                    case FROM: {
                        results = this.findMessagesInMailboxAfterUID(mailbox, from, batchSize);
                        break;
                    }
                    case ONE: {
                        results = this.findMessagesInMailboxWithUID(mailbox, from);
                        break;
                    }
                    case RANGE: {
                        results = this.findMessagesInMailboxBetweenUIDs(mailbox, from, to, batchSize);
                    }
                }
                if (results.size() <= 0) continue;
                callback.onMailboxMembers(results);
                from = results.get(results.size() - 1).getUid() + 1L;
            } while (results.size() > 0 && batchSize > 0);
        }
        catch (PersistenceException e) {
            throw new MailboxException("Search of MessageRange " + set + " failed in mailbox " + mailbox, (Exception)((Object)e));
        }
    }

    private List<Message<Long>> findMessagesInMailboxAfterUID(Mailbox<Long> mailbox, long uid, int batchSize) {
        Query query = this.getEntityManager().createNamedQuery("findMessagesInMailboxAfterUID").setParameter("idParam", mailbox.getMailboxId()).setParameter("uidParam", (Object)uid);
        if (batchSize > 0) {
            query.setMaxResults(batchSize);
        }
        return query.getResultList();
    }

    private List<Message<Long>> findMessagesInMailboxWithUID(Mailbox<Long> mailbox, long uid) {
        return this.getEntityManager().createNamedQuery("findMessagesInMailboxWithUID").setParameter("idParam", mailbox.getMailboxId()).setParameter("uidParam", (Object)uid).setMaxResults(1).getResultList();
    }

    private List<Message<Long>> findMessagesInMailboxBetweenUIDs(Mailbox<Long> mailbox, long from, long to, int batchSize) {
        Query query = this.getEntityManager().createNamedQuery("findMessagesInMailboxBetweenUIDs").setParameter("idParam", mailbox.getMailboxId()).setParameter("fromParam", (Object)from).setParameter("toParam", (Object)to);
        if (batchSize > 0) {
            query.setMaxResults(batchSize);
        }
        return query.getResultList();
    }

    private List<Message<Long>> findMessagesInMailbox(Mailbox<Long> mailbox, int batchSize) {
        Query query = this.getEntityManager().createNamedQuery("findMessagesInMailbox").setParameter("idParam", mailbox.getMailboxId());
        if (batchSize > 0) {
            query.setMaxResults(batchSize);
        }
        return query.getResultList();
    }

    public Iterator<Long> expungeMarkedForDeletionInMailbox(Mailbox<Long> mailbox, MessageRange set) throws MailboxException {
        try {
            List<Long> results;
            long from = set.getUidFrom();
            long to = set.getUidTo();
            switch (set.getType()) {
                case ONE: {
                    results = this.findDeletedMessagesInMailboxWithUID(mailbox, from);
                    this.deleteDeletedMessagesInMailboxWithUID(mailbox, from);
                    break;
                }
                case RANGE: {
                    results = this.findDeletedMessagesInMailboxBetweenUIDs(mailbox, from, to);
                    this.deleteDeletedMessagesInMailboxBetweenUIDs(mailbox, from, to);
                    break;
                }
                case FROM: {
                    results = this.findDeletedMessagesInMailboxAfterUID(mailbox, from);
                    this.deleteDeletedMessagesInMailboxAfterUID(mailbox, from);
                    break;
                }
                default: {
                    results = this.findDeletedMessagesInMailbox(mailbox);
                    this.deleteDeletedMessagesInMailbox(mailbox);
                }
            }
            return results.iterator();
        }
        catch (PersistenceException e) {
            throw new MailboxException("Search of MessageRange " + set + " failed in mailbox " + mailbox, (Exception)((Object)e));
        }
    }

    private int deleteDeletedMessagesInMailbox(Mailbox<Long> mailbox) {
        return this.getEntityManager().createNamedQuery("deleteDeletedMessagesInMailbox").setParameter("idParam", mailbox.getMailboxId()).executeUpdate();
    }

    private int deleteDeletedMessagesInMailboxAfterUID(Mailbox<Long> mailbox, long uid) {
        return this.getEntityManager().createNamedQuery("deleteDeletedMessagesInMailboxAfterUID").setParameter("idParam", mailbox.getMailboxId()).setParameter("uidParam", (Object)uid).executeUpdate();
    }

    private int deleteDeletedMessagesInMailboxWithUID(Mailbox<Long> mailbox, long uid) {
        return this.getEntityManager().createNamedQuery("deleteDeletedMessagesInMailboxWithUID").setParameter("idParam", mailbox.getMailboxId()).setParameter("uidParam", (Object)uid).executeUpdate();
    }

    private int deleteDeletedMessagesInMailboxBetweenUIDs(Mailbox<Long> mailbox, long from, long to) {
        return this.getEntityManager().createNamedQuery("deleteDeletedMessagesInMailboxBetweenUIDs").setParameter("idParam", mailbox.getMailboxId()).setParameter("fromParam", (Object)from).setParameter("toParam", (Object)to).executeUpdate();
    }

    private List<Long> findDeletedMessagesInMailbox(Mailbox<Long> mailbox) {
        return this.getEntityManager().createNamedQuery("findDeletedMessagesInMailbox").setParameter("idParam", mailbox.getMailboxId()).getResultList();
    }

    private List<Long> findDeletedMessagesInMailboxAfterUID(Mailbox<Long> mailbox, long uid) {
        return this.getEntityManager().createNamedQuery("findDeletedMessagesInMailboxAfterUID").setParameter("idParam", mailbox.getMailboxId()).setParameter("uidParam", (Object)uid).getResultList();
    }

    private List<Long> findDeletedMessagesInMailboxWithUID(Mailbox<Long> mailbox, long uid) {
        return this.getEntityManager().createNamedQuery("findDeletedMessagesInMailboxWithUID").setParameter("idParam", mailbox.getMailboxId()).setParameter("uidParam", (Object)uid).setMaxResults(1).getResultList();
    }

    private List<Long> findDeletedMessagesInMailboxBetweenUIDs(Mailbox<Long> mailbox, long from, long to) {
        return this.getEntityManager().createNamedQuery("findDeletedMessagesInMailboxBetweenUIDs").setParameter("idParam", mailbox.getMailboxId()).setParameter("fromParam", (Object)from).setParameter("toParam", (Object)to).getResultList();
    }

    public long countMessagesInMailbox(Mailbox<Long> mailbox) throws MailboxException {
        try {
            return (Long)this.getEntityManager().createNamedQuery("countMessagesInMailbox").setParameter("idParam", mailbox.getMailboxId()).getSingleResult();
        }
        catch (PersistenceException e) {
            throw new MailboxException("Count of messages failed in mailbox " + mailbox, (Exception)((Object)e));
        }
    }

    public long countUnseenMessagesInMailbox(Mailbox<Long> mailbox) throws MailboxException {
        try {
            return (Long)this.getEntityManager().createNamedQuery("countUnseenMessagesInMailbox").setParameter("idParam", mailbox.getMailboxId()).getSingleResult();
        }
        catch (PersistenceException e) {
            throw new MailboxException("Count of useen messages failed in mailbox " + mailbox, (Exception)((Object)e));
        }
    }

    public void delete(Mailbox<Long> mailbox, Message<Long> message) throws MailboxException {
        try {
            this.getEntityManager().remove(message);
        }
        catch (PersistenceException e) {
            throw new MailboxException("Delete of message " + message + " failed in mailbox " + mailbox, (Exception)((Object)e));
        }
    }

    public Long findFirstUnseenMessageUid(Mailbox<Long> mailbox) throws MailboxException {
        try {
            Query query = this.getEntityManager().createNamedQuery("findUnseenMessagesInMailboxOrderByUid").setParameter("idParam", mailbox.getMailboxId());
            query.setMaxResults(1);
            List result = query.getResultList();
            if (result.isEmpty()) {
                return null;
            }
            return ((Message)result.get(0)).getUid();
        }
        catch (PersistenceException e) {
            throw new MailboxException("Search of first unseen message failed in mailbox " + mailbox, (Exception)((Object)e));
        }
    }

    public List<Message<Long>> findRecentMessagesInMailbox(Mailbox<Long> mailbox) throws MailboxException {
        try {
            Query query = this.getEntityManager().createNamedQuery("findRecentMessagesInMailbox").setParameter("idParam", mailbox.getMailboxId());
            return query.getResultList();
        }
        catch (PersistenceException e) {
            throw new MailboxException("Search of recent messages failed in mailbox " + mailbox, (Exception)((Object)e));
        }
    }

    public long add(Mailbox<Long> mailbox, Message<Long> message) throws MailboxException {
        try {
            ((AbstractJPAMessage)message).setMailbox((JPAMailbox)this.getEntityManager().find(JPAMailbox.class, mailbox.getMailboxId()));
            this.getEntityManager().persist(message);
            return message.getUid();
        }
        catch (PersistenceException e) {
            throw new MailboxException("Save of message " + message + " failed in mailbox " + mailbox, (Exception)((Object)e));
        }
        catch (ArgumentException e) {
            throw new MailboxException("Save of message " + message + " failed in mailbox " + mailbox, (Exception)((Object)e));
        }
    }

    public long copy(Mailbox<Long> mailbox, long uid, Message<Long> original) throws MailboxException {
        AbstractJPAMessage copy = original instanceof JPAStreamingMessage ? new JPAStreamingMessage((JPAMailbox)mailbox, uid, original) : new JPAMessage((JPAMailbox)mailbox, uid, original);
        return this.add(mailbox, (Message<Long>)copy);
    }

    public Iterator<UpdatedFlags> updateFlags(Mailbox<Long> mailbox, final Flags flags, final boolean value, final boolean replace, MessageRange set) throws MailboxException {
        final ArrayList updatedFlags = new ArrayList();
        this.findInMailbox(mailbox, set, new Mapper.MailboxMembershipCallback<Long>(){

            public void onMailboxMembers(List<Message<Long>> members) throws MailboxException {
                for (Message<Long> member : members) {
                    Flags originalFlags = member.createFlags();
                    if (replace) {
                        member.setFlags(flags);
                    } else {
                        Flags current = member.createFlags();
                        if (value) {
                            current.add(flags);
                        } else {
                            current.remove(flags);
                        }
                        member.setFlags(current);
                    }
                    Flags newFlags = member.createFlags();
                    JPAMessageMapper.this.getEntityManager().persist(member);
                    updatedFlags.add(new UpdatedFlags(member.getUid(), originalFlags, newFlags));
                }
            }
        });
        return updatedFlags.iterator();
    }
}

