/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailbox.jpa.user;

import java.util.List;
import javax.persistence.EntityManagerFactory;
import javax.persistence.NoResultException;
import javax.persistence.PersistenceException;
import org.apache.james.mailbox.SubscriptionException;
import org.apache.james.mailbox.jpa.JPATransactionalMapper;
import org.apache.james.mailbox.store.user.SubscriptionMapper;
import org.apache.james.mailbox.store.user.model.Subscription;

public class JPASubscriptionMapper
extends JPATransactionalMapper
implements SubscriptionMapper {
    public JPASubscriptionMapper(EntityManagerFactory entityManagerFactory) {
        super(entityManagerFactory);
    }

    public Subscription findMailboxSubscriptionForUser(String user, String mailbox) throws SubscriptionException {
        try {
            return (Subscription)this.getEntityManager().createNamedQuery("findFindMailboxSubscriptionForUser").setParameter("userParam", (Object)user).setParameter("mailboxParam", (Object)mailbox).getSingleResult();
        }
        catch (NoResultException e) {
            return null;
        }
        catch (PersistenceException e) {
            throw new SubscriptionException((Exception)((Object)e));
        }
    }

    public void save(Subscription subscription) throws SubscriptionException {
        try {
            this.getEntityManager().persist((Object)subscription);
        }
        catch (PersistenceException e) {
            throw new SubscriptionException((Exception)((Object)e));
        }
    }

    public List<Subscription> findSubscriptionsForUser(String user) throws SubscriptionException {
        try {
            return this.getEntityManager().createNamedQuery("findSubscriptionsForUser").setParameter("userParam", (Object)user).getResultList();
        }
        catch (PersistenceException e) {
            throw new SubscriptionException((Exception)((Object)e));
        }
    }

    public void delete(Subscription subscription) throws SubscriptionException {
        try {
            this.getEntityManager().remove((Object)subscription);
        }
        catch (PersistenceException e) {
            throw new SubscriptionException((Exception)((Object)e));
        }
    }
}

