/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailbox.jpa.mail;

import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import javax.persistence.PersistenceException;
import org.apache.james.mailbox.MailboxException;
import org.apache.james.mailbox.MailboxPathLocker;
import org.apache.james.mailbox.MailboxSession;
import org.apache.james.mailbox.jpa.mail.model.JPAMailbox;
import org.apache.james.mailbox.store.mail.AbstractLockingModSeqProvider;
import org.apache.james.mailbox.store.mail.model.Mailbox;

public class JPAModSeqProvider
extends AbstractLockingModSeqProvider<Long> {
    private EntityManagerFactory factory;

    public JPAModSeqProvider(MailboxPathLocker locker, EntityManagerFactory factory) {
        super(locker);
        this.factory = factory;
    }

    public long highestModSeq(MailboxSession session, Mailbox<Long> mailbox) throws MailboxException {
        EntityManager manager = null;
        try {
            manager = this.factory.createEntityManager();
            manager.getTransaction().begin();
            long highest = (Long)manager.createNamedQuery("findHighestModSeq").setParameter("idParam", mailbox.getMailboxId()).getSingleResult();
            manager.getTransaction().commit();
            long l = highest;
            return l;
        }
        catch (PersistenceException e) {
            if (manager != null && manager.getTransaction().isActive()) {
                manager.getTransaction().rollback();
            }
            throw new MailboxException("Unable to get highest mod-sequence for mailbox " + mailbox, (Exception)((Object)e));
        }
        finally {
            if (manager != null) {
                manager.close();
            }
        }
    }

    protected long lockedNextModSeq(MailboxSession session, Mailbox<Long> mailbox) throws MailboxException {
        EntityManager manager = null;
        try {
            manager = this.factory.createEntityManager();
            manager.getTransaction().begin();
            JPAMailbox m = (JPAMailbox)manager.find(JPAMailbox.class, mailbox.getMailboxId());
            long modSeq = m.consumeModSeq();
            manager.persist((Object)m);
            manager.getTransaction().commit();
            long l = modSeq;
            return l;
        }
        catch (PersistenceException e) {
            if (manager != null && manager.getTransaction().isActive()) {
                manager.getTransaction().rollback();
            }
            throw new MailboxException("Unable to save highest mod-sequence for mailbox " + mailbox, (Exception)((Object)e));
        }
        finally {
            if (manager != null) {
                manager.close();
            }
        }
    }
}

