/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailbox.jpa.openjpa;

import org.apache.james.mailbox.MailboxException;
import org.apache.james.mailbox.MailboxPathLocker;
import org.apache.james.mailbox.MailboxSession;
import org.apache.james.mailbox.jpa.JPAMailboxManager;
import org.apache.james.mailbox.jpa.JPAMailboxSessionMapperFactory;
import org.apache.james.mailbox.jpa.openjpa.OpenJPAMessageManager;
import org.apache.james.mailbox.store.Authenticator;
import org.apache.james.mailbox.store.JVMMailboxPathLocker;
import org.apache.james.mailbox.store.MailboxEventDispatcher;
import org.apache.james.mailbox.store.MailboxSessionMapperFactory;
import org.apache.james.mailbox.store.StoreMessageManager;
import org.apache.james.mailbox.store.mail.model.Mailbox;
import org.apache.james.mailbox.store.search.MessageSearchIndex;

public class OpenJPAMailboxManager
extends JPAMailboxManager {
    private boolean useStreaming;

    public OpenJPAMailboxManager(JPAMailboxSessionMapperFactory mapperFactory, Authenticator authenticator, MailboxPathLocker locker, boolean useStreaming) {
        super(mapperFactory, authenticator, locker);
        this.useStreaming = useStreaming;
    }

    public OpenJPAMailboxManager(JPAMailboxSessionMapperFactory mapperFactory, Authenticator authenticator) {
        this(mapperFactory, authenticator, (MailboxPathLocker)new JVMMailboxPathLocker(), false);
    }

    protected StoreMessageManager<Long> createMessageManager(Mailbox<Long> mailboxRow, MailboxSession session) throws MailboxException {
        OpenJPAMessageManager result = new OpenJPAMessageManager((MailboxSessionMapperFactory<Long>)this.getMapperFactory(), (MessageSearchIndex<Long>)this.getMessageSearchIndex(), (MailboxEventDispatcher<Long>)this.getEventDispatcher(), mailboxRow, this.useStreaming);
        return result;
    }
}

