/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailbox.jpa;

import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import org.apache.james.mailbox.MailboxSession;
import org.apache.james.mailbox.jpa.mail.JPAMailboxMapper;
import org.apache.james.mailbox.jpa.mail.JPAMessageMapper;
import org.apache.james.mailbox.jpa.user.JPASubscriptionMapper;
import org.apache.james.mailbox.store.MailboxSessionMapperFactory;
import org.apache.james.mailbox.store.mail.MailboxMapper;
import org.apache.james.mailbox.store.mail.MessageMapper;
import org.apache.james.mailbox.store.mail.ModSeqProvider;
import org.apache.james.mailbox.store.mail.UidProvider;
import org.apache.james.mailbox.store.user.SubscriptionMapper;

public class JPAMailboxSessionMapperFactory
extends MailboxSessionMapperFactory<Long> {
    private final EntityManagerFactory entityManagerFactory;
    private final UidProvider<Long> uidProvider;
    private final ModSeqProvider<Long> modSeqProvider;

    public JPAMailboxSessionMapperFactory(EntityManagerFactory entityManagerFactory, UidProvider<Long> uidProvider, ModSeqProvider<Long> modSeqProvider) {
        this.entityManagerFactory = entityManagerFactory;
        this.uidProvider = uidProvider;
        this.modSeqProvider = modSeqProvider;
        this.createEntityManager().close();
    }

    public MailboxMapper<Long> createMailboxMapper(MailboxSession session) {
        return new JPAMailboxMapper(this.entityManagerFactory);
    }

    public MessageMapper<Long> createMessageMapper(MailboxSession session) {
        return new JPAMessageMapper(session, this.uidProvider, this.modSeqProvider, this.entityManagerFactory);
    }

    public SubscriptionMapper createSubscriptionMapper(MailboxSession session) {
        return new JPASubscriptionMapper(this.entityManagerFactory);
    }

    private EntityManager createEntityManager() {
        return this.entityManagerFactory.createEntityManager();
    }
}

