/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailbox.jpa.mail.model.openjpa;

import java.io.IOException;
import java.io.InputStream;
import java.util.Date;
import javax.mail.Flags;
import javax.mail.internet.SharedInputStream;
import javax.mail.util.SharedByteArrayInputStream;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.Table;
import org.apache.commons.io.IOUtils;
import org.apache.james.mailbox.exception.MailboxException;
import org.apache.james.mailbox.jpa.mail.model.JPAMailbox;
import org.apache.james.mailbox.jpa.mail.model.openjpa.AbstractJPAMessage;
import org.apache.james.mailbox.store.mail.model.Message;
import org.apache.james.mailbox.store.mail.model.impl.PropertyBuilder;
import org.apache.openjpa.enhance.PCRegistry;
import org.apache.openjpa.enhance.PersistenceCapable;
import org.apache.openjpa.enhance.StateManager;
import org.apache.openjpa.persistence.Persistent;

@Entity(name="Message")
@Table(name="JAMES_MAIL")
public class JPAStreamingMessage
extends AbstractJPAMessage
implements PersistenceCapable {
    @Persistent(optional=false, fetch=FetchType.LAZY)
    @Column(name="MAIL_BYTES", length=1048576000, nullable=false)
    private InputStream body;
    @Persistent(optional=false, fetch=FetchType.LAZY)
    @Column(name="HEADER_BYTES", length=0xA00000, nullable=false)
    private InputStream header;
    private SharedInputStream content;
    private static int pcInheritedFieldCount = AbstractJPAMessage.pcGetManagedFieldCount();
    private static String[] pcFieldNames;
    private static Class[] pcFieldTypes;
    private static byte[] pcFieldFlags;
    private static Class pcPCSuperclass;
    static /* synthetic */ Class class$Lorg$apache$james$mailbox$jpa$mail$model$openjpa$AbstractJPAMessage;
    static /* synthetic */ Class class$Ljava$io$InputStream;
    static /* synthetic */ Class class$Lorg$apache$james$mailbox$jpa$mail$model$openjpa$JPAStreamingMessage;

    @Deprecated
    public JPAStreamingMessage() {
    }

    public JPAStreamingMessage(JPAMailbox mailbox, Date internalDate, int size, Flags flags, SharedInputStream content, int bodyStartOctet, PropertyBuilder propertyBuilder) throws MailboxException {
        super(mailbox, internalDate, flags, size, bodyStartOctet, propertyBuilder);
        this.content = content;
        try {
            this.header = this.getHeaderContent();
            this.body = this.getBodyContent();
        }
        catch (IOException e) {
            throw new MailboxException("Unable to parse message", (Exception)e);
        }
    }

    public JPAStreamingMessage(JPAMailbox mailbox, long uid, long modSeq, Message<?> message) throws MailboxException {
        super(mailbox, uid, modSeq, message);
        try {
            this.content = new SharedByteArrayInputStream(IOUtils.toByteArray((InputStream)message.getFullContent()));
            this.header = this.getHeaderContent();
            this.body = this.getBodyContent();
        }
        catch (IOException e) {
            throw new MailboxException("Unable to parse message", (Exception)e);
        }
    }

    public InputStream getBodyContent() throws IOException {
        return this.content.newStream((long)this.getBodyStartOctet(), -1L);
    }

    public InputStream getHeaderContent() throws IOException {
        int headerEnd = this.getBodyStartOctet() - 2;
        if (headerEnd < 0) {
            headerEnd = 0;
        }
        return this.content.newStream(0L, (long)headerEnd);
    }

    @Override
    public int pcGetEnhancementContractVersion() {
        return 2;
    }

    static {
        Class clazz = class$Lorg$apache$james$mailbox$jpa$mail$model$openjpa$AbstractJPAMessage != null ? class$Lorg$apache$james$mailbox$jpa$mail$model$openjpa$AbstractJPAMessage : (class$Lorg$apache$james$mailbox$jpa$mail$model$openjpa$AbstractJPAMessage = JPAStreamingMessage.class$("org.apache.james.mailbox.jpa.mail.model.openjpa.AbstractJPAMessage"));
        pcPCSuperclass = clazz;
        pcFieldNames = new String[]{"body", "header"};
        Class[] classArray = new Class[2];
        Class clazz2 = class$Ljava$io$InputStream != null ? class$Ljava$io$InputStream : (class$Ljava$io$InputStream = JPAStreamingMessage.class$("java.io.InputStream"));
        classArray[0] = clazz2;
        classArray[1] = class$Ljava$io$InputStream != null ? class$Ljava$io$InputStream : (class$Ljava$io$InputStream = JPAStreamingMessage.class$("java.io.InputStream"));
        pcFieldTypes = classArray;
        pcFieldFlags = new byte[]{5, 5};
        Class clazz3 = class$Lorg$apache$james$mailbox$jpa$mail$model$openjpa$JPAStreamingMessage != null ? class$Lorg$apache$james$mailbox$jpa$mail$model$openjpa$JPAStreamingMessage : (class$Lorg$apache$james$mailbox$jpa$mail$model$openjpa$JPAStreamingMessage = JPAStreamingMessage.class$("org.apache.james.mailbox.jpa.mail.model.openjpa.JPAStreamingMessage"));
        PCRegistry.register((Class)clazz3, (String[])pcFieldNames, (Class[])pcFieldTypes, (byte[])pcFieldFlags, (Class)pcPCSuperclass, (String)"Message", (PersistenceCapable)new JPAStreamingMessage());
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    @Override
    protected void pcClearFields() {
        super.pcClearFields();
        this.body = null;
        this.header = null;
    }

    @Override
    public PersistenceCapable pcNewInstance(StateManager stateManager, Object object, boolean bl) {
        JPAStreamingMessage jPAStreamingMessage = new JPAStreamingMessage();
        if (bl) {
            jPAStreamingMessage.pcClearFields();
        }
        jPAStreamingMessage.pcStateManager = stateManager;
        jPAStreamingMessage.pcCopyKeyFieldsFromObjectId(object);
        return jPAStreamingMessage;
    }

    @Override
    public PersistenceCapable pcNewInstance(StateManager stateManager, boolean bl) {
        JPAStreamingMessage jPAStreamingMessage = new JPAStreamingMessage();
        if (bl) {
            jPAStreamingMessage.pcClearFields();
        }
        jPAStreamingMessage.pcStateManager = stateManager;
        return jPAStreamingMessage;
    }

    protected static int pcGetManagedFieldCount() {
        return 2 + AbstractJPAMessage.pcGetManagedFieldCount();
    }

    @Override
    public void pcReplaceField(int n) {
        int n2 = n - pcInheritedFieldCount;
        if (n2 < 0) {
            super.pcReplaceField(n);
            return;
        }
        switch (n2) {
            case 0: {
                this.body = (InputStream)this.pcStateManager.replaceObjectField((PersistenceCapable)this, n);
                return;
            }
            case 1: {
                this.header = (InputStream)this.pcStateManager.replaceObjectField((PersistenceCapable)this, n);
                return;
            }
        }
        throw new IllegalArgumentException();
    }

    @Override
    public void pcReplaceFields(int[] nArray) {
        int n = 0;
        while (n < nArray.length) {
            this.pcReplaceField(nArray[n]);
            ++n;
        }
    }

    @Override
    public void pcProvideField(int n) {
        int n2 = n - pcInheritedFieldCount;
        if (n2 < 0) {
            super.pcProvideField(n);
            return;
        }
        switch (n2) {
            case 0: {
                this.pcStateManager.providedObjectField((PersistenceCapable)this, n, (Object)this.body);
                return;
            }
            case 1: {
                this.pcStateManager.providedObjectField((PersistenceCapable)this, n, (Object)this.header);
                return;
            }
        }
        throw new IllegalArgumentException();
    }

    @Override
    public void pcProvideFields(int[] nArray) {
        int n = 0;
        while (n < nArray.length) {
            this.pcProvideField(nArray[n]);
            ++n;
        }
    }

    protected void pcCopyField(JPAStreamingMessage jPAStreamingMessage, int n) {
        int n2 = n - pcInheritedFieldCount;
        if (n2 < 0) {
            super.pcCopyField(jPAStreamingMessage, n);
            return;
        }
        switch (n2) {
            case 0: {
                this.body = jPAStreamingMessage.body;
                return;
            }
            case 1: {
                this.header = jPAStreamingMessage.header;
                return;
            }
        }
        throw new IllegalArgumentException();
    }

    @Override
    public void pcCopyFields(Object object, int[] nArray) {
        JPAStreamingMessage jPAStreamingMessage = (JPAStreamingMessage)((Object)object);
        if (jPAStreamingMessage.pcStateManager != this.pcStateManager) {
            throw new IllegalArgumentException();
        }
        if (this.pcStateManager == null) {
            throw new IllegalStateException();
        }
        int n = 0;
        while (n < nArray.length) {
            this.pcCopyField(jPAStreamingMessage, nArray[n]);
            ++n;
        }
    }

    @Override
    public Class pcGetIDOwningClass() {
        Class clazz = class$Lorg$apache$james$mailbox$jpa$mail$model$openjpa$JPAStreamingMessage != null ? class$Lorg$apache$james$mailbox$jpa$mail$model$openjpa$JPAStreamingMessage : (class$Lorg$apache$james$mailbox$jpa$mail$model$openjpa$JPAStreamingMessage = JPAStreamingMessage.class$("org.apache.james.mailbox.jpa.mail.model.openjpa.JPAStreamingMessage"));
        return clazz;
    }

    private static final InputStream pcGetbody(JPAStreamingMessage jPAStreamingMessage) {
        if (jPAStreamingMessage.pcStateManager == null) {
            return jPAStreamingMessage.body;
        }
        int n = pcInheritedFieldCount + 0;
        jPAStreamingMessage.pcStateManager.accessingField(n);
        return jPAStreamingMessage.body;
    }

    private static final void pcSetbody(JPAStreamingMessage jPAStreamingMessage, InputStream inputStream) {
        if (jPAStreamingMessage.pcStateManager == null) {
            jPAStreamingMessage.body = inputStream;
            return;
        }
        jPAStreamingMessage.pcStateManager.settingObjectField((PersistenceCapable)jPAStreamingMessage, pcInheritedFieldCount + 0, (Object)jPAStreamingMessage.body, (Object)inputStream, 0);
    }

    private static final InputStream pcGetheader(JPAStreamingMessage jPAStreamingMessage) {
        if (jPAStreamingMessage.pcStateManager == null) {
            return jPAStreamingMessage.header;
        }
        int n = pcInheritedFieldCount + 1;
        jPAStreamingMessage.pcStateManager.accessingField(n);
        return jPAStreamingMessage.header;
    }

    private static final void pcSetheader(JPAStreamingMessage jPAStreamingMessage, InputStream inputStream) {
        if (jPAStreamingMessage.pcStateManager == null) {
            jPAStreamingMessage.header = inputStream;
            return;
        }
        jPAStreamingMessage.pcStateManager.settingObjectField((PersistenceCapable)jPAStreamingMessage, pcInheritedFieldCount + 1, (Object)jPAStreamingMessage.header, (Object)inputStream, 0);
    }
}

