/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailbox.jpa;

import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import javax.persistence.EntityTransaction;
import javax.persistence.PersistenceException;
import org.apache.james.mailbox.exception.MailboxException;
import org.apache.james.mailbox.store.transaction.TransactionalMapper;

public abstract class JPATransactionalMapper
extends TransactionalMapper {
    protected EntityManagerFactory entityManagerFactory;
    protected EntityManager entityManager;

    public JPATransactionalMapper(EntityManagerFactory entityManagerFactory) {
        this.entityManagerFactory = entityManagerFactory;
    }

    public EntityManager getEntityManager() {
        if (this.entityManager != null) {
            return this.entityManager;
        }
        this.entityManager = this.entityManagerFactory.createEntityManager();
        return this.entityManager;
    }

    protected void begin() throws MailboxException {
        try {
            this.getEntityManager().getTransaction().begin();
        }
        catch (PersistenceException e) {
            throw new MailboxException("Begin of transaction failed", (Exception)((Object)e));
        }
    }

    protected void commit() throws MailboxException {
        try {
            this.getEntityManager().getTransaction().commit();
        }
        catch (PersistenceException e) {
            throw new MailboxException("Commit of transaction failed", (Exception)((Object)e));
        }
    }

    protected void rollback() throws MailboxException {
        EntityTransaction transaction = this.entityManager.getTransaction();
        if (transaction.isActive()) {
            this.getEntityManager().getTransaction().rollback();
        }
    }

    public void endRequest() {
        if (this.entityManager != null) {
            if (this.entityManager.isOpen()) {
                this.entityManager.close();
            }
            this.entityManager = null;
        }
    }
}

