/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailbox.jpa.openjpa;

import java.util.Date;
import javax.mail.Flags;
import javax.mail.internet.SharedInputStream;
import org.apache.james.mailbox.MailboxPathLocker;
import org.apache.james.mailbox.acl.GroupMembershipResolver;
import org.apache.james.mailbox.acl.MailboxACLResolver;
import org.apache.james.mailbox.exception.MailboxException;
import org.apache.james.mailbox.jpa.JPAMessageManager;
import org.apache.james.mailbox.jpa.mail.model.JPAMailbox;
import org.apache.james.mailbox.jpa.mail.model.openjpa.JPAEncryptedMessage;
import org.apache.james.mailbox.jpa.mail.model.openjpa.JPAStreamingMessage;
import org.apache.james.mailbox.store.MailboxEventDispatcher;
import org.apache.james.mailbox.store.MailboxSessionMapperFactory;
import org.apache.james.mailbox.store.mail.model.Mailbox;
import org.apache.james.mailbox.store.mail.model.Message;
import org.apache.james.mailbox.store.mail.model.impl.PropertyBuilder;
import org.apache.james.mailbox.store.search.MessageSearchIndex;

public class OpenJPAMessageManager
extends JPAMessageManager {
    private final AdvancedFeature feature;

    public OpenJPAMessageManager(MailboxSessionMapperFactory<Long> mapperFactory, MessageSearchIndex<Long> index, MailboxEventDispatcher<Long> dispatcher, MailboxPathLocker locker, Mailbox<Long> mailbox, MailboxACLResolver aclResolver, GroupMembershipResolver groupMembershipResolver) throws MailboxException {
        this(mapperFactory, index, dispatcher, locker, mailbox, AdvancedFeature.None, aclResolver, groupMembershipResolver);
    }

    public OpenJPAMessageManager(MailboxSessionMapperFactory<Long> mapperFactory, MessageSearchIndex<Long> index, MailboxEventDispatcher<Long> dispatcher, MailboxPathLocker locker, Mailbox<Long> mailbox, AdvancedFeature f, MailboxACLResolver aclResolver, GroupMembershipResolver groupMembershipResolver) throws MailboxException {
        super(mapperFactory, index, dispatcher, locker, mailbox, aclResolver, groupMembershipResolver);
        this.feature = f;
    }

    @Override
    protected Message<Long> createMessage(Date internalDate, int size, int bodyStartOctet, SharedInputStream content, Flags flags, PropertyBuilder propertyBuilder) throws MailboxException {
        int headerEnd = bodyStartOctet - 2;
        if (headerEnd < 0) {
            headerEnd = 0;
        }
        switch (this.feature) {
            case Streaming: {
                return new JPAStreamingMessage((JPAMailbox)this.getMailboxEntity(), internalDate, size, flags, content, bodyStartOctet, propertyBuilder);
            }
            case Encryption: {
                return new JPAEncryptedMessage((JPAMailbox)this.getMailboxEntity(), internalDate, size, flags, content, bodyStartOctet, propertyBuilder);
            }
        }
        return super.createMessage(internalDate, size, bodyStartOctet, content, flags, propertyBuilder);
    }

    public static enum AdvancedFeature {
        None,
        Streaming,
        Encryption;

    }
}

