/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.managesieve.mailet;

import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Scanner;
import javax.annotation.Resource;
import javax.mail.MessagingException;
import org.apache.james.managesieve.api.Session;
import org.apache.james.managesieve.api.SieveParser;
import org.apache.james.managesieve.api.SieveRepository;
import org.apache.james.managesieve.api.commands.CoreCommands;
import org.apache.james.managesieve.core.CoreProcessor;
import org.apache.james.managesieve.mailet.transcode.MessageToCoreToMessage;
import org.apache.james.managesieve.transcode.LineToCore;
import org.apache.james.managesieve.transcode.LineToCoreToLine;
import org.apache.james.managesieve.util.SettableSession;
import org.apache.mailet.Mail;
import org.apache.mailet.MailAddress;
import org.apache.mailet.base.GenericMailet;

public class ManageSieveMailet
extends GenericMailet
implements MessageToCoreToMessage.HelpProvider {
    public static final String SMTP_AUTH_USER_ATTRIBUTE_NAME = "org.apache.james.SMTPAuthUser";
    private MailSession _session = null;
    private SieveRepository _sieveRepository = null;
    private SieveParser _sieveParser = null;
    private MessageToCoreToMessage _transcoder = null;
    private URL _helpURL = null;
    private String _help = null;
    private boolean _cache = true;

    public ManageSieveMailet() {
    }

    public ManageSieveMailet(SieveRepository sieveRepository, SieveParser sieveParser) {
        this();
        this.setSieveRepository(sieveRepository);
        this.setSieveParser(sieveParser);
    }

    public void init() throws MessagingException {
        super.init();
        if (null == this._sieveParser) {
            throw new MessagingException("Missing resource \"sieveparser\"");
        }
        if (null == this._sieveRepository) {
            throw new MessagingException("Missing resource \"sieverepository\"");
        }
        this.setHelpURL(this.getInitParameter("helpURL"));
        this._cache = this.getInitParameter("cache", true);
        this._session = new MailSession();
        this._transcoder = new MessageToCoreToMessage(new LineToCoreToLine(new LineToCore((CoreCommands)new CoreProcessor((Session)this._session, this._sieveRepository, this._sieveParser))), this);
    }

    protected void setHelpURL(String helpURL) throws MessagingException {
        try {
            this._helpURL = new URL(helpURL);
        }
        catch (MalformedURLException ex) {
            throw new MessagingException("Invalid helpURL", (Exception)ex);
        }
    }

    public void service(Mail mail) throws MessagingException {
        if (null == mail.getSender()) {
            this.getMailetContext().log("ERROR: Sender is null");
            return;
        }
        if (!this.getMailetContext().isLocalServer(mail.getSender().getDomain().toLowerCase())) {
            this.getMailetContext().log("ERROR: Sender not local");
            return;
        }
        this._session.setMail(mail);
        this.getMailetContext().sendMail(this._transcoder.execute(mail.getMessage()));
        mail.setState("ghost");
        this.clearCaches();
    }

    protected void clearCaches() {
        if (!this._cache) {
            this._help = null;
        }
    }

    @Override
    public String getHelp() throws MessagingException {
        if (null == this._help) {
            this._help = this.computeHelp();
        }
        return this._help;
    }

    protected String computeHelp() throws MessagingException {
        InputStream stream = null;
        String help = null;
        try {
            stream = this._helpURL.openStream();
            help = new Scanner(stream, "UTF-8").useDelimiter("\\A").next();
        }
        catch (IOException ex) {
            throw new MessagingException("Unable to access help URL: " + this._helpURL.toExternalForm(), (Exception)ex);
        }
        finally {
            if (null != stream) {
                try {
                    stream.close();
                }
                catch (IOException ex) {}
            }
        }
        return help;
    }

    @Resource(name="sieverepository")
    public void setSieveRepository(SieveRepository repository) {
        this._sieveRepository = repository;
    }

    @Resource(name="sieveparser")
    public void setSieveParser(SieveParser sieveParser) {
        this._sieveParser = sieveParser;
    }

    public String getMailetInfo() {
        return this.getClass().getName();
    }

    private class MailSession
    extends SettableSession {
        public void setMail(Mail mail) {
            this.setUser(this.getUser(mail.getSender()));
            this.setAuthentication(null != mail.getAttribute(ManageSieveMailet.SMTP_AUTH_USER_ATTRIBUTE_NAME));
        }

        protected String getUser(MailAddress addr) {
            return addr.getLocalPart() + '@' + (null == addr.getDomain() ? "localhost" : addr.getDomain());
        }
    }
}

