/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.managesieve.core;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.james.managesieve.api.AuthenticationRequiredException;
import org.apache.james.managesieve.api.DuplicateException;
import org.apache.james.managesieve.api.DuplicateUserException;
import org.apache.james.managesieve.api.IsActiveException;
import org.apache.james.managesieve.api.ManageSieveRuntimeException;
import org.apache.james.managesieve.api.QuotaExceededException;
import org.apache.james.managesieve.api.ScriptNotFoundException;
import org.apache.james.managesieve.api.ScriptSummary;
import org.apache.james.managesieve.api.Session;
import org.apache.james.managesieve.api.SieveParser;
import org.apache.james.managesieve.api.SieveRepository;
import org.apache.james.managesieve.api.StorageException;
import org.apache.james.managesieve.api.SyntaxException;
import org.apache.james.managesieve.api.UserNotFoundException;
import org.apache.james.managesieve.api.commands.Capability;
import org.apache.james.managesieve.api.commands.CoreCommands;

public class CoreProcessor
implements CoreCommands {
    public static final String IMPLEMENTATION_DESCRIPTION = "Apache ManageSieve v1.0";
    public static final String MANAGE_SIEVE_VERSION = "1.0";
    private SieveRepository _repository = null;
    private Session _session = null;
    private SieveParser _parser = null;

    private CoreProcessor() {
    }

    public CoreProcessor(Session session, SieveRepository repository, SieveParser parser) {
        this();
        this._session = session;
        this._repository = repository;
        this._parser = parser;
        this._session.addUserListener(new Session.UserListener(){

            public void notifyChange(String user) {
                CoreProcessor.this.ensureUser(user);
            }
        });
    }

    public Map<Capability.Capabilities, String> capability() {
        HashMap<Capability.Capabilities, String> capabilities = new HashMap<Capability.Capabilities, String>();
        capabilities.put(Capability.Capabilities.IMPLEMENTATION, IMPLEMENTATION_DESCRIPTION);
        capabilities.put(Capability.Capabilities.VERSION, MANAGE_SIEVE_VERSION);
        StringBuilder builder = new StringBuilder();
        for (String extension : this._parser.getExtensions()) {
            builder.append(extension).append(' ');
        }
        String extensions = builder.toString().trim();
        if (!extensions.isEmpty()) {
            capabilities.put(Capability.Capabilities.SIEVE, extensions);
        }
        if (this.isAuthenticated()) {
            capabilities.put(Capability.Capabilities.OWNER, this.getUser());
        }
        capabilities.put(Capability.Capabilities.GETACTIVE, null);
        return capabilities;
    }

    public List<String> checkScript(String content) throws AuthenticationRequiredException, SyntaxException {
        this.authenticationCheck();
        return this._parser.parse(content);
    }

    public void deleteScript(String name) throws AuthenticationRequiredException, ScriptNotFoundException, IsActiveException {
        this.authenticationCheck();
        try {
            this._repository.deleteScript(this.getUser(), name);
        }
        catch (StorageException ex) {
            throw new ManageSieveRuntimeException((Throwable)ex);
        }
        catch (UserNotFoundException ex) {
            throw new ManageSieveRuntimeException((Throwable)ex);
        }
    }

    public String getScript(String name) throws AuthenticationRequiredException, ScriptNotFoundException {
        this.authenticationCheck();
        String script = null;
        try {
            script = this._repository.getScript(this.getUser(), name);
        }
        catch (UserNotFoundException ex) {
            throw new ManageSieveRuntimeException((Throwable)ex);
        }
        return script;
    }

    public void haveSpace(String name, long size) throws AuthenticationRequiredException, QuotaExceededException {
        this.authenticationCheck();
        try {
            this._repository.haveSpace(this.getUser(), name, size);
        }
        catch (UserNotFoundException ex) {
            throw new ManageSieveRuntimeException((Throwable)ex);
        }
    }

    public List<ScriptSummary> listScripts() throws AuthenticationRequiredException {
        this.authenticationCheck();
        List summaries = null;
        try {
            summaries = this._repository.listScripts(this.getUser());
        }
        catch (UserNotFoundException ex) {
            throw new ManageSieveRuntimeException((Throwable)ex);
        }
        return summaries;
    }

    public List<String> putScript(String name, String content) throws AuthenticationRequiredException, SyntaxException, QuotaExceededException {
        this.authenticationCheck();
        List warnings = this._parser.parse(content);
        try {
            this._repository.putScript(this.getUser(), name, content);
        }
        catch (UserNotFoundException ex) {
            throw new ManageSieveRuntimeException((Throwable)ex);
        }
        catch (StorageException ex) {
            throw new ManageSieveRuntimeException((Throwable)ex);
        }
        return warnings;
    }

    public void renameScript(String oldName, String newName) throws AuthenticationRequiredException, ScriptNotFoundException, DuplicateException {
        this.authenticationCheck();
        try {
            this._repository.renameScript(this.getUser(), oldName, newName);
        }
        catch (UserNotFoundException ex) {
            throw new ManageSieveRuntimeException((Throwable)ex);
        }
        catch (StorageException ex) {
            throw new ManageSieveRuntimeException((Throwable)ex);
        }
    }

    public void setActive(String name) throws AuthenticationRequiredException, ScriptNotFoundException {
        this.authenticationCheck();
        try {
            this._repository.setActive(this.getUser(), name);
        }
        catch (UserNotFoundException ex) {
            throw new ManageSieveRuntimeException((Throwable)ex);
        }
        catch (StorageException ex) {
            throw new ManageSieveRuntimeException((Throwable)ex);
        }
    }

    protected String getUser() {
        return this._session.getUser();
    }

    protected void ensureUser(String user) {
        if (!this._repository.hasUser(user)) {
            try {
                this._repository.addUser(user);
            }
            catch (DuplicateUserException ex) {
                throw new ManageSieveRuntimeException((Throwable)ex);
            }
            catch (StorageException ex) {
                throw new ManageSieveRuntimeException((Throwable)ex);
            }
        }
    }

    protected void authenticationCheck() throws AuthenticationRequiredException {
        if (!this.isAuthenticated()) {
            throw new AuthenticationRequiredException();
        }
    }

    protected boolean isAuthenticated() {
        return this._session.isAuthenticated();
    }

    public String getActive() throws AuthenticationRequiredException, ScriptNotFoundException {
        this.authenticationCheck();
        String script = null;
        try {
            script = this._repository.getActive(this.getUser());
        }
        catch (UserNotFoundException ex) {
            throw new ManageSieveRuntimeException((Throwable)ex);
        }
        return script;
    }
}

