/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.managesieve.transcode;

import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.james.managesieve.api.ArgumentException;
import org.apache.james.managesieve.api.AuthenticationRequiredException;
import org.apache.james.managesieve.api.DuplicateException;
import org.apache.james.managesieve.api.IsActiveException;
import org.apache.james.managesieve.api.QuotaExceededException;
import org.apache.james.managesieve.api.ScriptNotFoundException;
import org.apache.james.managesieve.api.ScriptSummary;
import org.apache.james.managesieve.api.SyntaxException;
import org.apache.james.managesieve.api.commands.Capability;
import org.apache.james.managesieve.transcode.LineToCore;

public class LineToCoreToLine {
    private LineToCore _lineToCore = null;

    private LineToCoreToLine() {
    }

    public LineToCoreToLine(LineToCore lineToCore) {
        this();
        this._lineToCore = lineToCore;
    }

    public String capability(String args) {
        Set<Map.Entry<Capability.Capabilities, String>> entries = null;
        try {
            entries = this._lineToCore.capability(args).entrySet();
        }
        catch (ArgumentException ex) {
            return "NO \"" + ex.getMessage() + "\"";
        }
        StringBuilder builder = new StringBuilder();
        for (Map.Entry<Capability.Capabilities, String> entry : entries) {
            builder.append(entry.getKey().toString()).append(' ').append(null == entry.getValue() ? "" : entry.getValue()).append("\r\n");
        }
        builder.append("OK");
        return builder.toString();
    }

    public String checkScript(String args) {
        List<String> warnings = null;
        try {
            warnings = this._lineToCore.checkScript(args);
        }
        catch (AuthenticationRequiredException ex) {
            return "NO";
        }
        catch (ArgumentException ex) {
            return "NO \"" + ex.getMessage() + "\"";
        }
        catch (SyntaxException ex) {
            return "NO \"Syntax Error: " + ex.getMessage() + "\"";
        }
        StringBuilder builder = new StringBuilder();
        if (!warnings.isEmpty()) {
            builder.append("OK (WARNINGS)");
            for (String warning : warnings) {
                builder.append(" \"").append(warning).append('\"');
            }
        } else {
            builder.append("OK");
        }
        return builder.toString();
    }

    public String deleteScript(String args) {
        try {
            this._lineToCore.deleteScript(args);
        }
        catch (AuthenticationRequiredException ex) {
            return "NO";
        }
        catch (ScriptNotFoundException ex) {
            return "NO (NONEXISTENT) \"There is no script by that name\"";
        }
        catch (IsActiveException ex) {
            return "NO (ACTIVE) \"You may not delete an active script\"";
        }
        catch (ArgumentException ex) {
            return "NO \"" + ex.getMessage() + "\"";
        }
        return "OK";
    }

    public String getScript(String args) {
        String content = null;
        try {
            content = this._lineToCore.getScript(args);
        }
        catch (AuthenticationRequiredException ex) {
            return "NO";
        }
        catch (ScriptNotFoundException ex) {
            return "NO (NONEXISTENT) \"There is no script by that name\"";
        }
        catch (ArgumentException ex) {
            return "NO \"" + ex.getMessage() + "\"";
        }
        StringBuilder builder = new StringBuilder(content);
        builder.append("\r\n").append("OK");
        return builder.toString();
    }

    public String haveSpace(String args) {
        try {
            this._lineToCore.haveSpace(args);
        }
        catch (AuthenticationRequiredException ex) {
            return "NO";
        }
        catch (QuotaExceededException ex) {
            return "NO (QUOTA/MAXSIZE) \"Quota exceeded\"";
        }
        catch (ArgumentException ex) {
            return "NO \"" + ex.getMessage() + "\"";
        }
        return "OK";
    }

    public String listScripts(String args) {
        List<ScriptSummary> summaries = null;
        try {
            summaries = this._lineToCore.listScripts(args);
        }
        catch (AuthenticationRequiredException ex) {
            return "NO";
        }
        catch (ArgumentException ex) {
            return "NO \"" + ex.getMessage() + "\"";
        }
        StringBuilder builder = new StringBuilder();
        for (ScriptSummary summary : summaries) {
            builder.append('\"').append(summary.getName()).append('\"');
            if (summary.isActive()) {
                builder.append(' ').append("ACTIVE");
            }
            builder.append("\r\n");
        }
        builder.append("OK");
        return builder.toString();
    }

    public String putScript(String args) {
        List<String> warnings = null;
        try {
            warnings = this._lineToCore.putScript(args);
        }
        catch (AuthenticationRequiredException ex) {
            return "NO";
        }
        catch (SyntaxException ex) {
            return "NO \"Syntax Error: " + ex.getMessage() + "\"";
        }
        catch (QuotaExceededException ex) {
            return "NO (QUOTA/MAXSIZE) \"Quota exceeded\"";
        }
        catch (ArgumentException ex) {
            return "NO \"" + ex.getMessage() + "\"";
        }
        StringBuilder builder = new StringBuilder();
        if (!warnings.isEmpty()) {
            builder.append("OK (WARNINGS)");
            for (String warning : warnings) {
                builder.append(" \"").append(warning).append('\"');
            }
        } else {
            builder.append("OK");
        }
        return builder.toString();
    }

    public String renameScript(String args) {
        try {
            this._lineToCore.renameScript(args);
        }
        catch (AuthenticationRequiredException ex) {
            return "NO";
        }
        catch (ScriptNotFoundException ex) {
            return "NO (NONEXISTENT) \"There is no script by that name\"";
        }
        catch (DuplicateException ex) {
            return "NO (ALREADYEXISTS) \"A script with that name already exists\"";
        }
        catch (ArgumentException ex) {
            return "NO \"" + ex.getMessage() + "\"";
        }
        return "OK";
    }

    public String setActive(String args) {
        try {
            this._lineToCore.setActive(args);
        }
        catch (AuthenticationRequiredException ex) {
            return "NO";
        }
        catch (ScriptNotFoundException ex) {
            return "NO (NONEXISTENT) \"There is no script by that name\"";
        }
        catch (ArgumentException ex) {
            return "NO \"" + ex.getMessage() + "\"";
        }
        return "OK";
    }

    public String getActive(String args) {
        String content = null;
        try {
            content = this._lineToCore.getActive(args);
        }
        catch (AuthenticationRequiredException ex) {
            return "NO";
        }
        catch (ScriptNotFoundException ex) {
            return "NO (NONEXISTENT) \"" + ex.getMessage() + "\"";
        }
        catch (ArgumentException ex) {
            return "NO \"" + ex.getMessage() + "\"";
        }
        StringBuilder builder = new StringBuilder(content);
        builder.append("\r\n").append("OK");
        return builder.toString();
    }
}

