/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jsieve.util;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.jsieve.NumberArgument;
import org.apache.jsieve.TagArgument;
import org.apache.jsieve.parser.generated.ASTargument;
import org.apache.jsieve.parser.generated.ASTarguments;
import org.apache.jsieve.parser.generated.ASTblock;
import org.apache.jsieve.parser.generated.ASTcommand;
import org.apache.jsieve.parser.generated.ASTcommands;
import org.apache.jsieve.parser.generated.ASTstart;
import org.apache.jsieve.parser.generated.ASTstring;
import org.apache.jsieve.parser.generated.ASTstring_list;
import org.apache.jsieve.parser.generated.ASTtest;
import org.apache.jsieve.parser.generated.ASTtest_list;
import org.apache.jsieve.parser.generated.SimpleNode;
import org.apache.jsieve.util.HaltTraversalException;
import org.apache.jsieve.util.NodeHandler;
import org.apache.jsieve.util.SieveHandler;

public class NodeToSieveAdapter
implements NodeHandler {
    private static final Log LOG = LogFactory.getLog(NodeToSieveAdapter.class);
    private final SieveHandler handler;

    public NodeToSieveAdapter(SieveHandler handler) {
        if (handler == null) {
            throw new NullPointerException("Handler must not be null");
        }
        this.handler = handler;
    }

    public void start() throws HaltTraversalException {
    }

    public void end() throws HaltTraversalException {
    }

    public void end(SimpleNode node) throws HaltTraversalException {
    }

    public void end(ASTstart node) throws HaltTraversalException {
        this.handler.endScript();
    }

    public void end(ASTcommands node) throws HaltTraversalException {
        this.handler.endCommands();
    }

    public void end(ASTcommand node) throws HaltTraversalException {
        this.handler.endCommand(node.getName());
    }

    public void end(ASTblock node) throws HaltTraversalException {
        this.handler.endBlock();
    }

    public void end(ASTarguments node) throws HaltTraversalException {
        this.handler.endArguments();
    }

    public void end(ASTargument node) throws HaltTraversalException {
    }

    public void end(ASTtest node) throws HaltTraversalException {
        String name = node.getName();
        this.handler.endTest(name);
    }

    public void end(ASTtest_list node) throws HaltTraversalException {
        this.handler.endTestList();
    }

    public void end(ASTstring node) throws HaltTraversalException {
    }

    public void end(ASTstring_list node) throws HaltTraversalException {
        this.handler.endStringListArgument();
    }

    public void start(SimpleNode node) throws HaltTraversalException {
    }

    public void start(ASTstart node) throws HaltTraversalException {
        this.handler.startScript();
    }

    public void start(ASTcommands node) throws HaltTraversalException {
        this.handler.startCommands();
    }

    public void start(ASTcommand node) throws HaltTraversalException {
        this.handler.startCommand(node.getName());
    }

    public void start(ASTblock node) throws HaltTraversalException {
        this.handler.startBlock();
    }

    public void start(ASTarguments node) throws HaltTraversalException {
        this.handler.startArguments();
    }

    public void start(ASTargument node) throws HaltTraversalException {
        Object value = node.getValue();
        if (value == null) {
            LOG.debug((Object)"Ignoring null argument");
        } else if (value instanceof NumberArgument) {
            NumberArgument numberArgument = (NumberArgument)value;
            Integer integer = numberArgument.getInteger();
            if (integer == null) {
                LOG.debug((Object)"Ignoring null numeric argument");
            } else {
                int number = integer;
                this.handler.argument(number);
            }
        } else if (value instanceof TagArgument) {
            TagArgument tagArgument = (TagArgument)value;
            String tag = tagArgument.getTag();
            String identifier = tag.charAt(0) == ':' ? tag.substring(1) : tag;
            this.handler.argument(identifier);
        }
    }

    public void start(ASTtest node) throws HaltTraversalException {
        String name = node.getName();
        this.handler.startTest(name);
    }

    public void start(ASTtest_list node) throws HaltTraversalException {
        this.handler.startTestList();
    }

    public void start(ASTstring node) throws HaltTraversalException {
        String string = (String)node.getValue();
        this.handler.listMember(string);
    }

    public void start(ASTstring_list node) throws HaltTraversalException {
        this.handler.startStringListArgument();
    }
}

