/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jsieve.util.check;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import javax.mail.Header;
import javax.mail.Message;
import javax.mail.MessagingException;
import org.apache.jsieve.SieveContext;
import org.apache.jsieve.exception.SieveException;
import org.apache.jsieve.mail.Action;
import org.apache.jsieve.mail.MailAdapter;
import org.apache.jsieve.mail.MailUtils;
import org.apache.jsieve.mail.SieveMailException;
import org.apache.jsieve.parser.address.SieveAddressBuilder;
import org.apache.jsieve.parser.generated.address.ParseException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ScriptCheckMailAdapter
implements MailAdapter {
    private final List<Action> actions = new ArrayList<Action>();
    private final List<Action> executedActions = new ArrayList<Action>();
    private Message mail = null;

    public Message getMail() {
        return this.mail;
    }

    public void setMail(Message mail) {
        this.mail = mail;
        this.reset();
    }

    public void addAction(Action action) {
        this.actions.add(action);
    }

    public void executeActions() throws SieveException {
        this.executedActions.clear();
        this.executedActions.addAll(this.actions);
    }

    public List<Action> getExecutedActions() {
        ArrayList<Action> result = new ArrayList<Action>(this.executedActions);
        return result;
    }

    public List<Action> getActions() {
        List<Action> result = Collections.unmodifiableList(this.actions);
        return result;
    }

    public void reset() {
        this.executedActions.clear();
        this.actions.clear();
    }

    public List<String> getHeader(String name) throws SieveMailException {
        List<String> result = Collections.EMPTY_LIST;
        if (this.mail != null) {
            try {
                String[] values = this.mail.getHeader(name);
                if (values != null) {
                    result = Arrays.asList(values);
                }
            }
            catch (MessagingException e) {
                throw new SieveMailException((Throwable)e);
            }
        }
        return result;
    }

    public List<String> getHeaderNames() throws SieveMailException {
        ArrayList<String> results = Collections.EMPTY_LIST;
        if (this.mail != null) {
            try {
                results = new ArrayList<String>();
                Enumeration en = this.mail.getAllHeaders();
                while (en.hasMoreElements()) {
                    Header header = (Header)en.nextElement();
                    String name = header.getName();
                    if (results.contains(name)) continue;
                    results.add(name);
                }
            }
            catch (MessagingException e) {
                throw new SieveMailException((Throwable)e);
            }
        }
        return results;
    }

    public List<String> getMatchingHeader(String name) throws SieveMailException {
        List result = Collections.EMPTY_LIST;
        if (this.mail != null) {
            result = MailUtils.getMatchingHeader((MailAdapter)this, (String)name);
        }
        return result;
    }

    public int getSize() throws SieveMailException {
        int result = 0;
        if (this.mail != null) {
            try {
                result = this.mail.getSize();
            }
            catch (MessagingException e) {
                throw new SieveMailException((Throwable)e);
            }
        }
        return result;
    }

    public String getContentType() throws SieveMailException {
        String result = null;
        if (this.mail != null) {
            try {
                result = this.mail.getContentType();
            }
            catch (MessagingException e) {
                throw new SieveMailException((Throwable)e);
            }
        }
        return result;
    }

    public MailAdapter.Address[] parseAddresses(String headerName) throws SieveMailException {
        return this.parseAddresses(headerName, this.mail);
    }

    public MailAdapter.Address[] parseAddresses(String headerName, Message message) throws SieveMailException {
        try {
            SieveAddressBuilder builder = new SieveAddressBuilder();
            Enumeration en = message.getAllHeaders();
            while (en.hasMoreElements()) {
                Header header = (Header)en.nextElement();
                String name = header.getName();
                if (!name.trim().equalsIgnoreCase(headerName)) continue;
                builder.addAddresses(header.getValue());
            }
            MailAdapter.Address[] results = builder.getAddresses();
            return results;
        }
        catch (MessagingException ex) {
            throw new SieveMailException((Throwable)ex);
        }
        catch (ParseException ex) {
            throw new SieveMailException((Throwable)ex);
        }
    }

    public boolean isInBodyText(String phraseCaseInsensitive) throws SieveMailException {
        boolean result = false;
        if (this.mail != null) {
            try {
                result = this.mail.getContent().toString().toLowerCase().contains(phraseCaseInsensitive);
            }
            catch (MessagingException e) {
                throw new SieveMailException((Throwable)e);
            }
            catch (IOException e) {
                throw new SieveMailException((Throwable)e);
            }
        }
        return result;
    }

    public void setContext(SieveContext context) {
    }
}

