/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.managesieve.mock;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.james.managesieve.api.DuplicateException;
import org.apache.james.managesieve.api.DuplicateUserException;
import org.apache.james.managesieve.api.IsActiveException;
import org.apache.james.managesieve.api.QuotaExceededException;
import org.apache.james.managesieve.api.QuotaNotFoundException;
import org.apache.james.managesieve.api.ScriptNotFoundException;
import org.apache.james.managesieve.api.ScriptSummary;
import org.apache.james.managesieve.api.SieveRepository;
import org.apache.james.managesieve.api.StorageException;
import org.apache.james.managesieve.api.UserNotFoundException;

public class MockSieveRepository
implements SieveRepository {
    Map<String, Map<String, SieveScript>> _repository = new HashMap<String, Map<String, SieveScript>>();

    public void addUser(String user) throws DuplicateUserException, StorageException {
        if (this._repository.containsKey(user)) {
            throw new DuplicateUserException(user);
        }
        this._repository.put(user, new HashMap());
    }

    public void deleteScript(String user, String name) throws UserNotFoundException, ScriptNotFoundException, IsActiveException, StorageException {
        if (!this._repository.containsKey(user)) {
            throw new UserNotFoundException(user);
        }
        SieveScript script = this._repository.get(user).get(name);
        if (null == script) {
            throw new ScriptNotFoundException(name);
        }
        if (script.isActive()) {
            throw new IsActiveException(name);
        }
        this._repository.get(user).remove(name);
    }

    public String getActive(String user) throws UserNotFoundException, ScriptNotFoundException {
        if (!this._repository.containsKey(user)) {
            throw new UserNotFoundException(user);
        }
        Set<Map.Entry<String, SieveScript>> scripts = this._repository.get(user).entrySet();
        String content = null;
        for (Map.Entry<String, SieveScript> entry : scripts) {
            if (!entry.getValue().isActive()) continue;
            content = entry.getValue().getContent();
            break;
        }
        if (null == content) {
            throw new ScriptNotFoundException();
        }
        return content;
    }

    public long getQuota() throws QuotaNotFoundException {
        return 0L;
    }

    public long getQuota(String user) throws UserNotFoundException, QuotaNotFoundException {
        return 0L;
    }

    public String getScript(String user, String name) throws UserNotFoundException, ScriptNotFoundException {
        if (!this._repository.containsKey(user)) {
            throw new UserNotFoundException(user);
        }
        SieveScript script = this._repository.get(user).get(name);
        if (null == script) {
            throw new ScriptNotFoundException(name);
        }
        return script.getContent();
    }

    public boolean hasQuota() {
        return false;
    }

    public boolean hasQuota(String user) throws UserNotFoundException {
        return false;
    }

    public boolean hasUser(String user) {
        return this._repository.containsKey(user);
    }

    public void haveSpace(String user, String name, long size) throws UserNotFoundException, QuotaExceededException {
        if (!this._repository.containsKey(user)) {
            throw new UserNotFoundException(user);
        }
    }

    public List<ScriptSummary> listScripts(String user) throws UserNotFoundException {
        if (!this._repository.containsKey(user)) {
            throw new UserNotFoundException(user);
        }
        Set<Map.Entry<String, SieveScript>> scripts = this._repository.get(user).entrySet();
        ArrayList<ScriptSummary> summaries = new ArrayList<ScriptSummary>(scripts.size());
        for (final Map.Entry<String, SieveScript> entry : scripts) {
            summaries.add(new ScriptSummary(){

                public String getName() {
                    return (String)entry.getKey();
                }

                public boolean isActive() {
                    return ((SieveScript)entry.getValue()).isActive();
                }
            });
        }
        return summaries;
    }

    public void putScript(String user, String name, String content) throws UserNotFoundException, StorageException, QuotaExceededException {
        if (!this._repository.containsKey(user)) {
            throw new UserNotFoundException(user);
        }
        Map<String, SieveScript> scripts = this._repository.get(user);
        scripts.put(name, new SieveScript(content, false));
    }

    public void removeQuota() throws QuotaNotFoundException, StorageException {
    }

    public void removeQuota(String user) throws UserNotFoundException, QuotaNotFoundException, StorageException {
    }

    public void removeUser(String user) throws UserNotFoundException, StorageException {
    }

    public void renameScript(String user, String oldName, String newName) throws UserNotFoundException, ScriptNotFoundException, DuplicateException, StorageException {
    }

    public void setActive(String user, String name) throws UserNotFoundException, ScriptNotFoundException, StorageException {
        Map.Entry<String, SieveScript> oldActive = null;
        oldActive = this.getActiveEntry(user);
        if (null != oldActive) {
            oldActive.getValue().setActive(false);
        }
        if (null != name && !name.trim().isEmpty()) {
            if (this._repository.get(user).containsKey(name)) {
                this._repository.get(user).get(name).setActive(true);
            } else {
                if (null != oldActive) {
                    oldActive.getValue().setActive(true);
                }
                throw new ScriptNotFoundException();
            }
        }
    }

    protected Map.Entry<String, SieveScript> getActiveEntry(String user) {
        Set<Map.Entry<String, SieveScript>> scripts = this._repository.get(user).entrySet();
        Map.Entry<String, SieveScript> activeEntry = null;
        for (Map.Entry<String, SieveScript> entry : scripts) {
            if (!entry.getValue().isActive()) continue;
            activeEntry = entry;
            break;
        }
        return activeEntry;
    }

    public void setQuota(long quota) throws StorageException {
    }

    public void setQuota(String user, long quota) throws UserNotFoundException, StorageException {
    }

    public class SieveScript {
        private String _name = null;
        private String _content = null;
        private boolean _isActive = false;

        private SieveScript() {
        }

        public SieveScript(String content, boolean isActive) {
            this();
            this.setContent(content);
            this.setActive(isActive);
        }

        public String getName() {
            return this._name;
        }

        public void setName(String name) {
            this._name = name;
        }

        public String getContent() {
            return this._content;
        }

        public void setContent(String content) {
            this._content = content;
        }

        public boolean isActive() {
            return this._isActive;
        }

        public void setActive(boolean isActive) {
            this._isActive = isActive;
        }
    }
}

