/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jsieve.mailet;

import java.util.ArrayList;
import javax.mail.MessagingException;
import javax.mail.internet.InternetAddress;
import org.apache.commons.logging.Log;
import org.apache.jsieve.mail.Action;
import org.apache.jsieve.mail.ActionRedirect;
import org.apache.jsieve.mailet.ActionContext;
import org.apache.jsieve.mailet.ActionUtils;
import org.apache.jsieve.mailet.MailAction;
import org.apache.mailet.Mail;
import org.apache.mailet.MailAddress;

public class RedirectAction
implements MailAction {
    public void execute(Action action, Mail mail, ActionContext context) throws MessagingException {
        if (action instanceof ActionRedirect) {
            ActionRedirect actionRedirect = (ActionRedirect)action;
            this.execute(actionRedirect, mail, context);
        }
    }

    public void execute(ActionRedirect anAction, Mail aMail, ActionContext context) throws MessagingException {
        ActionUtils.detectAndHandleLocalLooping(aMail, context, "redirect");
        ArrayList<MailAddress> recipients = new ArrayList<MailAddress>(1);
        recipients.add(new MailAddress(new InternetAddress(anAction.getAddress())));
        MailAddress sender = aMail.getSender();
        context.post(sender, recipients, aMail.getMessage());
        aMail.setState("ghost");
        Log log = context.getLog();
        if (log.isDebugEnabled()) {
            log.debug((Object)("Redirected Message ID: " + aMail.getMessage().getMessageID() + " to \"" + anAction.getAddress() + "\""));
        }
    }
}

