/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.managesieve.transcode;

import java.util.InputMismatchException;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Scanner;
import org.apache.james.managesieve.api.ArgumentException;
import org.apache.james.managesieve.api.AuthenticationRequiredException;
import org.apache.james.managesieve.api.DuplicateException;
import org.apache.james.managesieve.api.IsActiveException;
import org.apache.james.managesieve.api.QuotaExceededException;
import org.apache.james.managesieve.api.ScriptNotFoundException;
import org.apache.james.managesieve.api.ScriptSummary;
import org.apache.james.managesieve.api.SyntaxException;
import org.apache.james.managesieve.api.commands.Capability;
import org.apache.james.managesieve.api.commands.CoreCommands;
import org.apache.james.managesieve.util.ParserUtils;

public class LineToCore {
    private CoreCommands _core = null;

    private LineToCore() {
    }

    public LineToCore(CoreCommands core) {
        this();
        this._core = core;
    }

    public Map<Capability.Capabilities, String> capability(String args) throws ArgumentException {
        if (!args.trim().isEmpty()) {
            throw new ArgumentException("Too many arguments: " + args);
        }
        return this._core.capability();
    }

    public void deleteScript(String args) throws AuthenticationRequiredException, ScriptNotFoundException, IsActiveException, ArgumentException {
        String scriptName = ParserUtils.getScriptName(args);
        if (null == scriptName || scriptName.isEmpty()) {
            throw new ArgumentException("Missing argument: script name");
        }
        Scanner scanner = new Scanner(args.substring(scriptName.length()).trim()).useDelimiter("\\A");
        if (scanner.hasNext()) {
            throw new ArgumentException("Too many arguments: " + scanner.next());
        }
        this._core.deleteScript(ParserUtils.unquote(scriptName));
    }

    public String getScript(String args) throws AuthenticationRequiredException, ScriptNotFoundException, ArgumentException {
        String scriptName = ParserUtils.getScriptName(args);
        if (null == scriptName || scriptName.isEmpty()) {
            throw new ArgumentException("Missing argument: script name");
        }
        Scanner scanner = new Scanner(args.substring(scriptName.length()).trim()).useDelimiter("\\A");
        if (scanner.hasNext()) {
            throw new ArgumentException("Too many arguments: " + scanner.next());
        }
        return this._core.getScript(ParserUtils.unquote(scriptName));
    }

    public List<String> checkScript(String args) throws ArgumentException, AuthenticationRequiredException, SyntaxException {
        if (args.trim().isEmpty()) {
            throw new ArgumentException("Missing argument: script content");
        }
        return this._core.checkScript(args);
    }

    public void haveSpace(String args) throws AuthenticationRequiredException, QuotaExceededException, ArgumentException {
        String scriptName = ParserUtils.getScriptName(args);
        if (null == scriptName || scriptName.isEmpty()) {
            throw new ArgumentException("Missing argument: script name");
        }
        Scanner scanner = new Scanner(args.substring(scriptName.length()).trim());
        long size = 0L;
        try {
            size = scanner.nextLong();
        }
        catch (InputMismatchException ex) {
            throw new ArgumentException("Invalid argument: script size");
        }
        catch (NoSuchElementException ex) {
            throw new ArgumentException("Missing argument: script size");
        }
        scanner.useDelimiter("\\A");
        if (scanner.hasNext()) {
            throw new ArgumentException("Too many arguments: " + scanner.next().trim());
        }
        this._core.haveSpace(ParserUtils.unquote(scriptName), size);
    }

    public List<ScriptSummary> listScripts(String args) throws AuthenticationRequiredException, ArgumentException {
        if (!args.trim().isEmpty()) {
            throw new ArgumentException("Too many arguments: " + args);
        }
        return this._core.listScripts();
    }

    public List<String> putScript(String args) throws AuthenticationRequiredException, SyntaxException, QuotaExceededException, ArgumentException {
        String scriptName = ParserUtils.getScriptName(args);
        if (null == scriptName || scriptName.isEmpty()) {
            throw new ArgumentException("Missing argument: script name");
        }
        Scanner scanner = new Scanner(args.substring(scriptName.length()).trim()).useDelimiter("\\A");
        if (!scanner.hasNext()) {
            throw new ArgumentException("Missing argument: script content");
        }
        String content = scanner.next();
        return this._core.putScript(ParserUtils.unquote(scriptName), content);
    }

    public void renameScript(String args) throws AuthenticationRequiredException, ScriptNotFoundException, DuplicateException, ArgumentException {
        String oldName = ParserUtils.getScriptName(args);
        if (null == oldName || oldName.isEmpty()) {
            throw new ArgumentException("Missing argument: old script name");
        }
        String newName = ParserUtils.getScriptName(args.substring(oldName.length()));
        if (null == newName || newName.isEmpty()) {
            throw new ArgumentException("Missing argument: new script name");
        }
        Scanner scanner = new Scanner(args.substring(oldName.length() + 1 + newName.length()).trim()).useDelimiter("\\A");
        if (scanner.hasNext()) {
            throw new ArgumentException("Too many arguments: " + scanner.next());
        }
        this._core.renameScript(oldName, newName);
    }

    public void setActive(String args) throws AuthenticationRequiredException, ScriptNotFoundException, ArgumentException {
        String scriptName = ParserUtils.getScriptName(args);
        if (null == scriptName || scriptName.isEmpty()) {
            throw new ArgumentException("Missing argument: script name");
        }
        Scanner scanner = new Scanner(args.substring(scriptName.length()).trim()).useDelimiter("\\A");
        if (scanner.hasNext()) {
            throw new ArgumentException("Too many arguments: " + scanner.next());
        }
        this._core.setActive(ParserUtils.unquote(scriptName));
    }

    public String getActive(String args) throws AuthenticationRequiredException, ScriptNotFoundException, ArgumentException {
        Scanner scanner = new Scanner(args.trim()).useDelimiter("\\A");
        if (scanner.hasNext()) {
            throw new ArgumentException("Too many arguments: " + scanner.next());
        }
        return this._core.getActive();
    }
}

